﻿Tariscope.Date = (function () {
    var _minDate = new Date(1900, 01, 01);
    var _maxDate = new Date(3000, 01, 01);
    var _currentDate = new Date();

    return {
        // get the minimum date
        getMinDate: function () {
            return _minDate;
        },

        // get the maximum date
        getMaxDate: function () {
            return _maxDate;
        },

        // get current date
        getCureentDate: function () {
            return _currentDate;
        },

        // format: dd-MM-yyyy
        getDateString: function (date) { 
            var day = (date.getDate() < 10) ? "0" + date.getDate() : date.getDate();
            var month = (date.getMonth() < 10) ? "0" + date.getMonth() : date.getMonth();
            var year = date.getFullYear();

            return minDateStr = year + "-" + month + "-" + day;
        }
    }
})();

// Tests 
(function () {
    var minDate = Tariscope.Date.getMinDate();
    var maxDate = Tariscope.Date.getMaxDate();

    var strMinDate = Tariscope.Date.getDateString(minDate);
    var strMaxDate = Tariscope.Date.getDateString(maxDate);

    console.log("minDate: " + minDate);
    console.log("maxDate: " + maxDate);
    console.log("strMinDate: " + strMinDate);
    console.log("strMaxDate: " + strMaxDate);
})();
