var Tariscope = Tariscope || {};


Tariscope.Routes = (function () {
    return {
        // abonents
        getAbonentList: function () { return "/api/abonents/list" },
        getAbonentTree: function () { return "/api/abonents/tree" },

        getDepartments: function(abonentId) { return "/api/abonents/" + abonentId + "/departments" },
        editDepartment: function (abonentId, gtoup) { return "/api/abonents/" + abonentId },

        editAbonentName: function (abonentId, name) { return "/api/abonents/" + abonentId + "/name/" + name },
        getAbonentCount: function() { return "/api/abonents/count" },

        createAbonent: function () { return "/api/abonents/create" },
        editAbonent: function (abonentId) { return "/api/abonents/"  + abonentId + "/edit" },
        removeAbonent: function (abonentId) { return "api/abonents/"  + abonentId + "/remove" },
        getAbonentSummary: function (abonentId) { return "/api/abonents/" +  + abonentId + "/summary" },
        
        //etc..

    }
})();
Tariscope.Date = (function () {
    var _minDate = new Date(1900, 01, 01);
    var _maxDate = new Date(3000, 01, 01);
    var _currentDate = new Date();

    return {
        // get the minimum date
        getMinDate: function () {
            return _minDate;
        },

        // get the maximum date
        getMaxDate: function () {
            return _maxDate;
        },

        // get current date
        getCureentDate: function () {
            return _currentDate;
        },

        // format: dd-MM-yyyy
        getDateString: function (date) { 
            var day = (date.getDate() < 10) ? "0" + date.getDate() : date.getDate();
            var month = (date.getMonth() < 10) ? "0" + date.getMonth() : date.getMonth();
            var year = date.getFullYear();

            return minDateStr = year + "-" + month + "-" + day;
        }
    }
})();

// Tests 
(function () {
    var minDate = Tariscope.Date.getMinDate();
    var maxDate = Tariscope.Date.getMaxDate();

    var strMinDate = Tariscope.Date.getDateString(minDate);
    var strMaxDate = Tariscope.Date.getDateString(maxDate);

    console.log("minDate: " + minDate);
    console.log("maxDate: " + maxDate);
    console.log("strMinDate: " + strMinDate);
    console.log("strMaxDate: " + strMaxDate);
})();

Tariscope.Cookie = (function () {
    var _minDate = Tariscope.Date.getMinDate();
    var _maxDate = Tariscope.Date.getMaxDate();

    return {
        // create a new cookie
        create: function (name, value, expireYear, expireMonth, expireDay, path, domain, secure) {
            var cookie_string = name + "=" + escape(value);

            if (exp_y) {
                var expires = new Date(expireYear, expireMonth, expireDay);
                cookie_string += "; expires=" + expires.toGMTString();
            }

            if (path) cookie_string += "; path=" + escape(path);
            if (domain) cookie_string += "; domain=" + escape(domain);
            if (secure) cookie_string += "; secure";

            document.cookie = cookie_string;
        },

        // get cookie
        get: function (cookieName) {
            var results = document.cookie.match('(^|;) ?' + cookieName + '=([^;]*)(;|$)');

            if (results) {
                return (unescape(results[2]));
            }
            else {
                return null;
            }
        },

        // remove cookie
        remove: function (cookieName) {
            var currentDate = new Date();
            currentDate.setTime(currentDate.getTime() - 1);
            document.cookie = cookieName += "=; expires=" + currentDate.toGMTString();
        }
    }
})();
Tariscope.Abonents = (function () {
    

    return {
        // get list of abonents
        getList: function() { 
            $.get(Tariscope.Routes.getAbonentList(), function (data) {
                return data;
            });
        },

        // get tree of abonents
        getTree: function() { 
            $.get(Tariscope.Routes.getAbonentTree(), function (data) {
                return data;
            });
        },

        // get abonent
        get: function() { 

        },

        // get count
        count: function () {
            $.ajax({
                url: Tariscope.Routes.getAbonentCount(),
                method: "GET",
                async: false,
                success: function (data) {
                    count = data;
                },
            });

            return count;
        },

        // create a new abonent
        create: function () { 

        },

        // edit abonent
        edit: function (abonentId) {
            $.ajax({
                type: "PUT",
                url: "/api/abonents/" + abonentId,
                contentType: "application/json",
                data: JSON.stringify(abonent),
                dataType: "json",
            })
        },

        // remove abonent
        remove: function (abonentId) { 
            $.post("/api/abonents/remove/" + abonentId);
        }
    }
})();

// Tests
(function () {
    var count = Tariscope.Abonents.count();
    console.log(count);
})();