﻿$(document).ready(function () {

    var _selectedNodes = [];
    var _selectedPbxs = [];
    var _selectedSource = null;
    var _selectedDestination = null;
    var _openDialogLinkId = "";

    SelectedNodesAndPBXs = {};

    if (CurrentFilter != null) {
        var listOfNodesAndPBXs = _getCurrentNodesAndPBXs(CurrentFilter.Nodes, CurrentFilter.Pbxs);
        SelectedNodesAndPBXs = _getNodesAndPBXsModels(listOfNodesAndPBXs);
    }
    

    function _getNodesAndPBXsModels(list) {
        let result = {}
        $.ajax({
            type: 'POST',
            url: '/api/pbxs/equipmentbyids',
            contentType: 'application/json',
            async: false,
            data: JSON.stringify(list),
            success: function (data) {
                result = data;
            },
            dataType: 'json'
        });
        return result;
    }

    function _getCurrentNodesAndPBXs(nodes, pbxs) {
        var result = [];

        $.each(nodes, function () {
            result.push('n' + this);
        });
        $.each(pbxs, function () {
            result.push('p' + this);
        });
        return result;
    }

    if (CurrentFilter != null)
        fillFilter();

    var _enumEndpointFilter = {
        Auto: 0,
        Extension: 1,
        Externalnumber: 2,
        Subscriber: 3,
        Group: 4,
        Trunkorgateway: 5,
        List: 6,
    }

    $(".call-attributes").select2({
        placeholder: '',
        allowClear: true,
        tags: true,
        multiple: true
    });

    $.ajax({
        type: 'GET',
        url: '/api/dataviews/descriptions/' + _getViewId(),
        contentType: 'application/json',
        async: false,
        success: function (description) {
            var viewTitle = $("#view-title");
            if (description.Name != null) {
                viewTitle.val(description.Name);
            }
            else {
                $.ajax({
                    type: 'GET',
                    async: false,
                    url: '/api/dataviews/viewfilters/viewname',
                    contentType: 'application/json',
                    success: function (newName) {
                        viewTitle.val(newName);
                    }
                });
            }
        },
        dataType: 'json'
    });


    $("#date-from").datepicker({ changeMonth: !0, changeYear: !0, showButtonPanel: !0, dateFormat: "yy-mm-dd" })
    $("#date-to").datepicker({ changeMonth: !0, changeYear: !0, showButtonPanel: !0, dateFormat: "yy-mm-dd" })

    //var $eventSelect = $("#test");
    //$eventSelect.on("select2:select", function (e) {
    //    console.log($('#test').select2('data')); console.log("select2:select", e);
    //});
    //$eventSelect.on("select2:unselect", function (e) { console.log("select2:unselect", e); });

    //$.ajax({
    //    type: "GET",
    //    url: "/api/categories",
    //    contentType: "application/json",
    //    success: function (model) {
    //        var options = '';
    //        $.each(model, function (index, category) {
    //            options += '<option value="' + category.ID + '">' + category.Name + '</option>';
    //        });
    //        $('#category').html(options);
    //    },
    //    dataType: "json"
    //});

    $.mask.definitions['H'] = "[0-2]";
    $.mask.definitions['h'] = "[0-9]";
    $.mask.definitions['M'] = "[0-5]";
    $.mask.definitions['m'] = "[0-9]";
    $.mask.definitions['S'] = "[0-9]";
    $.mask.definitions['s'] = "[0-9]";

    $(".time-span").mask("Hh:Mm:Ss");

    $('#source-input').typeahead({
        onSelect: function (data) {
            _selectedSource = data.value;
        },
        ajax: {
            method: "POST",
            contentType: "application/json",
            url: '/api/abonents/dataview/suggestitems',
            triggerLength: 1,
            displayField: 'Name',
            valueField: 'ID',
            preDispatch: function (text) {
                var requestType = $('#source-endpoint-filter').val();
                var model = {
                    text: text,
                    requestType: requestType,
                    nodes: _selectedNodes,
                    pbxs: _selectedPbxs
                }

                return model;
            }
        }
    });

    $('#destination-input').typeahead({
        onSelect: function (data) {
            _selectedDestination = data.value;
        },
        ajax: {
            method: "POST",
            contentType: "application/json",
            url: '/api/abonents/dataview/suggestitems',
            triggerLength: 1,
            displayField: 'Name',
            valueField: 'ID',
            preDispatch: function (text) {
                var requestType = $('#destination-endpoint-filter').val();
                var model = {
                    text: text,
                    requestType: requestType,
                    nodes: _selectedNodes,
                    pbxs: _selectedPbxs
                }

                return model;
            },
        }
    });

    _displaySqlFilter();

    function _getValidValue(filterName) {
        var selector = 'input[data-filter-name=' + filterName + ']';
        var val = null;

        if ($(selector).attr('disabled') == undefined) {
            val = $(selector).val();
        }

        return val;
    }

    function _setValidTime(filterName, value) {
        var selector = 'input[data-filter-name=' + filterName + ']';

        if (value != null) {
            
           
            $('input[type=checkbox]').prop('checked', true);
            $(selector).prop('disabled', false);
            $(selector).val(value);
        }
    }

    function _changeSourceDestinationLink(endpointFilterNumber, linkId) {
        switch (parseInt(endpointFilterNumber)) {
            //case _enumEndpointFilter.Auto:
            //    break;
            //case _enumEndpointFilter.Extension:
            //    break;
            //case _enumEndpointFilter.Externalnumber:
            //    break;
            //case _enumEndpointFilter.Subscriber:
            //    break;
            case _enumEndpointFilter.Group:
                $('#' + linkId).removeClass('dialogTrunksTree').addClass('dialogDepartments').attr('href', '/Groups/TreeDialog');
                break;
            case _enumEndpointFilter.Trunkorgateway:
                $('#' + linkId).removeClass('dialogDepartments').addClass('dialogTrunksTree').attr('href', '/Trunks/TrunksDialog');
                break;
                //case enumEndpointFilter.List:
                //    break;
            default:
                $('#' + linkId).removeClass('dialogTrunksTree').removeClass('dialogDepartments').attr('href', '#');
                break;
        }
    };

    function _getIdsFromSelect2ArrObjects(data) {
        var ids = [];
        $.each(data, function (index, val) {
            ids.push(val.id);
        });
        return ids;
    }

    function _enableDestinationCondition(enable) {
        $('#destination-condition').attr('disabled', !enable);
    }

    function _setSourceDestinationValue(selectedValue, inputValue) {
        if (_openDialogLinkId == 'source-link') {
            _selectedSource = selectedValue
            $('#source-input').val(inputValue);
        } else if (_openDialogLinkId == 'destination-link') {
            _selectedDestination = selectedValue
            $('#destination-input').val(inputValue);
        }
    }

    function _fillNodeEquipmentInput(equipment) {
        var nodes = [];
        var pbxs = [];

        $.each(equipment, function (index, eqm) {
            if (eqm.id.charAt(0) == 'n') {
                nodes.push(eqm);
            } else {
                pbxs.push(eqm);
            }
        });

        $.each(pbxs, function (pbxIndex) {
            $.each(nodes, function (nodeIndex, node) {
                if (this.parentId == node.id) {
                    pbxs.splice(nodeIndex, 1);
                }
            });
        });

        _selectedNodes = [];
        _selectedPbxs = [];
        var inputText = '';

        $.each(pbxs, function (pbxIndex, pbx) {
            inputText += pbx.name + ', ';
            _selectedPbxs.push(pbx.displayId);
        });

        $.each(nodes, function (nodeIndex, node) {
            inputText += node.name + ', ';
            _selectedNodes.push(node.displayId);
        });

        $('#node-equipment').val(inputText.substring(0, inputText.length - 2));
    };

    function _displaySqlFilter() {
        var viewId = _getViewId();
        
        if (viewId == '') {
            return false
        }        
        
        $.ajax({
            type: 'GET',
            url: '/api/dataviews/viewfilters/' + viewId,
            contentType: 'application/json',
            success: function (sqlFilter) {
                var infoBox = $('section.content div.info-box');
                $(infoBox).removeClass('hidden');
                $(infoBox).find('div.info-box-content span:last').text(sqlFilter);
            },
            dataType: 'html'
        });
    };

    function _getViewId() {
        return $(location).attr('search').replace('?id=', '');
    }

    $('.input-group').on('change', 'input[type=checkbox]', function () {
        if (this.checked) {
            $(this).closest('div').find('input[type=text]').attr('disabled', false);
        } else {
            $(this).closest('div').find('input[type=text]').attr('disabled', true);
        }
    });

    $('.form-group').on('change', '#date-time-period', function () {
        drawDateTimeForPeriodIfNecessary.call(this);
    });
    

    function drawDateTimeForPeriodIfNecessary() {
        if ($(this).val() == 9) {//CustomMonth
            $('#year').closest('.custom-date-period').attr('hidden', false);
            $('#month').closest('.custom-date-period').attr('hidden', false);
            $('#date-from').closest('.custom-date-period').attr('hidden', true);
            $('#date-to').closest('.custom-date-period').attr('hidden', true);
        } else if ($(this).val() == 10) {//CustomYear
            $('#year').closest('.custom-date-period').attr('hidden', false);
            $('#month').closest('.custom-date-period').attr('hidden', true);
            $('#date-from').closest('.custom-date-period').attr('hidden', true);
            $('#date-to').closest('.custom-date-period').attr('hidden', true);
        } else if ($(this).val() == 11) {//CustomPeriod
            $('#year').closest('.custom-date-period').attr('hidden', true);
            $('#month').closest('.custom-date-period').attr('hidden', true);
            $('#date-from').closest('.custom-date-period').attr('hidden', false);
            $('#date-to').closest('.custom-date-period').attr('hidden', false);
        } else {
            $('#year').closest('.custom-date-period').attr('hidden', true);
            $('#month').closest('.custom-date-period').attr('hidden', true);
            $('#date-from').closest('.custom-date-period').attr('hidden', true);
            $('#date-to').closest('.custom-date-period').attr('hidden', true);
        }
    }

    $('#source-endpoint-filter').on('change', function () {
        _changeSourceDestinationLink($(this).val(), 'source-link');
    });

    $('#destination-endpoint-filter').on('change', function () {
        _changeSourceDestinationLink($(this).val(), 'destination-link');
    });

    $('#source-input').on('change', function () {
        _enableDestinationCondition($(this).val().length > 0);
        //_selectedSource = $(this).val();
        //_selectedSource = null;
    });

    $('#destination-input').on('change', function () {
        //_selectedDestination = $(this).val();
        //_selectedDestination = null;
    });
    
    function fillFilter() {
        //Equipment
        _fillNodeEquipmentInput(SelectedNodesAndPBXs);
        
        $('#date-time-period').val(CurrentFilter.Period.PeriodType);
        drawDateTimeForPeriodIfNecessary.call($('#date-time-period'));
        _setDateTimeForPeriod.call($('#date-time-period'));
        // General section
        $('#source-endpoint-filter').val(CurrentFilter.Source.Type);
        $('#source-input').val(CurrentFilter.Source.Text);
        $('#destination-endpoint-filter').val(CurrentFilter.Destination.Type);
        $('#destination-input').val(CurrentFilter.Destination.Text);
        $('input[data-filter-name=FromPlace]').val(CurrentFilter.FromPlace);
        $('input[data-filter-name=ToPlace]').val(CurrentFilter.ToPlace);
        //Call attributes
        $('#call-direction').val(CurrentFilter.CallDirection);
        $('#call-type').val(CurrentFilter.CallType);
        $('#record-type').val(CurrentFilter.RecordType);
        $('#terminate-reason').val(CurrentFilter.TerminateReason);
        //Advanced
        $('input[data-filter-name=AuthCode]').val(CurrentFilter.AuthCode);
        $('input[data-filter-name=ProjectCode]').val(CurrentFilter.ProjectCode);
        $('#category').val(CurrentFilter.Category);
        $('input[data-filter-name=CostFrom]').val(CurrentFilter.CostFrom);
        $('input[data-filter-name=CostTo]').val(CurrentFilter.CostTo);
        //Date/time attributes
        $('#date-type').val(CurrentFilter.DayType)
        
        _setValidTime('TimeDayFrom',CurrentFilter.TimeDayFrom);
        _setValidTime('TimeDayTo',CurrentFilter.TimeDayTo);
        _setValidTime('DurationFrom',CurrentFilter.DurationFrom);
        _setValidTime('DurationTo',CurrentFilter.DurationTo);
        _setValidTime('TtaFrom',CurrentFilter.TtaFrom);
        _setValidTime('TtaTo',CurrentFilter.TtaTo);
    }
    
    function _setDateTimeForPeriod(){
        if ($(this).val() == 9) {//CustomMonth
            let d = new Date(CurrentFilter.Period.PeriodFrom);
            $('#year').val(d.getFullYear());
            $('#month').val(_monthToString(d.getMonth()));
        } else if ($(this).val() == 10) {//CustomYear
            let d = new Date(CurrentFilter.Period.PeriodFrom);
            $('#year').val(d.getFullYear());
        } else if ($(this).val() == 11) {//CustomPeriod
            var dateFrom = new Date(CurrentFilter.Period.PeriodFrom);
            var dateTo = new Date(CurrentFilter.Period.PeriodTo)
            $('#date-from').val(dateFrom.getFullYear() + '-' + _monthToString(dateFrom.getMonth()) + '-' + _dayToString(dateFrom.getDate()));
            $('#date-to').val(dateTo.getFullYear() + '-' + _monthToString(dateTo.getMonth()) + '-' + _dayToString(dateTo.getDate()));
        }
    }
    
    function _monthToString(month) {
        return (month < 10) ? '0' + (month + 1) : (month + 1).toString();
    }
    
    function _dayToString(day) {
        return (day < 10) ? '0' + day : day.toString();
    }

    
    
    $('.box-header').on('click', '#save-new-data-view', function () {
        var model = {};

        model.Source = {
            Type: $('#source-endpoint-filter').val(),
            Id: _selectedSource,
            Text: $('#source-input').val()
        };

        model.Destination = {
            Type: $('#destination-endpoint-filter').val(),
            Id: _selectedDestination,
            Text: $('#destination-input').val()
        };

        model.DestinationCondition = $('#destination-condition').val();
        model.FromPlace = $('input[data-filter-name=FromPlace]').val();
        model.ToPlace = $('input[data-filter-name=ToPlace]').val();
        model.CallDirection = _getIdsFromSelect2ArrObjects($('#call-direction').select2('data'));
        model.CallType = _getIdsFromSelect2ArrObjects($('#call-type').select2('data'));
        model.RecordType = _getIdsFromSelect2ArrObjects($('#record-type').select2('data'));
        model.TerminateReason = _getIdsFromSelect2ArrObjects($('#terminate-reason').select2('data'));
        model.AuthCode = $('input[data-filter-name=AuthCode]').val();
        model.ProjectCode = $('input[data-filter-name=ProjectCode]').val();
        model.Category = _getIdsFromSelect2ArrObjects($('#category').select2('data'));
        model.CostFrom = $('input[data-filter-name=CostFrom]').val();
        model.CostTo = $('input[data-filter-name=CostTo]').val();
        model.DayType = _getIdsFromSelect2ArrObjects($('#date-type').select2('data'));
        model.TimeDayFrom = _getValidValue('TimeDayFrom');
        model.TimeDayTo = _getValidValue('TimeDayTo');
        model.DurationFrom = _getValidValue('DurationFrom');
        model.DurationTo = _getValidValue('DurationTo');
        model.TtaFrom = _getValidValue('TtaFrom');
        model.TtaTo = _getValidValue('TtaTo');
        model.Nodes = _selectedNodes;
        model.Pbxs = _selectedPbxs;

        var period = {
            PeriodType: $('#date-time-period').val(),
            PeriodFrom: null,
            PeriodTo: null
        };

        if (period.PeriodType == 9) {//CustomMonth
            var d = new Date($('#year').val(), $('#month').val(), 0);
            period.PeriodFrom = $('#year').val() + "-" + $('#month').val() + "-01";
            period.PeriodTo = $('#year').val() + "-" + $('#month').val() + "-" + d.getDate();
        }
        else if (period.PeriodType == 10) {//CustomYear
            period.PeriodFrom = $('#year').val() + "-01-01";
            period.PeriodTo = $('#year').val() + "-12-31";
        }
        else if (period.PeriodType == 11) {//CustomPeriod
            period.PeriodFrom = $('#date-from').val();
            period.PeriodTo = $('#date-to').val();
        }

        model.Period = period;
        var url = '/api/dataviews/viewfilters';
        var ajaxType = 'POST';
        var currentViewId = _getViewId();

        if (currentViewId != '') {
            ajaxType = 'PUT';
            url = '/api/dataviews/viewfilters/' + currentViewId;
        }

        $.ajax({
            type: ajaxType,
            url: url,
            async: false,
            contentType: 'application/json',
            data: JSON.stringify(model),
            success: function (viewId) {
                // Change ViewName
                var viewName = $("#view-title").val();

                $.ajax({
                    type: "PUT",
                    async: false,
                    url: '/api/dataviews/viewfilters/' + viewId + '/' + viewName,
                    contentType: 'application/json',
                    data: JSON.stringify(model),
                    dataType: 'json',
                    success: function () {
                    }
                });

                url = '/DataViews/Detail?id=' + viewId;
                $(location).attr("href", url);
            },
            dataType: 'json'
        });
    });

    $(document).on('click', '.dialogDepartments', function (e) {
        e.preventDefault();
        _openDialogLinkId = $(this).attr('id');
        $.get(this.href, function (data) {
            $('#dialogDepartments').html(data);
            $('#modDepartments').modal('show');
        });
    });

    $(document).on('click', '.dialogTrunksTree', function (e) {
        e.preventDefault();
        _openDialogLinkId = $(this).attr('id');
        $.get(this.href, function (data) {
            $('#dialogTrunksTree').html(data);
            $('#modTrunksTree').modal('show');
        });
    });

    $(document).on('click', '.dialogEquipmentTree', function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogEquipmentTree').html(data);
            $('#modEquipmentTree').modal('show');
        });
    });

    $(document).on('click', '#ok-modal-equipment-tree', function () {
        var equipment = $.BlackGrid.GetCheckedObjects('tbl-equipment-tree');
        $('#modEquipmentTree').modal('hide');
        _fillNodeEquipmentInput(equipment);
    });

    $(document).on('click', '#ok-modal-routes-tree', function () {
        var route = $.BlackGrid.GetSelectedObject('tbl-routes-tree');

        if (route.Id.substring(0, 1) == 'p') {
            return false;
        }

        $('#modTrunksTree').modal('hide');
        _setSourceDestinationValue(route.id, route.template)
    });

    $(document).on('click', '#ok-modal-departments-tree', function () {
        var department = $.BlackGrid.GetSelectedObject('tbl-departments-tree');
        $('#modDepartments').modal('hide');
        _setSourceDestinationValue(department.id, department.name);
    });
});