﻿$(document).ready(() => {
    let doc = null;

    function UpdateMainButtonsUI() {
        $("#btnDownload").attr("disabled", doc == null);
    }

    function AttachEventsMainTable() {
        var header = document.getElementById("servicesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*table events*/
        $('#tariscope-abonent-docs tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                doc = null;
            }
            else {
                doc = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-abonent-docs tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateMainButtonsUI();
        });

        UpdateMainButtonsUI();
    }

    function LoadTable() {
        doc = null;
        $('#documentsTable').load('/PersonalArea/PersonalData/Documents/Load/?s=' + $('#tbSearch').val(), AttachEventsMainTable);
    }

    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadTable();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //download file
    $('#btnDownload').on('click', () => {
        window.open('/PersonalArea/PersonalData/Documents/Download/' + doc, '_blank');
    });

    LoadTable();
});