﻿var selectedIssue = null;

$(document).ready(() => {

    function Export(t) {
        ShowSpinner(true);

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Issue/ExportAll/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Issue/DownloadExportAll/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtons() {
        if (selectedIssue === null) {
            $("#btnChat").attr("disabled", true);
            $("#btnClose").attr("disabled", true);
        }
        else {
            $("#btnClose").attr("disabled", false);
            $("#btnChat").attr("disabled", false);
        }
    }

    function AttachEventToTable() {
        selectedIssue = null;

        $('#tariscope-issues tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedIssue = null;
            }
            else {
                selectedIssue = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-issues tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Issue/All/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadIssues();
                    }
                }
            });
        });
    }

    function LoadIssues() {
        $('#issuesTable').load('/Issue/GetAllIssues/?Search=' + encodeURIComponent($('#tbSearch').val()), AttachEventToTable);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadIssues();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //chnage active state
    $('#ActiveOnly').change(function () {
        $.ajax({
            type: "POST",
            url: '/Issue/All/SetActive/?check=' + $(this).prop('checked'),
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadIssues();
                }
            }
        });
    });

    //open chat
    $('#btnChat').on('click', () => { window.location = '/Issue/Chat/' + selectedIssue + '/?BackUrl=/Issue/All'; });

    /*attach events for select column*/
    $('#MenuSelectColumn input').on('click', function (event) {
        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        $.ajax({
            type: "POST",
            url: '/Issue/SetTableColumnVisability/?colName=' + colName + "&visible=" + visible,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadIssues();
                }
            }
        });
    });

    //confirm close issue
    $('#ConfirmCloseIssue').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Issue/Close/' + selectedIssue + '/?Reason=' + encodeURIComponent($('#closeReason').val()),
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadIssues();
                    $('#modalCloseIssue').modal('hide');
                }
            }
        });
    });

    LoadIssues();
});