﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using System.Net;
using System.Net.Http;
using System.Text.Json;
using System.IO;
using System.Threading.Tasks;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPi.Tariscope.DAL;
using SoftPi.Tariscope;
using Microsoft.Data.SqlClient;

public class SetCos3cxV18Script : IScript
{
    private IScriptHost _host;

    // Change this constants to set your specific parameters
    const string PBX_USERNAME = "username";
    const string PBX_PASSWORD = "admin_password";
    const string PBX_HOST = "http://your_pbx_address:5000"; // http://10.10.0.5:5000

    const string LOGIN_BODY = "{{ \"username\": \"{0}\", \"password\": \"{1}\"}}";
    const string EXT_SET_BODY = "{{ \"Id\": \"{0}\"}}";
    const string EXT_UPDATE_BODY = "{{\"Path\": {{\"ObjectId\": \"{0}\", \"PropertyPath\": [{{\"Name\": \"InternalCallsOnly\"}}]}}, \"PropertyValue\": {1}}}";

    private static HttpClient client;
    private static HttpClientHandler handler;
    private static CookieContainer cookies;

    public void Init(IScriptHost host)
    {
        this._host = host;
        _host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            cookies = new();
            handler = new();
            handler.CookieContainer = cookies;
            client = new HttpClient(handler);

            DepartmentLimitingActionParameters ActionParameters = (DepartmentLimitingActionParameters)Parameters;

            _host.AddEvent(string.Format("Restrict department:{0} Cos:{1}, Category: {2}", ActionParameters.Group.Name, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
            _host.AddEvent(ActionParameters.ActionType.ToString());

            string CategoryName;
            List<DN> Dns = new List<DN>();
            List<int> AbonentIds = new List<int>();
            using (SqlConnection cn = new SqlConnection(_host.DatabaseConnectionString))
            {
                cn.Open();

                var query = MSSQL.NewQuery(cn, "Select ID from Abonents where DepartmentID=" + ActionParameters.Group.ID);
                var reader = query.ExecuteReader();

                while (reader.Read())
                    AbonentIds.Add(reader.GetInt32(0));

                foreach(var id in AbonentIds)
                    Dns.AddRange(DNs.Instance(cn).Load(id).Where(x => DateTime.Now > x.FromDateValue && DateTime.Now < x.ToDateValue));
                
                if (ActionParameters.Credit.CategoryID.HasValue)
                    CategoryName = new Categories(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
                else
                    CategoryName = "All categories";
            }
            bool extensionState = true;
            if (ActionParameters.ActionType == RestrictStatus.QueueUnrestrict)
                extensionState = false;

            var loginResponse = SendRequest(PBX_HOST + "/api/login", HttpMethod.Post, string.Format(LOGIN_BODY, PBX_USERNAME, PBX_PASSWORD));

            if (!loginResponse.IsSuccessStatusCode)
                throw new Exception("3CX API login failed");
            
            var extensionsResponse = SendRequest(PBX_HOST + "/api/ExtensionList", HttpMethod.Get);
            var extensions = DeserializeResponse<ExtensionList>(extensionsResponse.Content.ReadAsStringAsync().Result);

            foreach (DN CurrentDN in Dns)
            {
                _host.AddEvent("DN" + CurrentDN.DN);

                var extensionToChangeStatus = extensions.list.FirstOrDefault(x => x.Number == CurrentDN.DN);

                if (extensionToChangeStatus == null)
                    continue;

                var extensionSetResponse = SendRequest(PBX_HOST + "/api/ExtensionList/set", HttpMethod.Post, string.Format(EXT_SET_BODY, extensionToChangeStatus.Id));

                if (!extensionSetResponse.IsSuccessStatusCode)
                {
                    _host.AddEvent("Change extension settings attempt failed for extension: " + CurrentDN.DN);
                    continue;
                }

                var extensionEditSession = DeserializeResponse<ExtensionEditSession>(extensionSetResponse.Content.ReadAsStringAsync().Result);

                var updateResponse = SendRequest(PBX_HOST + "/api/edit/update", HttpMethod.Post, string.Format(EXT_UPDATE_BODY, extensionEditSession.Id, extensionState.ToString().ToLower()));

                if (!updateResponse.IsSuccessStatusCode)
                {
                    _host.AddEvent("Update restriction attempt failed for extension: " + CurrentDN.DN);
                    continue;
                }

                var saveResponse = SendRequest(PBX_HOST + "/api/edit/save", HttpMethod.Post, extensionEditSession.Id.ToString());

                if (!saveResponse.IsSuccessStatusCode)
                {
                    _host.AddEvent("Save restriction changes attempt failed for extension: " + CurrentDN.DN);
                }
            }
            _host.Wait(1000);

            ActionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            _host.AddEvent(ex.ToString());
        }
    }

    static HttpResponseMessage SendRequest(string url, HttpMethod method, string body = null, string contentType = "application/json")
    {
        var request = new HttpRequestMessage();

        Task<HttpResponseMessage> responseTask;

        if (method == HttpMethod.Post)
        {
            var content = new StringContent(body, System.Text.Encoding.UTF8, contentType);
            responseTask = client.PostAsync(url, content);
        }
        else
        {
            request.RequestUri = new Uri(url);
            responseTask = client.SendAsync(request);
        }

        return responseTask.Result;
    }

    static T DeserializeResponse<T>(string responseText) => JsonSerializer.Deserialize<T>(responseText);

    class ExtensionModel
    {
        public int Id { get; set; }
        public string Number { get; set; }
    }

    class ExtensionList
    {
        public List<ExtensionModel> list { get; set; }
    }

    class ExtensionEditSession
    {
        public int Id { get; set; }
    }
}
