﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using Microsoft.Data.SqlClient;
using SoftPi.Tariscope.DAL;

public class AvayaLimitingSsh : IScript
{
    private IScriptHost _host;

    public const string Avaya_HOST = "192.168.8.239";
    public const string Avaya_PORT = "5022";
    public const string Avaya_LOGIN = "tariscope";
    public const string Avaya_PASSWORD = "tariscope";
    public const int AuthMethod = 1;

    public void Init(IScriptHost host)
    {
        _host = host;
        _host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }

    public void Main(object Parameters)
    {
        SubscriberLimitingActionParameters actionParameters = (SubscriberLimitingActionParameters)Parameters;
        string cos = "";
        if (actionParameters.ActionType.ToString() == "QueueRestrict") cos = "1";
        if (actionParameters.ActionType.ToString() == "QueueUnrestrict") cos = "10";
        _host.AddEvent(string.Format("Restricted subscriber:{0}, Cos:{1}, Category: {2}", actionParameters.Abonent.AbonentName, cos, actionParameters.Credit.CategoryID));

        try
        {
            string categoryName;
            List<DN> dns;
            using (SqlConnection cn = new SqlConnection(_host.DatabaseConnectionString))
            {
                cn.Open();
                if (actionParameters.Credit.CategoryID.HasValue)
                    categoryName = new Categories(cn).Details(actionParameters.Credit.CategoryID.Value).Name;
                else
                    categoryName = "All categories";
                dns = DNs.Instance(cn).Load(actionParameters.Abonent.ID).Where(x => DateTime.Now > x.FromDateValue && DateTime.Now < x.ToDateValue).ToList();
            }


            SoftPi.Shared.DataSources.SshClientSource sshConnector = new SoftPi.Shared.DataSources.SshClientSource();
            sshConnector.Configuration = string.Format(sshConf, Avaya_HOST, Avaya_PORT, Avaya_LOGIN, Avaya_PASSWORD,AuthMethod);
            sshConnector.ReceiveData += receiveData;
            sshConnector.Open();

            _host.Wait(3000);
            sshConnector.Send("ossi" + Convert.ToChar(13).ToString());
            WaitFor(Convert.ToChar(13).ToString() + "t" + Convert.ToChar(13).ToString());             // Wait the response from Avaya
            foreach (DN CurrentDN in dns)
            {
                sshConnector.Send("ccha sta " + CurrentDN.DN + Convert.ToChar(13).ToString() + Convert.ToChar(10).ToString() + "f8001ff0" + Convert.ToChar(13).ToString() + Convert.ToChar(10).ToString() + "d" + cos + Convert.ToChar(13).ToString() + Convert.ToChar(10).ToString() + "t" + Convert.ToChar(13).ToString() + Convert.ToChar(10).ToString());
                WaitFor(Convert.ToChar(13).ToString() + "t" + Convert.ToChar(13).ToString());
            }
            _host.Wait(1000);

            sshConnector.Close();
            actionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            actionParameters.Result = MediationActionResult.Fail;
            _host.AddEvent("Failed to perform restriction action on Avaya:" + ex.Message);
        }
    }

    private void receiveData(object sender, SoftPi.Shared.DataSources.DataSourceReceiveEventArgs e)
    {
        if (_waitInputStream)
        {
            lock (_receiveLock)
            {
                if (_receivedData != null)
                    _receivedData.AddRange(e.Data);
            }
        }
    }


    private bool WaitFor(string nail = "", int timeout = -1)
    {
        if (timeout == -1)
            timeout = 30000;

        lock (_receiveLock)
        {
            _waitInputStream = true;
            _receivedData = new List<byte>();
        }

        int Ticks = Environment.TickCount;
        byte[] searchfor = _textEncoding.GetBytes(nail);
        try
        {
            while (true)
            {
                lock (_receiveLock)
                {
                    if ((searchfor.Length > 0 && LocateFirst(_receivedData, searchfor) >= 0) || (searchfor.Length == 0 && _receivedData.Count > 0))
                        break;
                }
                System.Threading.Thread.Sleep(40);
                if (timeout > 0 && Environment.TickCount > Ticks + timeout)
                    return false;
            }
            return true;
        }
        catch
        {
            return false;
        }
        finally
        {
            lock (_receiveLock)
                _waitInputStream = false;
        }
    }
    private int LocateFirst(List<byte> self, byte[] candidate)
    {
        byte[] SelfArray = self.ToArray();
        if (IsEmptyLocate(SelfArray, candidate))
            return -1;
        for (int i = 0; i <= SelfArray.Length - 1; i++)
        {
            if (!IsMatch(SelfArray, i, candidate))
                continue;

            return i;
        }
        return -1;
    }
    private bool IsMatch(byte[] array, int position, byte[] candidate)
    {
        if (candidate.Length > (array.Length - position))
            return false;
        for (int i = 0; i <= candidate.Length - 1; i++)
        {
            if (array[position + i] != candidate[i])
                return false;
        }

        return true;
    }

    private bool IsEmptyLocate(byte[] array, byte[] candidate)
    {
        return array == null || candidate == null || array.Length == 0 || candidate.Length == 0 || candidate.Length > array.Length;
    }

    private System.Text.Encoding _textEncoding = System.Text.Encoding.Default;

    /// <summary>
    ///     ''' Flag if now in waiting state
    ///     ''' </summary>
    ///     ''' <remarks></remarks>
    private bool _waitInputStream = false;

    /// <summary>
    ///     ''' Buffer with received bytes
    ///     ''' </summary>
    ///     ''' <remarks></remarks>
    private List<byte> _receivedData = null;

    /// <summary>
    ///     ''' Thread syncronization object
    ///     ''' </summary>
    ///     ''' <remarks></remarks>
    private readonly object _receiveLock = new object();

    private const string sshConf = "<?xml version=\"1.0\" encoding=\"utf-8\"?><SSHClientSourceSettings xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><Host>{0}</Host><Port>{1}</Port><Login>{2}</Login><Password>{3}</Password><AuthMethod>{4}</AuthMethod></SSHClientSourceSettings>";
}
