﻿$(document).ready(() => {
    let selectedSDHidden = [];
    let selectedCustomService = null;
    let selectedCustomServiceFee = null;

    function initDateTimepicker() {
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: true,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('input[type="hidden"][name="TypeNew"][value="false"]').remove();

        $('#datetimepicker').datetimepicker(daytimeOpitions);
        if ($('#Deadline').val().length == 0) {
            try {
                $('#datetimepicker').data("DateTimePicker").setDate(null);
            } catch (e) { console.log(e); }
        }
    }

    function RemoveFromArray(array, element) {
        //remove element form array
        const index = array.indexOf(element);

        if (index !== -1) {
            array.splice(index, 1);
        }
    }

    function AttachEventsForSDTables() {

        if ($('#AbonentsListAlternative').val()) {
            selectedSDHidden = $('#AbonentsListAlternative').val().split(',');

            for (var i = 0; i < selectedSDHidden.length; i++) {

                var row = $('#tariscope-SDD tbody td[data-name="SDDataHidden"]').filter(function () {
                    return $(this).text() * 1 == selectedSDHidden[i];
                }).closest("tr");

                row.addClass('selected');
            }
        }
        else {
            selectedSDHidden = [];
        }

        //attach events to table with destinationa and source
        $('#tariscope-SDD tbody').on('click', 'tr', function () {
            let hidden = $(this).find('td[data-name="SDDataHidden"]').text();

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');

                RemoveFromArray(selectedSDHidden, hidden);
            }
            else {
                if ($(this).data('name') !== 'SDDataNonSelect') {
                    selectedSDHidden.push(hidden);
                    $(this).addClass('selected');
                }
            }
        });

        let inputs = $('#tariscope-SDD').find('input');

        if (inputs.length) {
            let search = $(inputs[0]);
            search.val('');
            search.unbind();
            search.on('input', () => {
                let str = search.val();

                if (!str || !str.trim()) {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        $(this).show();
                    });
                }
                else {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        if ($(this).find('td[data-name="SDDataDisplay"]').text().toLowerCase().includes(str.toLowerCase())) {
                            $(this).show();
                        }
                        else {
                            $(this).hide();
                        }
                    });
                }
            });
        }
    }

    function LoadAbonents() {
        //load abonents
        $('#AbonentSourceTitle').text($('#txtAbonents').val());

        $('#AbonentSourceBody').load('/TariscopeViews/GetAbonents/?devices=' + encodeURIComponent($('#txtDevices').val()), function () {
            AttachEventsForSDTables();
            ShowSpinner(false);
            $('#AbonentSourceModal').modal('show');
        });
    }

    function LoadDepartments() {
        //load departments
        $('#AbonentSourceTitle').text($('#txtDepartments').val());

        $('#AbonentSourceBody').load('/TariscopeViews/GetDepartments/?devices=' + encodeURIComponent($('#txtDevices').val()), function () {
            AttachEventsForSDTables();
            ShowSpinner(false);
            $('#AbonentSourceModal').modal('show');
        });
    }

    function AttachEventsToCustomServicesTable() {
        $('#tariscope-services tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedCustomService = null;
                selectedCustomServiceFee = null;
            }
            else {
                selectedCustomService = $(this).find('td[data-name="ID"]').text();
                selectedCustomServiceFee = $(this).find('td[data-name="FeeAmount"]').text();
                $('#tariscope-services tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            $('#ChargeCustomConfirm').prop('disabled', selectedCustomService === null);
            $('#customSvcCost').val(selectedCustomServiceFee.replace(',', '.') * 1);
        });

        $('#customSvcCost').val('0');
        $('#customSvcCount').val('1');
        $('#customSvcDescription').val('');
        $('#ChargeCustomConfirm').prop('disabled', true);

        let json = $('#EndActionScenario').val();
        if (json != '' && json != '[]' && json != '{}') {
            try {
                let obj = JSON.parse(json);

                selectedCustomService = obj.ServiceID;
                $('#customSvcCost').val(obj.Cost);
                $('#customSvcCount').val(obj.Amount);
                $('#customSvcDescription').val(obj.Description ?? '');
                $('td[data-name="ID"]').filter(function () { return $(this).text() == selectedCustomService }).parent().addClass('selected');
                $('#ChargeCustomConfirm').prop('disabled', false);

            } catch (e) {
                console.log(e);
            }
        }

        ShowSpinner(false);
        $('#chargeCustomModal').modal('show');
    }

    //clear deadline
    $('#ClearDeadline').on('click', () => {
        try {
            $('#datetimepicker').data("DateTimePicker").setDate(null);
        } catch (e) { console.log(e); }
    });

    //submit button
    $('#WorkOrderForm').submit(function (e) {
        e.preventDefault();

        ShowSpinner(true);
        let elements = $("input[id^=PERF]:checkbox:checked");

        let dt = $('#datetimepicker').data("DateTimePicker").getDate();
        let now = new moment();

        console.log(dt);
        console.log(now);

        if (elements.length == 0) {
            ShowSpinner(false);
            $('#noEmployeeModal').modal('show');
        }
        else if (dt != null && moment(now).isAfter(dt)) {
            ShowSpinner(false);
            $('#wrongDeadlinemodal').modal('show');;
        }
        else {
            setTimeout(() => {

                let SelectedEmployees = [];
                for (var i = 0; i < elements.length; i++) {
                    SelectedEmployees.push($(elements[i]).prop('name').replace('PERF_', ''));
                }
                $('#SelectedEmployees').val(SelectedEmployees.join());
                $('#btnSubmit').parents('form')[0].submit();
            }, 250);
        }

    });

    //show modal to select abonents or groups
    $('#btnEditSource').on('click', () => {
        ShowSpinner(true);

        let val = $('#AbonentListType').val() * 1;

        if (val == 1) {
            LoadAbonents();
        }
        else if (val == 2) {
            LoadDepartments();
        }
    });

    //clear source
    $('#btnClearSource').on('click', () => { $('#AbonentsListAlternative').val(''); });

    //apply selectd groups
    $('#AbonentSourceBtn').on('click', () => { $('#AbonentsListAlternative').val(selectedSDHidden.join()); });

    //fix right-margin issue
    $('#AbonentSourceModal').on('hidden.bs.modal', function () {
        setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
    });

    //update sql list buttons
    $('#AbonentListType').change(() => {
        $('#AbonentsListAlternative').val('');
        selectedSDHidden = [];
    });

    //cancel
    $('#btnCancel').on('click', () => { window.location = '/WorkOrders'; });

    //change action type
    $('#EndActionType').change(() => {
        if ($('#EndActionType').val() * 1 == 0) {
            $('#btnEndActionConfigure').addClass('disDiv');
        }
        else {
            $('#btnEndActionConfigure').removeClass('disDiv');
        }
    });

    //show modal to charge custom service at the end
    $('#btnEndActionConfigure').on('click', () => {
        $('#customServiceConcentrator').load('/AccountSummary/GetCustomServices', AttachEventsToCustomServicesTable);
    });

    //charge cusotm service
    $('#ChargeCustomConfirm').on('click', () => {
        let obj = {
            ServiceID: selectedCustomService,
            Cost: $('#customSvcCost').val().replace(',', '.') * 1,
            Amount: $('#customSvcCount').val().replace(',', '.') * 1,
            Description: $('#customSvcDescription').val()
        };

        $('#EndActionScenario').val(JSON.stringify(obj));
        $('#chargeCustomModal').modal('hide');
    });
    

    initDateTimepicker();
});