﻿$(document).ready(() => {
    function MakeDisable(num) {
        //disable next steps if previous one was proccesed again
        for (var i = num; i < 8; i++) {
            var elem = $('a[aria-controls="step' + (i + 2) + '"]');
            elem.parent().addClass('disabled');
        }
    }

    function nextTab(elem) {
        //go to next wizard page
        $(elem).next().find('a[data-toggle="tab"]').click();
    }

    function prevTab(elem) {
        //go to prev wizard page
        $(elem).prev().find('a[data-toggle="tab"]').click();
    }

    function ClearTableAndSelect() {
        //remove prev added data to table and choices
        $("#tableWithData tr").remove();
        $("#tableWithData tbody").append('<tr></tr>');

        $('#selectCode option').remove();
        $('#selectName option').remove();
        $('#selectRateName option').remove();
        $('#selectRate option').remove();
        $('#selectPlan option').remove();
        $('#selectProvider option').remove();
        $('#selectCallType option').remove();
        $('#selectCategory option').remove();
        $('#selectEnable option').remove();
        $('#selectDisable option').remove();
        $('#selectdirection option').remove();
        $('#selectRateDT option').remove();
    }

    function InitTable(data) {
        //create head row
        var trHead = document.createElement('tr');
        for (var i = 0; i < data[0].length; i++) {
            //create cell
            var th = document.createElement('th');
            th.innerText = data[0][i];
            //add cell to row
            trHead.appendChild(th);
        }
        $('#tableWithData tr:last').after(trHead);

        for (var i = 1; i < data.length; i++) {
            //create row
            var tr = document.createElement('tr');
            for (var j = 0; j < data[i].length; j++) {
                //create cell
                var td = document.createElement('td');
                td.innerText = data[i][j];
                //add cell to row
                tr.appendChild(td);
            }
            //add row to table
            $('#tableWithData tr:last').after(tr);
        }

    }

    function AddFields(data) {
        //add empty field
        $('#selectCode').append('<option value="' + -1 + '"></option>');
        $('#selectName').append('<option value="' + -1 + '"></option>');
        $('#selectRateName').append('<option value="' + -1 + '"></option>');
        $('#selectRate').append('<option value="' + -1 + '"></option>');
        $('#selectPlan').append('<option value="' + -1 + '"></option>');
        $('#selectProvider').append('<option value="' + -1 + '"></option>');
        $('#selectCallType').append('<option value="' + -1 + '"></option>');
        $('#selectCategory').append('<option value="' + -1 + '"></option>');
        $('#selectEnable').append('<option value="' + -1 + '"></option>');
        $('#selectDisable').append('<option value="' + -1 + '"></option>');
        $('#selectdirection').append('<option value="' + -1 + '"></option>');
        $('#selectRateDT').append('<option value="' + -1 + '"></option>');

        //add source fields
        for (var i = 0; i < data.length; i++) {
            $('#selectCode').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectRateName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectRate').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectPlan').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectProvider').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectCallType').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectCategory').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectEnable').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectDisable').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectdirection').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectRateDT').append('<option value="' + i + '">' + data[i] + '</option>');
        }
    }

    function SelectedMatch(data) {
        //select matched fields
        $('#selectCode').val(data[0]);
        $('#selectName').val(data[1]);
        $('#selectRateName').val(data[2]);
        $('#selectRate').val(data[3]);
        $('#selectPlan').val(data[4]);
        $('#selectProvider').val(data[5]);
        $('#selectCallType').val(data[6]);
        $('#selectCategory').val(data[7]);
        $('#selectEnable').val(data[8]);
        $('#selectDisable').val(data[9]);
        $('#selectdirection').val(data[10]);
        $('#selectRateDT').val(data[11]);
    }

    function Start() {
        //start export
        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/Start/',
            traditional: true,
            success: function (response) {
                GetStatus();
            }
        });
    }

    function GetStatus() {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/GetStatus/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    //not yet
                    $('#procc').css('width', response.percent + '%');

                    if (!response.completed) {
                        GetStatus();
                    }
                    //completed
                    else if (response.completedSuccess) {
                        $('#process').attr('hidden', true);
                        $('#compl').attr('hidden', false);

                        $('#procc').css('width', '100%');

                        $('#added').text(response.nCodes);
                        $('#rtadded').text(response.nTarifs);
                        $('#ctadded').text(response.nCategories);

                        $('#proccContainer').slideUp('fast');
                        $('#ImportStatus').slideDown('fast');
                        $('#ButtonsEndCase').slideDown('fast');
                    }
                    else {
                        $('#process').attr('hidden', true);
                        $('#compl').attr('hidden', true);
                        $('#errorl').attr('hidden', false);

                        $('#errorMsg').html(response.message);

                        $('#proccContainer').slideUp('fast');
                        $('#ImportStatusError').slideDown('fast');
                        $('#ButtonsEndCase').slideDown('fast');
                    }
                }
            }
        });
    }

    //Initialize tooltips
    $('.nav-tabs > li a[title]').tooltip();

    //Wizard
    $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

        var $target = $(e.target);

        if ($target.parent().hasClass('disabled')) {
            return false;
        }
    });
    $(".prev-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        prevTab($active);
    });

    //file input
    var inputs = document.querySelectorAll('.file-input');
    for (var i = 0, len = inputs.length; i < len; i++) {
        customInput(inputs[i]);
    }
    function customInput(el) {
        const fileInput = el.querySelector('[type="file"]');
        const label = el.querySelector('[data-js-label]');

        fileInput.onchange = fileInput.onmouseout = function () {
            if (!fileInput.value) return;

            var value = fileInput.value.replace(/^.*[\\\/]/, '');
            el.className += ' -chosen';
            label.innerText = value;
        };
    }

    //welcome
    $('#WelcomeButton').on('click', function () {
        var $active = $('.wizard .nav-tabs li.active');
        $active.next().removeClass('disabled');
        nextTab($active);

        MakeDisable(1);
    });

    //chnage file format
    $('#SelectFileFormat').change(function () {
        $('#FileInput').attr('accept', '.' + $('#SelectFileFormat option:selected').val());
    });

    //get tables names
    $('#FileProcessButton').on('click', function () {
        var data = new FormData();
        var file = $("#FileInput")[0].files[0];

        if (file != null) {
            ShowSpinner(true);
            $('#emptyFile').slideUp('fast');
            data.append($('#SelectFileFormat option:selected').val(), file);

            $.ajax({
                type: "POST",
                async: true,
                url: '/TelephoneCodes/LoadFile/?type=' + $('#SelectFileFormat option:selected').val(),
                data: data,
                datatype: 'json',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        //clear select with tables and load new
                        $('#SelectWitTables').empty();
                        response.tables.forEach(function (e) {
                            $('#SelectWitTables').append('<option value="' + e + '">' + e + '</option>');
                        });

                        var $active = $('.wizard .nav-tabs li.active');
                        $active.next().removeClass('disabled');
                        nextTab($active);

                        MakeDisable(2);
                    }
                    else {
                        $('#FileProcessButton').attr('disabled', true);
                    }
                    ShowSpinner(false);
                }
            });
        }
        else {
            $('#emptyFile').slideDown('fast');
        }
    });

    //get predata and build table
    $('#FilePreloadButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/GetPreData/?table=' + encodeURIComponent($('#SelectWitTables option:selected').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    let tb = JSON.parse(response.tb);

                    //build table with pre data
                    ClearTableAndSelect();
                    InitTable(tb);

                    //add fields to selectes
                    AddFields(tb[0]);

                    //selected matched
                    SelectedMatch(response.sl);

                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(3);
                }
                else {
                    $('#FilePreloadButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //send selected matches
    $('#FileMatchButton').on('click', function () {
        ShowSpinner(true);

        var mathces = $('#selectCode').val() + ',' +
            $('#selectName').val() + ',' +
            $('#selectRateName').val() + ',' +
            $('#selectRate').val() + ',' +
            $('#selectPlan').val() + ',' +
            $('#selectProvider').val() + ',' +
            $('#selectCallType').val() + ',' +
            $('#selectCategory').val() + ',' +
            $('#selectEnable').val() + ',' +
            $('#selectDisable').val() + ',' +
            $('#selectdirection').val() + ',' +
            $('#selectRateDT').val();

        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/SetMatch/?mathces=' + mathces,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(4);
                }
                else {
                    $('#FileMatchButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //change default settings
    $('#OnlyCodes').change(() => {
        if ($('#OnlyCodes').prop('checked')) {
            $('#additionalSettingsSection').addClass('disDiv');
        }
        else {
            $('#additionalSettingsSection').removeClass('disDiv');
        }
    });

    //save primary key
    $('#FileSaveKeyButton').on('click', function () {
        ShowSpinner(true);

        let url = `/TelephoneCodes/SaveSettings/?OnlyCodes=${$('#OnlyCodes').prop('checked')}&DefProvider=${$('#selectDefaultProvider').val()}&DefPlan=${$('#selectDefaultPlane').val()}&Currency=${$('#selectDefaultCurrency').val()}&Description=${$('#Description').val()}&Rounding=${$('#Rounding').prop('checked')}&UpdateCodes=${$('#UpdateCodes').prop('checked')}`;

        $.ajax({
            type: "POST",
            async: true,
            url: url,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(-1);

                    Start();
                }
                else {
                    $('#FileSaveKeyButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //cloase wizard
    $('#CloseWizard, #CancelImport').on('click', function () {
        window.location = '/TelephoneCodes';
    });
});