﻿var selectedRate = [];
var selectedRateForMulti = [];

var rateDates = [];
var currentRateDate = null;

var MainCurrencyID = 1;

var IsLoad = false;
var IsAdd = false;
var IsUpdate = false;

var selectedModifier = null;
var selectedModifierIsCommon = false;

var selectedStage = null;

var openRateNow = false;

function ExpandLeftMenu() {
    try {
        if (providerIsLoaded) {
            ShowProvider($('#CallProviderID').val());
        }
        else {
            setTimeout(ExpandLeftMenu, 200);
        }
    } catch (e) {
        console.log(e);
        setTimeout(ExpandLeftMenu, 200);
    }

}

function generateRandomNumber(min, max) {
    //gate random number in range
    var rand = min - 0.5 + Math.random() * (max - min + 1);
    rand = Math.round(rand);
    return rand - 2000;
}

function initDateTimePicker() {
    //init datetimepicker
    var options = {
        todayHighlight: true,
        autoclose: true,
        daysOfWeekDisabled: "0",
        daysOfWeekHighlighted: "0",
        language: $('#LocaleThread').val(),//navigator.language,
        locale: $('#LocaleThread').val(),//navigator.language,
        useCurrent: false,
        showClear: true,
        showClose: true,
        allowInputToggle: true
    };

    $('#datetimepicker').datetimepicker(options);
}

function GetValueBySelect(name) {
    //return value for some fields with select (UAH/%)
    var select = $('#' + name + 'Select option:selected').val();

    var value = $('#' + name).val() * 1;
    return select === 1 ? value : -value;
}

function IDToString(id) {
    return "'" + id + "'";
}

function GetEmptyRate() {
    //return empty settings for rate
    return {
        ID: 0,
        RecDate: null,
        CurrencyID: MainCurrencyID,
        RoundDurationDown: false,
        RoundTo: 60,
        MininmumDuration: 0,
        RoundCostTo: 2,
        RoundCostDown: false,
        FreeSeconds: 0,
        SubstractSeconds: 0,
        ConnectionCostLessThen: 0,
        ThenConnFee: 0,
        ElseConnFee: 0,
        EnableAccountingMode: true,
        EverySub: false,
        AccountDescription: '',
        SingleCall: false
    };
}

function ApplyRate(rate, applyDate = false) {
    //aply this settings to ui

    if (applyDate) {
        try {

            $('#datetimepicker').data("DateTimePicker").setDate(rate.RecDate);
            $('#datetimepicker').data("DateTimePicker").setDate(new Date(rate.RecDate));
        } catch (e) { console.log(e); }
    }

    $('#editCurrencyID').val(rate.CurrencyID);
    ApplyCurrencyName();

    /*RoundTo*/
    $('#editRoundTo').val(rate.RoundTo);
    switch (rate.RoundTo * 1) {
        case 60:
            $('#RodunToSelect').val(1);
            $('#editRoundTo').attr('readonly', true);
            break;
        case 1:
            $('#RodunToSelect').val(2);
            $('#editRoundTo').attr('readonly', true);
            break;
        default:
            $('#RodunToSelect').val(3);
            $('#editRoundTo').attr('readonly', false);
            break;
    }

    $('#Rounding').prop('checked', rate.RoundDurationDown);
    $('#editMinimumDuration').val(rate.MininmumDuration);
    $('#editRoundCostTo').val(rate.RoundCostTo);
    $('#RoundingDigits').prop('checked', rate.RoundCostDown);
    $('#editFreeSeconds').val(rate.FreeSeconds);
    $('#editSubstractSeconds').val(rate.SubstractSeconds);

    /*ConnectionCostLessThen*/
    var l = rate.ConnectionCostLessThen;
    $('#editLessThen').val(l >= 0 ? l : -l);
    $('#editLessThenSelect').val(l >= 0 ? 1 : 2);

    /*ConnectionCostBefore*/
    var o = rate.ThenConnFee;
    $('#editThenCost').val(o >= 0 ? o : -o);
    $('#editThenCostSelect').val(o >= 0 ? 1 : 2);

    /*ConnectionCostAfter*/
    var r = rate.ElseConnFee;
    $('#editElseCost').val(r >= 0 ? r : -r);
    $('#editElseCostSelect').val(r >= 0 ? 1 : 2);

    $('#SingleCall').prop('checked', rate.SingleCall);
    $('#EnableAccounting').prop('checked', rate.EnableAccountingMode);

    if (rate.EnableAccountingMode)
        $('#AccountingModeSection').removeClass('disDiv');
    else
        $('#AccountingModeSection').addClass('disDiv');

    $('#EverySubNumber').prop('checked', rate.EverySub);
    $('#editAccountDescription').val(rate.AccountDescription);

    LoadModifiers();
    LoadStages();
}

function TakeRate(async = false) {
    //create rate from inputs
    var rate = {
        ID: currentRateDate,
        RecDate: $('#datetimepicker').data('date'),
        CurrencyID: $('#editCurrencyID option:selected').val(),
        RoundDurationDown: $('#Rounding').is(':checked'),
        RoundTo: $('#editRoundTo').val(),
        MininmumDuration: $('#editMinimumDuration').val(),
        RoundCostTo: $('#editRoundCostTo').val(),
        RoundCostDown: $('#RoundingDigits').is(':checked'),
        FreeSeconds: $('#editFreeSeconds').val(),
        SubstractSeconds: $('#editSubstractSeconds').val(),
        ConnectionCostLessThen: GetValueBySelect('editLessThen'),
        ThenConnFee: GetValueBySelect('editThenCost'),
        ElseConnFee: GetValueBySelect('editElseCost'),
        EnableAccountingMode: $('#EnableAccounting').is(':checked'),
        EverySub: $('#EverySubNumber').is(':checked'),
        AccountDescription: $('#editAccountDescription').val(),
        SingleCall: $('#SingleCall').is(':checked')
    };

    SendRate(rate, async);
    return rate;
}

function AddNewSettings() {
    //create new settings
    var id = generateRandomNumber(1, 1000);
    var rate = GetEmptyRate();
    rate.ID = id;
    rate.RecDate = $('#datetimepicker').data('date');

    currentRateDate = IDToString(id);
    rateDates[currentRateDate] = rate;

    SendRate(rate, true);

    ApplyCurrent();

    $('#DatesList').append('<option value="' + id + '">' + $('#datetimepicker').data('date') + '</option>');
    $('#DatesList').val(id);
}

function ApplyCurrent(applyDate) {
    if (currentRateDate === null) {
        ApplyRate(GetEmptyRate());
    }
    else {
        IsUpdate = applyDate;
        ApplyRate(rateDates[currentRateDate], applyDate);
    }
}

function LoadStages() {
    setTimeout(() => {
        $('#stagesTable').load('/ProviderRates/GetTableWithStages/' + currentRateDate.toString().replace("'", '').replace("'", ''), AttachEventsForStages);
    }, 500);
}

function LoadModifiers() {
    try {
        $('#modifiersTable').load('/ProviderRates/GetTableWithModifiers/?id=' + currentRateDate.toString().replace("'", '').replace("'", '') + '&sec=' + $('#editRoundTo').val(), AttachEventsForModifiers);

    } catch (e) { console.log(e); }
}

function UpdateButtonsForModifier() {
    /*update ui for buttons modifiers*/
    if (selectedModifier === null) {
        $("#btnEditModifier").attr("disabled", true);
        $("#btnDeleteModifier").attr("disabled", true);
    }
    else {
        $("#btnEditModifier").attr("disabled", false);
        $("#btnDeleteModifier").attr("disabled", false);
    }
}

function AttachEventsForModifiers() {
    //attacj events for table with modifiers
    $('#modifiersTable tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            selectedModifier = null;
            selectedModifierIsCommon = null;
        }
        else {
            selectedModifier = $(this).find('td[data-name="ID"]').text();
            selectedModifierIsCommon = $(this).find('td[data-name="C"]').text();
            $('#modifiersTable tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }

        UpdateButtonsForModifier();
    });
}

function AttachEventsForStages() {
    //attach events for table with stages
    $('#tableWithStages tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            selectedStage = null;
        }
        else {
            selectedStage = $(this).find('td[data-name="ID"]').text();
            $('#tableWithStages tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }

        UpdateButtonsForStages();
    });
}

function UpdateButtonsForStages() {
    /*update ui for buttons stages*/
    if (selectedStage === null) {
        $("#btnEditStages").attr("disabled", true);
        $("#btnDeleteStages").attr("disabled", true);
    }
    else {
        $("#btnEditStages").attr("disabled", false);
        $("#btnDeleteStages").attr("disabled", false);
    }
}

function GetAny(data) {
    //get eny item from array
    for (var prop in data)
        return prop;
}

function ApplyCurrencyName() {
    //apply currency name to other combobox (conn. fee)
    var curName = $('#editCurrencyID option:selected').html().substr(0, 3);

    $('#editLessThenSelect option[value=1]').html(curName);
    $('#editThenCostSelect option[value=1]').html(curName);
    $('#editElseCostSelect option[value=1]').html(curName);
}

function SendRate(rate, async = false) {
    //send settings to server
    $.ajax({
        type: "POST",
        async: async,
        url: '/ProviderRates/SendRate/',
        datatype: "json",
        data: rate
    });
}

function DeleteRate(id, async = false) {
    //set setting for delete
    $.ajax({
        type: "POST",
        async: async,
        url: '/ProviderRates/DeleteRecRate/' + id.toString().replace("'", '').replace("'", '')
    });
}

function AttachEventsToEditView() {

    //back to providers and rates
    $('#ABackToRate, #cancelEdit').on('click', function () { location.reload(); });

    //enable or disable options for rate date
    $('#datetimepicker').on('dp.change', function () {
        if (IsUpdate) {
            IsUpdate = false;
            return;
        }

        if ($('#datetimepickerValue').val() === '')
            $('#exTab').addClass('disDiv');
        else {
            $('#exTab').removeClass('disDiv');

            if (IsAdd || Object.keys(rateDates).length === 0) {

                if (IsLoad) { return; }

                IsAdd = false;
                AddNewSettings();
            }
            else {
                //else edit current
                rateDates[currentRateDate].RecDate = $('#datetimepicker').data('date');
                $('#DatesList option[value=' + currentRateDate + ']').html($('#datetimepicker').data('date'));
                SendRate(rateDates[currentRateDate], true);
            }
        }
    });

    //clear date and set all fileds to null
    $('#btnClearRecDate').on('click', function () {
        $('option[value=' + currentRateDate + ']').remove();
        DeleteRate(currentRateDate, true);
        delete rateDates[currentRateDate];

        //deleted last element
        if (Object.keys(rateDates).length === 0) {
            try { $('#datetimepicker').data("DateTimePicker").setDate(null); } catch (e) { console.log(e); }
            $('#exTab').addClass('disDiv');
            currentRateDate = null;
        }
        //collection contains any other elements, apply random element from coll
        else {
            var id = GetAny(rateDates);
            $('#DatesList').val(id.toString().replace("'", '').replace("'", ''));
            currentRateDate = id;
            try { $('#datetimepicker').data("DateTimePicker").setDate(new Date(rateDates[id].RecDate)); } catch (e) { console.log(e); }
        }

        ApplyCurrent();
    });

    //evetn when changed currency
    $('#editCurrencyID').on('change', ApplyCurrencyName);

    //event when chaged roundTo
    $('#RodunToSelect').on('change', function () {
        var s = $('#RodunToSelect option:selected').val();

        switch (s) {
            case '1':
                $('#editRoundTo').val(60);
                $('#editRoundTo').attr('readonly', true);
                break;
            case '2':
                $('#editRoundTo').val(1);
                $('#editRoundTo').attr('readonly', true);
                break;
            case '3':
                $('#editRoundTo').attr('readonly', false);
                break;
            default:
                break;
        }

        LoadModifiers();
    });

    //enable or disable div with accounting mode options
    $('#EnableAccounting').on('click', function () {
        if ($('#EnableAccounting').is(':checked'))
            $('#AccountingModeSection').removeClass('disDiv');
        else
            $('#AccountingModeSection').addClass('disDiv');
    });

    $('#btnAddNewDate').on('click', function () {
        IsAdd = true;
        try { $('#datetimepicker').data("DateTimePicker").setDate(new Date()); } catch (e) { console.log(e); }
    });

    //switch between dates
    $('#DatesList').on('change', function (e) {
        var newID = IDToString($('#DatesList option:selected').val());
        rateDates[currentRateDate] = TakeRate(true);
        currentRateDate = newID;

        ApplyCurrent(true);
    });

    //save opened setting before save rate
    $("form").submit(function () {
        if (currentRateDate !== null)
            TakeRate();
        return true;
    });

    //events for Add/Edit modifier
    //rate
    $('#editRateMinute').on('input', function () {
        var inputet = $('#editRateMinute').val() * 1;
        var common = $('#CommonRate').val() * 1;
        var secs = $('#editRoundTo').val() * 1;

        $('#editRateCustom').val(secs / 60 * inputet);
        $('#editRateFactor').val(inputet / common);
    });
    //custom rate
    $('#editRateCustom').on('input', function () {
        var inputet = $('#editRateCustom').val() * 1;
        var common = $('#CommonRate').val() * 1;
        var secs = $('#editRoundTo').val() * 1;

        $('#editRateMinute').val(inputet * 60 / secs);
        $('#editRateFactor').val(inputet * 60 / secs / common);
    });
    //factor
    $('#editRateFactor').on('input', function () {
        var inputet = $('#editRateFactor').val() * 1;
        var common = $('#CommonRate').val() * 1;
        var secs = $('#editRoundTo').val() * 1;

        $('#editRateMinute').val(common * inputet);
        $('#editRateCustom').val(common * inputet * secs / 60);
    });

    //show delete modal for modifier
    $('#btnDeleteModifier').on('click', function () {
        $('#cannotDeleteEdit').attr('hidden', true);
        $('#confirmDeleteEditButton').attr('disabled', false);

        $('#confirmDeleteEdit').modal('show');
    });

    //confdirm delete modifier
    $('#confirmDeleteEditButton').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/DeleteModifier/?modifierID=' + selectedModifier + '&RecDateID=' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadModifiers();
                    selectedModifier = null;
                    UpdateButtonsForModifier();
                    $('#confirmDeleteEdit').modal('hide');
                }
                else {
                    $('#cannotDeleteEdit').attr('hidden', false);
                    $('#confirmDeleteEditButton').attr('disabled', true);
                }
            }
        });
    });

    //event for add new
    $('#btnAddModifier').on('click', function () {
        $('#addModifierTitle').attr('hidden', false);
        $('#editModifierTitle').attr('hidden', true);

        $('#modifierEditId').val('0');

        if ($('#CommonRate').val() === '0')
            $('#editRateFactor').val('');

        $('#secLabel').html($('#editRoundTo').val());
        $('#editRateMinute').val('0');
        $('#editRateCustom').val('0');
        $('#editRateFactor').val('0');
        $('#editMinumumCost').val('0');

        $('#editRateFactor').removeClass('disDiv');
        $('#editFromHour').removeClass('disDiv');
        $('#editToHout').removeClass('disDiv');
        $('#DayType').removeClass('disDiv');

        $('#confirmModifier').modal('show');
    });

    //event for edit selected
    $('#btnEditModifier').on('click', function () {

        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/GetModifier/?modifierID=' + selectedModifier + '&RecDateID=' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#addModifierTitle').attr('hidden', true);
                    $('#editModifierTitle').attr('hidden', false);

                    $('#modifierEditId').val(selectedModifier);

                    $('#editRateMinute').val(response.modifier.Rate);
                    $('#editRateCustom').val(response.modifier.Rate2);
                    $('#editMinumumCost').val(response.modifier.MinimumCost);

                    if (selectedModifierIsCommon === 'True') {
                        $('#editRateFactor').addClass('disDiv');
                        $('#editRateFactor').val('1');

                        $('#editFromHour').addClass('disDiv');
                        $('#editToHout').addClass('disDiv');
                        $('#DayType').addClass('disDiv');
                    }
                    else {
                        $('#editRateFactor').removeClass('disDiv');
                        $('#editRateFactor').val(response.modifier.Factor);

                        $('#editFromHour').removeClass('disDiv');
                        $('#editFromHour').val(response.modifier.FromHour);

                        $('#editToHout').removeClass('disDiv');
                        $('#editToHout').val(response.modifier.ToHour);

                        $('#DayType').removeClass('disDiv');
                        $('#DayType').val(response.modifier.DayType);
                    }
                    $('#confirmModifier').modal('show');
                }
            }
        });
    });

    //submit save modifier
    $('#RateModifierSave').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/EditModifier/?ModifierId=' + $('#modifierEditId').val() +
                '&RecDateId=' + currentRateDate.toString().replace("'", '').replace("'", '') +
                '&RateMinute=' + $('#editRateMinute').val() +
                '&MinCost=' + $('#editMinumumCost').val() +
                '&DayType=' + $('#DayType option:selected').val() +
                '&FromHour=' + $('#editFromHour').val() +
                '&ToHour=' + $('#editToHout').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadModifiers();
                    selectedModifier = null;
                    UpdateButtonsForModifier();
                    $('#confirmModifier').modal('hide');
                }
            }
        });
    });

    //timer for input round to
    var typingTimer;                //timer identifier
    var doneTypingInterval = 500;  //time in ms, 0.5 second for example
    var $input = $('#editRoundTo');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadModifiers();
        }, doneTypingInterval);
    });

    //show window for add stage
    $('#btnAddStages').on('click', function () {
        $('#addStageTitle').attr('hidden', false);
        $('#editStageTitle').attr('hidden', true);

        $('#stageEditId').val('0');
        $('#editQuantity').val('0');
        $('#editStageFactor').val('1');

        $('#confirmStage').modal('show');
    });

    //show delete modal fro stage
    $('#btnDeleteStages').on('click', function () {
        $('#cannotDeleteEdit').attr('hidden', true);
        $('#confirmDeleteEditButton').attr('disabled', false);

        $('#confirmDeleteStage').modal('show');
    });

    //event for edit selected
    $('#btnEditStages').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/GetStage/?stageID=' + selectedStage + '&RecDateID=' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#addStageTitle').attr('hidden', true);
                    $('#editStageTitle').attr('hidden', false);

                    $('#stageEditId').val(response.stage.ID);
                    $('#editQuantity').val(response.stage.Quantity);
                    $('#editStageFactor').val(response.stage.Factor);

                    $('#confirmStage').modal('show');
                }
            }
        });
    });

    //confirm deleting stage
    $('#confirmDeleteStageButton').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/DeleteStage/?stageID=' + selectedStage + '&RecDateID=' + currentRateDate.toString().replace("'", '').replace("'", ''),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadStages();
                    selectedStage = null;
                    UpdateButtonsForStages();
                    $('#confirmDeleteStage').modal('hide');
                }
            }
        });
    });

    //confirm save stage
    $('#StageSave').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/EditStage/?stageID=' + $('#stageEditId').val() +
                '&RecDateID=' + currentRateDate.toString().replace("'", '').replace("'", '') +
                '&Quantity=' + $('#editQuantity').val() +
                '&Factor=' + $('#editStageFactor').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadStages();
                    selectedStage = null;
                    UpdateButtonsForStages();
                    $('#confirmStage').modal('hide');
                }
            }
        });
    });

    //show info about new auto service
    $('#editAccountDescription').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#newServiceInfo').slideUp('fast');
        }
        else {
            $('#newServiceInfo').slideDown('fast');
        }
    });

    //change rate plan
    $('#listRates').change(function () {
        $('#divForm').addClass('disDiv');
        $('#planSelectionSection').addClass('disDiv');
        openRateNow = true;
        $('#submitButton').click();
    });

    //submit form
    $('#editRateForm').on("submit", function (e) {
        if (openRateNow) {
            e.preventDefault();

            $.ajax({
                type: $(this).attr('method'),
                url: $(this).attr('action'),
                data: $(this).serialize(),
                success: () => {
                    openRateNow = false;
                    rateDates = [];
                    currentRateDate = null;

                    $.ajax({
                        type: "POST",
                        async: true,
                        url: '/ProviderRates/GetLastID/',
                        traditional: true,
                        success: function (response) {
                            if (response !== null && response.success === true) {
                                window.LoadRatesEdit(response.id, $('#listRates').val(), AttachEventsToEditView);//go to new rate plane
                            }
                        }
                    });


                }
            });

            return true;
        }
    });

    //disable selected rate when empty rate name
    $('#rateName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#planSelectionSection').addClass('disDiv');
        }
        else {
            $('#planSelectionSection').removeClass('disDiv');
        }
    });

    //get main currency id for create empty settings
    $.ajax({
        type: "POST",
        async: true,
        url: '/ProviderRates/GetMainCurrencyID/',
        traditional: true,
        success: function (response) {
            if (response !== null && response.success === true) {
                MainCurrencyID = response.id;
                $('#urlForm').val(window.location.pathname);
            }
        }
    });

    //setup current plan
    $('#listRates').val($('#rateForEditPlaneID').val());

    if ($('#rateName').val() !== '') {

        //show edit title
        if ($('#divForm > form').attr('action').includes('EditRate')) {
            $('#lblAdd').attr('hidden', true);
            $('#lblEdit').attr('hidden', false);
            $('#lblCopy').attr('hidden', true);

            $('#lblKdb_edit').html($('#rateName').val());
        }
        //show copy title
        else if ($('#divForm > form').attr('action').includes('CopyRate')) {
            $('#lblAdd').attr('hidden', true);
            $('#lblEdit').attr('hidden', true);
            $('#lblCopy').attr('hidden', false);

            $('#lblKdb_copy').html($('#rateName').val());
            $('#rateForEdit').val('0');
        }
        //show add title
        else {
            $('#lblAdd').attr('hidden', false);
            $('#lblEdit').attr('hidden', true);
            $('#lblCopy').attr('hidden', true);
        }

        //load if not empty
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/GetRateSettings/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    IsLoad = true;
                    response.SettingsPool.forEach(function (e) {
                        try { $('#datetimepicker').data("DateTimePicker").setDate(new Date(e.RecDate)); } catch (e) { console.log(e); }
                        $('#DatesList').append('<option value="' + e.ID + '">' + $('#datetimepicker').data('date') + '</option>');
                        rateDates["'" + e.ID + "'"] = e;
                    });

                    var id = GetAny(rateDates);
                    $('#DatesList').val(id.toString().replace("'", '').replace("'", ''));
                    currentRateDate = id;
                    try { $('#datetimepicker').data("DateTimePicker").setDate(new Date(rateDates[id].RecDate)); } catch (e) { console.log(e); }
                    IsLoad = false;

                    ApplyCurrent();
                }
            }
        });
    }
    else {
        $('#planSelectionSection').addClass('disDiv');
    }

    initDateTimePicker();
    ShowSpinner(false);
}

function AttachEventsToMultiEditView() {
    //back to providers and rates
    $('#ABackToRate, #cancelEdit').on('click', function () { location.reload(); });

    //remove unmodified class from clicked checkbox
    $('#switchRounding, #switchRoundingDigits, #switchEnableAccounting, #switchEverySubNumber').on('click', function (e) {
        var base = $(e.target).attr('for');

        $('#' + base).removeClass('Unmodified');
        $('#' + base + '_cb').val(1);
    });

    //enable or disable div with accounting mode options
    $('#EnableAccounting').on('click', function () {
        if ($('#EnableAccounting').is(':checked'))
            $('#AccountingModeSection').removeClass('disDiv');
        else
            $('#AccountingModeSection').addClass('disDiv');
    });

    //clear date and set all fileds to null
    $('#btnClearRecDate').on('click', function () {
        try { $('#datetimepicker').data("DateTimePicker").setDate(null); } catch (e) { console.log(e); }
    });

    $('#urlForm').val(window.location.pathname);
    initDateTimePicker();
    ShowSpinner(false);
}

function RemoveFromArray(array, element) {
    //remove element form array
    const index = array.indexOf(element);

    if (index !== -1) {
        array.splice(index, 1);
    }
}

function Export(t) {
    ShowSpinner(true);
    /*function for download file with exported data*/

    console.log("call Export('" + t + "')");

    $.ajax({
        type: "POST",
        async: true,
        cache: false,
        timeout: 600000,
        url: '/ProviderRates/Export/?type=' + t,
        traditional: true,
        success: function (response) {
            if (response !== null && response.success === true) {
                console.log("Export successfully!");
                console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                window.open('/ProviderRates/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                console.log("Download completed!");
            }
            else {
                console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
            }

            ShowSpinner(false);
        },
        error: function (xhr, ajaxOptions, thrownError) {
            alert(xhr.status);
            alert(thrownError);
        }
    });
}

function UpdateRateButtonsUI() {
    if (selectedRate.length === 0) {
        $("#btnEdit").attr("disabled", true);
        $("#btnCopy").attr("disabled", true);
        $("#btnCopyFrom").attr("disabled", true);
        $("#btnDelete").attr("disabled", true);
        $("#btnClean").attr("disabled", true);
        $("#btnMultiply").attr("disabled", true);
        $("#btnSetProvider").attr("disabled", true);


        $("#btnEditMenu").addClass("disDiv");
        $("#btnCopyMenu").addClass("disDiv");
        $("#btnCopyFromMenu").addClass("disDiv");
        $("#btnDeleteMenu").addClass("disDiv");
        $("#btnCleanMenu").addClass("disDiv");
        $("#btnMultiplyMenu").addClass("disDiv");
        $("#btnSetProviderMenu").addClass("disDiv");

    }
    else if (selectedRate.length === 1) {
        if ($('#RatePlane option:selected').val() === 0) {
            $("#btnEdit").attr("disabled", true);
            $("#btnCopy").attr("disabled", true);
            $("#btnCopyFrom").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnMultiply").attr("disabled", true);

            $("#btnEditMenu").addClass("disDiv");
            $("#btnCopyMenu").addClass("disDiv");
            $("#btnCopyFromMenu").addClass("disDiv");
            $("#btnDeleteMenu").addClass("disDiv");
            $("#btnMultiplyMenu").addClass("disDiv");
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnCopy").attr("disabled", false);
            $("#btnCopyFrom").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
            $("#btnMultiply").attr("disabled", false);

            $("#btnEditMenu").removeClass("disDiv");
            $("#btnCopyMenu").removeClass("disDiv");
            $("#btnCopyFromMenu").removeClass("disDiv");
            $("#btnDeleteMenu").removeClass("disDiv");
            $("#btnMultiplyMenu").removeClass("disDiv");
        }

        $("#btnSetProvider").attr("disabled", false);
        $("#btnClean").attr("disabled", false);

        $("#btnSetProviderMenu").removeClass("disDiv");
        $("#btnCleanMenu").removeClass("disDiv");
    }
    else {
        if ($('#RatePlane option:selected').val() === 0) {
            $("#btnEdit").attr("disabled", true);
            $("#btnCopyFrom").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnMultiply").attr("disabled", true);

            $("#btnEditMenu").addClass("disDiv");
            $("#btnCopyFromMenu").addClass("disDiv");
            $("#btnDeleteMenu").addClass("disDiv");
            $("#btnMultiplyMenu").addClass("disDiv");
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnCopyFrom").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
            $("#btnMultiply").attr("disabled", false);

            $("#btnEditMenu").removeClass("disDiv");
            $("#btnCopyFromMenu").removeClass("disDiv");
            $("#btnDeleteMenu").removeClass("disDiv");
            $("#btnMultiplyMenu").removeClass("disDiv");
        }

        $("#btnSetProvider").attr("disabled", false);
        $("#btnClean").attr("disabled", false);

        $("#btnCopy").attr("disabled", true);

        $("#btnSetProviderMenu").removeClass("disDiv");
        $("#btnCleanMenu").removeClass("disDiv");

        $("#btnCopyMenu").addClass("disDiv");
    }

    //disable add if concret plane not selected
    if ($('#RatePlane option:selected').val() * 1 === 0) {
        $("#btnAdd").attr("disabled", true);

        $("#btnAddMenu").addClass("disDiv");
    }
    else {
        $("#btnAdd").attr("disabled", false);

        $("#btnAddMenu").removeClass("disDiv");
    }
}

function AttachEventsToTableWithRates() {
    /*table events*/
    $('#tableWithRates tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            if ($('#multiselect').is(':checked')) {
                RemoveFromArray(selectedRate, $(this).find('td[data-name="ID"]').text());
                RemoveFromArray(selectedRateForMulti, $(this).find('td[data-name="SettingsID"]').text());
            }
            else {
                selectedRate = [];
                selectedRateForMulti = [];
            }
        }
        else {
            if (!$('#multiselect').is(':checked')) {
                selectedRate = [];
                selectedRateForMulti = [];
                $('#tableWithRates tr.selected').removeClass('selected');
            }
            selectedRateForMulti.push($(this).find('td[data-name="SettingsID"]').text());
            selectedRate.push($(this).find('td[data-name="ID"]').text());
            $(this).addClass('selected');
        }
        UpdateRateButtonsUI();
    });

    UpdateRateButtonsUI();

    $('th').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/ProviderRates/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                }
            }
        });
    });
}

function UpdateTableWithRates(e) {
    //load table by search string
    $('#rtTable').load('/ProviderRates/SearchRates/?s=' + encodeURIComponent(e) + '&planeId=' + $('#RatePlane option:selected').val(), AttachEventsToTableWithRates);
}

function LoadRatesEdit(id, planeId, callback = null) {
    ShowSpinner(true);
    //load partial for edit selected rate
    $('#ratesContent').load('/ProviderRates/EditRate/?id=' + id + '&planeId=' + planeId, callback);
}

function LoadRatesAdd(id, callback = null) {
    ShowSpinner(true);
    //load partial for add new rate
    $('#ratesContent').load('/ProviderRates/AddRate/' + id, callback);
}

function LoadRatesCopy(id, planeId, callback = null) {
    ShowSpinner(true);
    //load partial for copy selected rate
    $('#ratesContent').load('/ProviderRates/CopyRate/?id=' + id + '&planeId=' + planeId, callback);
}

function LoadRatesMultiEdit(ids, planeId, callback = null) {
    ShowSpinner(true);
    //load partial for edit selected rate
    $('#ratesContent').load('/ProviderRates/MultiEditRate/?ids=' + ids + '&planeId=' + planeId, callback);
}

function AttachEventsForRate() {
    var header = document.getElementById("ratesheader");                 //for sticky header
    var sticky = header.offsetTop;

    //event for show go top button
    $(window).on("scroll", function () {
        //for sticky header
        if (window.pageYOffset > (sticky + 100)) {
            header.classList.add("sticky");
        } else {
            header.classList.remove("sticky");
        }
    });

    /*atach input event to search textbox*/
    $('#tbSearch').on('input', function (e) { UpdateTableWithRates($('#tbSearch').val()); });

    //when select other plane load rates for other
    $('#RatePlane').change(function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/SaveSelectedRate/' + $('#RatePlane option:selected').val(),
            traditional: true
        });
        UpdateTableWithRates($('#tbSearch').val());
        selectedRate = [];
        UpdateRateButtonsUI();
    });

    /*attach events for export*/
    $('#ExportEXCEL, #ExportEXCELMenu').on('click', function () { Export("xlsx"); });
    $('#ExportHTML, #ExportHTMLMenu').on('click', function () { Export("html"); });
    $('#ExportCSV, #ExportCSVMenu').on('click', function () { Export("csv"); });
    $('#ExportPDF, #ExportPDFMenu').on('click', function () { Export("pdf"); });

    //save state of multiselect option to cockie
    $('#switchMultiselect').on('click', function () {

        var state = !$('#multiselect').is(':checked') ? 'checked' : 'e';

        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/SaveMultiselectState/?state=' + state,
            traditional: true
        });
    });

    //save state of show all dates
    $('#switchShowAllDates').on('click', function () {

        var state = !$('#ShowAllDates').is(':checked') ? 'checked' : 'e';

        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/SaveShowAllDates/?state=' + state,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                }
            }
        });
    });

    /*attach events for select column*/
    $('#MenuSelectColumn input').on('click', function (event) {
        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        $.ajax({
            type: "POST",
            url: '/ProviderRates/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    //reload
                    selectedRate = [];
                    UpdateTableWithRates($('#tbSearch').val());
                    UpdateRateButtonsUI();
                }
            }
        });
    });

    //show modal for delete selected rate
    $('#btnDelete, #btnDeleteMenu').on('click', function () {
        $('#confirmDelete').modal('show');
    });

    //confirm remove plane
    $('#PlaneDelete').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/DeletePlane/?ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmDelete').modal('hide');

                    if (response.skipped > 0) {
                        $('#skippedRatesModal').modal('show');
                    }
                }
            }
        });
    });

    //confirm remove rate
    $('#RateDelete').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/DeleteRate/?planeId=' + $('#RatePlane option:selected').val() + '&ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmDelete').modal('hide');

                    if (response.skipped > 0) {
                        $('#skippedRatesModal').modal('show');
                    }
                }
            }
        });
    });

    //show modal for clean selected rate
    $('#btnClean, #btnCleanMenu').on('click', function () {
        $('#confirmClear').modal('show');
    });

    //confirm clear last settings
    $('#RateClear').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/CleanRate/?ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmClear').modal('hide');
                }
            }
        });
    });

    // disable button for multiply when factor empty
    $('#multiFactor').on('input', function (e) {
        $('#RateMulty').attr('disabled', $('#multiFactor').val() === '');
    });

    //show modal for multiply selected rate
    $('#btnMultiply, #btnMultiplyMenu').on('click', function () {
        $('#multiFactor').val('0');
        $('#confirmMultiply').modal('show');
    });

    //confirm multiply rates
    $('#RateMulty').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/MultiplyRate/?factor=' + $('#multiFactor').val() + '&plane=' + $('#RatePlane option:selected').val() + '&ids=' + selectedRate.toString(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmMultiply').modal('hide');
                }
            }
        });
    });

    //show modal for setup provider
    $('#btnSetProvider, #btnSetProviderMenu').on('click', function () {
        $('#avalProviders').val($('#avalProviders option:first').val());
        $('#SetupProviderIncome').attr('checked', false);
        $('#SetupProviderOutgoing').attr('checked', false);
        $('#RateSetProvider').attr('disabled', true);
        $('#confirmSetProvider').modal('show');
    });

    //disable confirm button if dont selected (incoming or outgoing)
    $('#SetupProviderIncome, #SetupProviderOutgoing').on('click', function () {

        var status = $('#SetupProviderIncome').is(':checked') || $('#SetupProviderOutgoing').is(':checked');
        $('#RateSetProvider').attr('disabled', !status);
    });

    $('#RateSetProvider').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/SetupProvider/?ids=' + selectedRate.toString() +
                '&providerid=' + $('#avalProviders option:selected').val() +
                '&incoming=' + $('#SetupProviderIncome').is(':checked') +
                '&outgoing=' + $('#SetupProviderOutgoing').is(':checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmSetProvider').modal('hide');
                }
            }
        });
    });

    //show modal for copy rate from other plane
    $('#btnCopyFrom, #btnCopyFromMenu').on('click', function () {
        $('#RatePlaneCopyFrom').val($('#RatePlaneCopyFrom option:first').val());
        $('#confirmCopyFrom').modal('show');
    });

    //confirm copy to other plane
    $('#RateCopyFrom').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProviderRates/CopyToOtherPlane/?ids=' + selectedRate.toString() +
                '&currentPlane=' + $('#RatePlane option:selected').val() +
                '&newPlane=' + $('#RatePlaneCopyFrom option:selected').val(),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithRates($('#tbSearch').val());
                    selectedRate = [];
                    UpdateRateButtonsUI();
                    $('#confirmCopyFrom').modal('hide');
                }
            }
        });
    });

    //show modal add new rate
    $('#btnAdd, #btnAddMenu').on('click', function () {
        window.LoadRatesAdd($('#RatePlane').val(), AttachEventsToEditView);
    });

    //show modal for edit rate
    $('#btnEdit, #btnEditMenu').on('click', function () {
        if (selectedRate.length > 1) {
            if ($('#ShowAllDates').is(':checked'))//show multi edit preview
                window.LoadRatesMultiEdit(selectedRateForMulti.toString(), $('#RatePlane').val(), AttachEventsToMultiEditView);
            else//show error
                $('#messageModal').modal('show');
        }
        else//show single edit preview
            LoadRatesEdit(selectedRate[0], $('#RatePlane').val(), AttachEventsToEditView);
    });

    //show modal for add new cope of selected
    $('#btnCopy, #btnCopyMenu').on('click', function () {
        window.LoadRatesCopy(selectedRate[0], $('#RatePlane').val(), AttachEventsToEditView);
    });

    //load table and hide spinner
    UpdateTableWithRates($('#tbSearch').val());
    UpdateRateButtonsUI();
}

$(document).ready(function () {
    selectedRate = [];

    AttachEventsForRate();
    ExpandLeftMenu();
});