﻿$(document).ready(function () {
    var selectedIP = null;

    function ExpandLeftMenu() {
        try {
            if (providerIsLoaded) {
                ShowProvider($('#CallProviderID').val());
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/ProvidesAndRates/IPNetworks/Export/' + $('#CallProviderID').val() + '/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/IPNetworks/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateIPsButtonsUI() {
        /*update ui for buttons when not selected any service some buttons disabled*/
        if (selectedIP === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);

            $("#btnEditMenu").addClass("disDiv");
            $("#btnDeleteMenu").addClass("disDiv");
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);

            $("#btnEditMenu").removeClass("disDiv");
            $("#btnDeleteMenu").removeClass("disDiv");
        }
    }

    function AttachEventsToTableWithIPs() {
        $('#tableWithIPs tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedIP = null;
            }
            else {
                selectedIP = $(this).find('td[data-name="ID"]').text();
                $('#tableWithIPs tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateIPsButtonsUI();
        });

        UpdateIPsButtonsUI();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/IPNetworks/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateTableWithIPs($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateTableWithIPs(e) {
        //load table by search string
        $('#ipsTable').load('/ProvidesAndRates/IPNetworks/Search/' + $('#CallProviderID').val() + '/?Search=' + encodeURIComponent(e), AttachEventsToTableWithIPs);
    }

    function ValidateIP() {
        //first need to check descitption
        if ($('#ipDescription').val() === '') {
            $('#descEmpty').slideDown('fast');
            $('#saveIP').attr('disabled', true);
            return;
        }
        else {
            $('#descEmpty').slideUp('fast');
        }

        //then check ip
        var patternt = /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])|(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\/[0-9]|[0-9][0-9]$/;

        if (!patternt.test($('#ipNetwork').val()) || !patternt.test($('#ipMask').val())) {
            $('#ipInputPanel').addClass('alert alert-danger');
            $('#saveIP').attr('disabled', true);
            return;
        }
        else {
            $('#ipInputPanel').removeClass('alert alert-danger');
        }

        //enable button if all validation success
        $('#saveIP').attr('disabled', false);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;   //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            UpdateTableWithIPs($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //for validate ip and mask and description
    $('#ipNetwork').on('input', ValidateIP);
    $('#ipMask').on('input', ValidateIP);
    $('#ipDescription').on('input', ValidateIP);

    //show modal for delete selected ip network
    $('#btnDelete, #btnDeleteMenu').on('click', function () {
        $('#confirmDelete').modal('show');
    });

    //confirm deleting
    $('#DeleteConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProvidesAndRates/IPNetworks/Delete/' + selectedIP,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithIPs($('#tbSearch').val());
                    selectedIP = null;
                    UpdateIPsButtonsUI();
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#DeleteConfirm').attr('disabled', true);
                    $('#DeleteConfirmCancel').attr('disabled', false);
                    $('#cannotDelete').attr('hidden', false);
                }
            }
        });
    });

    //show modal for add network
    $('#btnAdd, #btnAddMenu').on('click', function () {

        $('#titleAdd').attr('hidden', false);
        $('#titleEdit').attr('hidden', true);

        $('#saveIP').attr('disabled', true);

        $('#ipID').val('0');
        $('#ipDescription').val('');
        $('#ipNetwork').val('0.0.0.0');
        $('#ipMask').val('0.0.0.0');
        $('#ipRate').val($("#ipRate option:first").val());
        $('#ipCategory').val($("#ipCategory option:first").val());

        $('#editModal').modal('show');
    });

    //show modal for add network
    $('#btnEdit, #btnEditMenu').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/ProvidesAndRates/IPNetworks/Get/' + selectedIP,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#titleAdd').attr('hidden', true);
                    $('#titleEdit').attr('hidden', false);

                    $('#saveIP').attr('disabled', false);

                    $('#ipID').val(response.Network.ID);

                    $('#ipDescription').val(response.Network.Description);
                    $('#lblEdit').html(response.Network.Description);

                    $('#ipNetwork').val(response.Network.Network);
                    $('#ipMask').val(response.Network.Mask);
                    $('#ipRate').val($("#ipRate option[value=" + response.Network.RateID + "]").val());
                    $('#ipCategory').val($("#ipCategory option[value=" + response.Network.CategoryID + "]").val());

                    $('#editModal').modal('show');
                }
            }
        });
    });

    //save new ip or edited ip
    $('#saveIP').on('click', function () {
        var data = {
            'ProviderID': $('#CallProviderID').val(),
            'ID': $('#ipID').val(),
            'Description': $('#ipDescription').val(),
            'Network': $('#ipNetwork').val(),
            'Mask': $('#ipMask').val(),
            'RateID': $('#ipRate option:selected').val(),
            'CategoryID': $('#ipCategory option:selected').val()
        };

        $.ajax({
            type: "POST",
            async: true,
            data: data,
            datatype: 'json',
            url: '/ProvidesAndRates/IPNetworks/Edit/',
            traditional: true,
            success: function (response) {
                console.log(response);
                if (response !== null && response.success === true) {
                    selectedIP = null;
                    UpdateIPsButtonsUI();
                    UpdateTableWithIPs($('#tbSearch').val());
                    $('#editModal').modal('hide');
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL, #ExportEXCELMenu').on('click', function () { Export("xlsx"); });
    $('#ExportHTML, #ExportHTMLMenu').on('click', function () { Export("html"); });
    $('#ExportCSV, #ExportCSVMenu').on('click', function () { Export("csv"); });
    $('#ExportPDF, #ExportPDFMenu').on('click', function () { Export("pdf"); });


    //load table and hide spinner
    UpdateTableWithIPs($('#tbSearch').val());

    ExpandLeftMenu();
});