﻿$(document).ready(() => {
    let id = null;

    function UpdateMainButtonsUI() {
        if (id == null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsMainTable() {
        var header = document.getElementById("servicesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*table events*/
        $('#tariscope-phones tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                id = null;
            }
            else {
                id = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-phones tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateMainButtonsUI();
        });

        UpdateMainButtonsUI();
    }

    function LoadTable() {
        id = null;
        $('#numbersTable').load('/PersonalArea/Service/PhoneBook/Load/?s=' + $('#tbSearch').val(), AttachEventsMainTable);
    }

    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadTable();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //open modal for delete category
    $('#btnDelete').on('click', () => { $('#confirmDelete').modal('show'); });

    //confirm deleting category
    $('#DeleteConfirm').on('click', () => {

        $('#confirmDelete').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/PersonalArea/Service/PhoneBook/Delete/' + id,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                LoadTable();
            }
        });
    });

    //Open modal for add category
    $('#btnAdd').on('click', () => {
        $('#btnAddNumber').prop('disabled', true);
        $('#emptyName').hide();
        $('#emptyDN').hide();
        $('#NewNumberName').val('');
        $('#NewNumberDN').val('');
        $('#AddNewNumberModal').modal('show');
    });

    //show modal for edit category
    $('#btnEdit').on('click', () => {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/PersonalArea/Service/PhoneBook/Get/' + id,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#emptyEditName').hide();
                    $('#emptyEditDN').hide();

                    $('#EditNumberName').val(response.item.Name);
                    $('#EditNumberDN').val(response.item.Extension);

                    $('#btnEditNumber').prop('disabled', false);

                    ShowSpinner(false);
                    $('#EditNumberModal').modal('show');
                }
            }
        });
    });

    //empty new name 
    $('#NewNumberName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#btnAddNumber').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#btnAddNumber').prop('disabled', false);
        }

        if ((!$('#NewNumberDN').val() || !$('#NewNumberDN').val().trim())) {
            $('#btnAddNumber').prop('disabled', true);
        }
    });

    //empty new number 
    $('#NewNumberDN').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyDN').slideDown('fast');
            $('#btnAddNumber').prop('disabled', true);
        }
        else {
            $('#emptyDN').slideUp('fast');
            $('#btnAddNumber').prop('disabled', false);
        }

        if (!$('#NewNumberName').val() || !$('#NewNumberName').val().trim()) {
            $('#btnAddNumber').prop('disabled', true);
        }
    });

    //empty edit name 
    $('#EditNumberName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyEditName').slideDown('fast');
            $('#btnEditNumber').prop('disabled', true);
        }
        else {
            $('#emptyEditName').slideUp('fast');
            $('#btnEditNumber').prop('disabled', false);
        }

        if (!$('#EditNumberDN').val() || !$('#EditNumberDN').val().trim()) {
            $('#btnEditNumber').prop('disabled', true);
        }
    });

    //empty edit number 
    $('#EditNumberDN').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyEditDN').slideDown('fast');
            $('#btnEditNumber').prop('disabled', true);
        }
        else {
            $('#emptyEditDN').slideUp('fast');
            $('#btnEditNumber').prop('disabled', false);
        }

        if (!$('#EditNumberName').val() || !$('#EditNumberName').val().trim()) {
            $('#btnEditNumber').prop('disabled', true);
        }
    });

    //confirm add a new number
    $('#btnAddNumber').on('click', () => {
        $('#AddNewNumberModal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: `/PersonalArea/Service/PhoneBook/Add/?Extension=${$('#NewNumberDN').val()}&Name=${$('#NewNumberName').val()}`,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                LoadTable();
            }
        });
    });

    //confirm update the number
    $('#btnEditNumber').on('click', () => {
        $('#EditNumberModal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: `/PersonalArea/Service/PhoneBook/Update/${id}/?Extension=${$('#EditNumberDN').val()}&Name=${$('#EditNumberName').val()}`,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                LoadTable();
            }
        });
    });

    LoadTable();
});