﻿$(document).ready(() => {
    function MakeDisable(num) {
        //disable nex steps if prev was proccesed again
        for (var i = num; i < 8; i++) {
            var elem = $('a[aria-controls="step' + (i + 2) + '"]');
            elem.parent().addClass('disabled');
        }
    }

    function nextTab(elem) {
        //go to next wizard page
        $(elem).next().find('a[data-toggle="tab"]').click();
    }

    function prevTab(elem) {
        //go to prev wizard page
        $(elem).prev().find('a[data-toggle="tab"]').click();
    }

    function ClearTableAndSelect() {
        //remove prev added data to table and selectes
        $("#tableWithData tr").remove();
        $("#tableWithData tbody").append('<tr></tr>');

        $('#selectID option').remove();
        $('#selectAccount option').remove();
        $('#selectDN option').remove();
        $('#selectName option').remove();
        $('#selectPDate option').remove();
        $('#selectAmount option').remove();
        $('#selectDescription option').remove();
        $('#selectBank option').remove();
        $('#selectPType option').remove();
    }

    function InitTable(data) {
        //create head row
        var trHead = document.createElement('tr');
        for (var i = 0; i < data[0].length; i++) {
            //create cell
            var th = document.createElement('th');
            th.innerText = data[0][i];
            //add cell to row
            trHead.appendChild(th);
        }
        $('#tableWithData tr:last').after(trHead);

        for (var i = 1; i < data.length; i++) {
            //create row
            var tr = document.createElement('tr');
            for (var j = 0; j < data[i].length; j++) {
                //create cell
                var td = document.createElement('td');
                td.innerText = data[i][j];
                //add cell to row
                tr.appendChild(td);
            }
            //add row to table
            $('#tableWithData tr:last').after(tr);
        }

    }

    function AddFields(data) {
        //add empty field
        $('#selectID').append('<option value="' + -1 + '"></option>');
        $('#selectAccount').append('<option value="' + -1 + '"></option>');
        $('#selectDN').append('<option value="' + -1 + '"></option>');
        $('#selectName').append('<option value="' + -1 + '"></option>');
        $('#selectPDate').append('<option value="' + -1 + '"></option>');
        $('#selectAmount').append('<option value="' + -1 + '"></option>');
        $('#selectDescription').append('<option value="' + -1 + '"></option>');
        $('#selectBank').append('<option value="' + -1 + '"></option>');
        $('#selectPType').append('<option value="' + -1 + '"></option>');

        //add source fields
        for (var i = 0; i < data.length; i++) {
            $('#selectID').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectAccount').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectDN').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectName').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectPDate').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectAmount').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectDescription').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectBank').append('<option value="' + i + '">' + data[i] + '</option>');
            $('#selectPType').append('<option value="' + i + '">' + data[i] + '</option>');
        }
    }

    function SelectedMatch(data) {
        //select matched fields
        $('#selectID').val(data[0]);
        $('#selectAccount').val(data[1]);
        $('#selectDN').val(data[2]);
        $('#selectName').val(data[3]);
        $('#selectPDate').val(data[4]);
        $('#selectAmount').val(data[5]);
        $('#selectDescription').val(data[6]);
        $('#selectBank').val(data[7]);
        $('#selectPType').val(data[8]);

    }

    //Initialize tooltips
    $('.nav-tabs > li a[title]').tooltip();

    //Wizard
    $('a[data-toggle="tab"]').on('show.bs.tab', function (e) {

        var $target = $(e.target);

        if ($target.parent().hasClass('disabled')) {
            return false;
        }
    });
    $(".prev-step").click(function (e) {

        var $active = $('.wizard .nav-tabs li.active');
        prevTab($active);
    });

    //file input
    var inputs = document.querySelectorAll('.file-input');
    for (var i = 0, len = inputs.length; i < len; i++) {
        customInput(inputs[i]);
    }
    function customInput(el) {
        const fileInput = el.querySelector('[type="file"]');
        const label = el.querySelector('[data-js-label]');

        fileInput.onchange = fileInput.onmouseout = function () {
            if (!fileInput.value) return;

            var value = fileInput.value.replace(/^.*[\\\/]/, '');
            el.className += ' -chosen';
            label.innerText = value;
        };
    }

    //welcome
    $('#WelcomeButton').on('click', function () {
        var $active = $('.wizard .nav-tabs li.active');
        $active.next().removeClass('disabled');
        nextTab($active);

        MakeDisable(1);
    });

    //chnage file format
    $('#SelectFileFormat').change(function () {
        $('#FileInput').attr('accept', '.' + $('#SelectFileFormat option:selected').val());
    });

    //get tables names
    $('#FileProcessButton').on('click', function () {
        var data = new FormData();
        var file = $("#FileInput")[0].files[0];

        if (file != null) {
            ShowSpinner(true);
            $('#emptyFile').slideUp('fast');
            data.append($('#SelectFileFormat option:selected').val(), file);

            $.ajax({
                type: "POST",
                async: true,
                url: '/Payments/LoadFile/?type=' + $('#SelectFileFormat option:selected').val(),
                data: data,
                datatype: 'json',
                contentType: false,
                processData: false,
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        //clear select with tables and load new
                        $('#SelectWitTables').empty();
                        response.tables.forEach(function (e) {
                            $('#SelectWitTables').append('<option value="' + e + '">' + e + '</option>');
                        });

                        var $active = $('.wizard .nav-tabs li.active');
                        $active.next().removeClass('disabled');
                        nextTab($active);

                        MakeDisable(2);
                    }
                    else {
                        $('#FileProcessButton').attr('disabled', true);
                    }
                    ShowSpinner(false);
                }
            });
        }
        else {
            $('#emptyFile').slideDown('fast');
        }
    });

    //get predata and build table
    $('#FilePreloadButton').on('click', function () {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/Payments/GetPreData/?table=' + encodeURIComponent($('#SelectWitTables option:selected').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    let tb = JSON.parse(response.tb);

                    //build table with pre data
                    ClearTableAndSelect();
                    InitTable(tb);

                    //add fields to selectes
                    AddFields(tb[0]);

                    //selected matched
                    SelectedMatch(response.sl);

                    var $active = $('.wizard .nav-tabs li.active');
                    $active.next().removeClass('disabled');
                    nextTab($active);

                    MakeDisable(3);
                }
                else {
                    $('#FilePreloadButton').attr('disabled', true);
                }
                ShowSpinner(false);
            }
        });
    });

    //send selected matches
    $('#FileMatchButton').on('click', function () {
        var mathces = $('#selectID').val() + ',' +
            $('#selectAccount').val() + ',' +
            $('#selectDN').val() + ',' +
            $('#selectName').val() + ',' +
            $('#selectPDate').val() + ',' +
            $('#selectAmount').val() + ',' +
            $('#selectDescription').val() + ',' +
            $('#selectBank').val() + ',' +
            $('#selectPType').val();

        if ($('#selectPDate').val() * 1 !== -1) $('#dateSection').show();
        else $('#dateSection').hide();

        $.ajax({
            type: "POST",
            async: true,
            url: '/Payments/SetMatch/?Mathces=' + mathces,
            traditional: true,
            success: function (response) {
                $('#dateForExample').text(response.date);
                var $active = $('.wizard .nav-tabs li.active');
                $active.next().removeClass('disabled');
                nextTab($active);

                MakeDisable(4);
            }
        });
    });

    //go to check the payments
    $('#StartCheck').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Payments/SetDateFormat/?DateFormat=' + encodeURIComponent($('#dateFormat').val()),
            traditional: true,
            success: function (response) {
                window.open('/Payments/Check', '_parent');
            }
        });
        
    });

    //cancel import
    $('#CancelImport').on('click', () => { window.open('/AccountSummary', '_parent'); })
});