﻿$(document).ready(() => {
    let SelectedType = null;

    function Export(t) {
        ShowSpinner(true);

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/IssueType/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/IssueType/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtons() {
        if (SelectedType === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventToTable() {
        SelectedType = null;

        $('#tariscope-istypes tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                SelectedType = null;
            }
            else {
                SelectedType = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-istypes tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/IssueType/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        LoadTypes();
                    }
                }
            });
        });
    }

    function LoadTypes() {
        $('#issuesTypesTable').load('/Issue/IssueType/Search/?s=' + encodeURIComponent($('#tbSearch').val()), AttachEventToTable);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadTypes();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //open modal for delete category
    $('#btnDelete').on('click', () => {
        $('#cannotDelte').hide();
        $('#DeleteConfirm').prop('disabled', false);
        $('#confirmDelete').modal('show');
    });

    //confirm deleting category
    $('#DeleteConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Issue/IssueType/Delete/' + SelectedType,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    LoadTypes();
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#DeleteConfirm').prop('disabled', true);
                    $('#cannotDelte').slideDown('fast');
                }
            }
        });
    });

    //add new issue type
    $('#btnAdd').on('click', () => { window.location = '/Issue/IssueType/Add'; });

    //edit issue type
    $('#btnEdit').on('click', () => { window.location = '/Issue/IssueType/Edit/' + SelectedType; });

    LoadTypes();
});