﻿using SoftPi.Tariscope.Common;
using SoftPI.Tariscope.WebAdministration.HotelSystems.Scripting.Interfaces;
using System.Collections.Generic;
using System.IO;

public class ExportScript : IScript
{
    private IScriptHost Host;

    private System.Threading.Thread ProcessingThread;
    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
        ProcessingThread = new System.Threading.Thread(ThreadProcessing)
        {
            Name = "WriteFile script thread"
        };

        ProcessingThread.Start();
    }
    private void OnClose(ref bool Cancel)
    {
        if (ProcessingThread != null)
        {
            ProcessingThread.Abort();

            int i = 0;

            while (ProcessingThread != null)
            {
                i += 1;
                System.Threading.Thread.Sleep(100);
                if (i >= 10)
                    break;
            }
        }

        return;
    }
    public void Main(object Parameters)
    {
    }

    public void ThreadProcessing()
    {
        try
        {
            while (true)
            {
                List<CallItemExport> Items = Host.GetItems();
                if (Items != null && Items.Count > 0)
                {
                    Host.AddEvent(string.Format("Writing {0} items", Items.Count), 6);
                    foreach (CallItemExport itm in Items)
                    {
                        try
                        {
                            File.AppendAllText(@"c:\callexport.txt", string.Format("{0}, From {1} to {2}, {3} seconds, Cost: {4}{5}", itm.Datetime, itm.DN, itm.Dialnumber, itm.DurationSeconds, itm.Cost, "\r\n"));
                        }
                        catch { }
                    }
                }
                System.Threading.Thread.Sleep(100);
            }
        }
        catch (System.Threading.ThreadAbortException)
        {
            Host.AddEvent("Export thread terminated", 6);
        }
        ProcessingThread = null;
        return;
    }
}