﻿$(document).ready(function () {

    var selectedTaxID = null;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Tax/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Tax/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateButtons() {
        if (selectedTaxID === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function EditTax(taxID) {
        $('#editModalHeader').attr("hidden", false);
        $('#addModalHeader').attr("hidden", true);

        $('#modalBody').load("/Tax/Edit/" + taxID, function () { $('#editModal').modal({ show: 'true' }); });
    }

    function AddTax() {
        $('#editModalHeader').attr("hidden", true);
        $('#addModalHeader').attr("hidden", false);

        $('#modalBody').load("/Tax/Add", function () { $('#editModal').modal({ show: 'true' }); });
    }

    function DeleteTax() {
        $('#deleteTaxID').val(selectedTaxID);
        $('#confirmDelete').modal({ show: 'true' });
    }

    var header = document.getElementById("taxHead");                 //for sticky head
    var sticky = header.offsetTop;

    //event for show go top button
    $(window).on("scroll", function () {
        //for sticky head
        if (window.pageYOffset > (sticky + 100)) {
            header.classList.add("sticky");
        } else {
            header.classList.remove("sticky");
        }
    });

    $('#tariscope-taxes tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            selectedTaxID = null;
        }
        else {
            selectedTaxID = $(this).find('td[data-name="ID"]').text();
            $('#tariscope-taxes tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }

        UpdateButtons();
    });

    $('#btn-tools').on('click', 'button[data-name="Edit"]', function () {
        EditTax(selectedTaxID);
    });

    $('#btn-tools').on('click', 'button[data-name="Add"]', function () {
        AddTax();
    });

    $('#btn-tools').on('click', 'button[data-name="Delete"]', DeleteTax);

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    $('th').on('click', function () {
        $.ajax({
            type: "POST",
            url: '/Tax/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    location.reload();
                }
            }
        });
    });
});