﻿$(document).ready(() => {
    let selectedNode = null;
    let selectedNodeName = null;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/CommunicationNodes/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/CommunicationNodes/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdateButtons() {
        if (selectedNode === null) {
            $('#btnRename').prop('disabled', true);
            $('#btnDelete').prop('disabled', true);
            $('#btnEdit').prop('disabled', true);
        }
        else {
            $('#btnRename').prop('disabled', false);
            $('#btnDelete').prop('disabled', false);
            $('#btnEdit').prop('disabled', false);
        }
    }

    function AttachEvents() {
        selectedNode = null;

        $('#tableWithNodes tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedNode = null;
                selectedNodeName = null;
            }
            else {
                selectedNode = $(this).find('td[data-name="ID"]').text();
                selectedNodeName = $(this).find('td[data-name="Name"]').text();
                $('#tableWithNodes tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });
        UpdateButtons();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/CommunicationNodes/SetSort/?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        Load();
                    }
                }
            });
        });
    }

    function Load() {
        $('#nodesTable').load('/CommunicationNodes/Get/?Search=' + encodeURIComponent($('#tbSearch').val()), AttachEvents);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            Load();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //show modal for delete node
    $('#btnDelete').on('click', () => {
        $('#btnDeleteNode').prop('disabled', false);
        $('#deleteNodemodal').modal('show');
    });

    //confirm delete node
    $('#btnDeleteNode').on('click', () => {
        $('#deleteNodemodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/Delete/' + selectedNode,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);

                if (response !== null && response.success === true) {
                    DeleteNode(selectedNode);
                    Load();
                }
                else {
                    $('#cannotDeleteNodemodal').modal('show');
                }
            }
        });
    });

    //show modal for rename node
    $('#btnRename').on('click', () => {
        $('#emptyName').hide();
        $('#NodeName').val(selectedNodeName);
        $('#saveNewNodeName').prop('disabled', false);
        $('#renameNodemodal').modal('show');
    });

    //show error when empty node name
    $('#NodeName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#saveNewNodeName').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#saveNewNodeName').prop('disabled', false);
        }
    });
    document.getElementById("NodeName").onkeypress = function (e) {
        var chr = String.fromCharCode(e.which);
        if ('(),.-_></\@$[];:`~%^&*#"'.indexOf(chr) >= 0)
            return false;
    };

    //confirm rename
    $('#saveNewNodeName').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/Rename/' + selectedNode + '/?Name=' + encodeURIComponent($('#NodeName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    RenameNode(selectedNode, $('#NodeName').val());
                    Load();
                    $('#renameNodemodal').modal('hide');
                }
            }
        });
    });

    //show modal to add new node
    $('#btnAdd').on('click', () => {
        $('#emptyNewName').hide();
        $('#NewNodeName').val('');
        $('#saveNewNode').prop('disabled', true);
        $('#addNodemodal').modal('show');
    });

    //show error when empty node name
    $('#NewNodeName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyNewName').slideDown('fast');
            $('#saveNewNode').prop('disabled', true);
        }
        else {
            $('#emptyNewName').slideUp('fast');
            $('#saveNewNode').prop('disabled', false);
        }
    });
    document.getElementById("NewNodeName").onkeypress = function (e) {
        var chr = String.fromCharCode(e.which);
        if ('(),.-_></\[];:`~%^&*#"'.indexOf(chr) >= 0)
            return false;
    };

    //add confirm
    $('#saveNewNode').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/Add/?Name=' + encodeURIComponent($('#NewNodeName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    AddNewNode(response.node, response.restr);
                    Load();
                    $('#addNodemodal').modal('hide');
                }
            }
        });
    });

    //show modal for setups
    $('#btnSettings').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/GetSettings',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#useAccounts').val(response.settings.UseAccounts);
                    $('#contorlExpenses').val(response.settings.ControlLimiting);
                    $('#rating').val(response.settings.Raiting);
                    $('#autoAccountID').prop('checked', response.settings.AutoAccountID)
                    $('#settingsModal').modal('show');
                }
            }
        });
    });

    //save settings
    $('#saveSettings').on('click', () => {
        let use = $('#useAccounts').val() === undefined ? "-1" : $('#useAccounts').val();
        let exp = $('#contorlExpenses').val() === undefined ? "-1" : $('#contorlExpenses').val();

        $.ajax({
            type: "POST",
            url: '/CommunicationNodes/SetSettings/' + use + '/' + exp + '/' + $('#rating').val() + '/?AutoID=' + $('#autoAccountID').prop('checked'),
            traditional: true
        });
    });

    //open devices
    $('#btnEdit').on('click', () => { window.location = '/Devices/' + selectedNode; });

    ExpandLeftMenu();
    Load();
});