﻿$(document).ready(function () {

    var selectedDT = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: `/Service/DayTypes/Export/${$('#PeriodYear').val()}/?type=${t}`,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/DayTypesServices/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateDTButtonsUI() {
        /*update ui for buttons when not selected any service some buttons disabled*/
        if (selectedDT === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);

            $("#btnEditMenu").addClass("disDiv");
            $("#btnDeleteMenu").addClass("disDiv");
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);

            $("#btnEditMenu").removeClass("disDiv");
            $("#btnDeleteMenu").removeClass("disDiv")
        }
    }

    function AttachEventsToTableWithDT() {
        $('#tableWithDTs tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedDT = null;
            }
            else {
                selectedDT = $(this).find('td[data-name="ID"]').text();
                $('#tableWithDTs tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateDTButtonsUI();
        });

        UpdateDTButtonsUI();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/DayTypesServices/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        UpdateTableWithDT($('#tbSearch').val());
                    }
                }
            });
        });
    }

    function UpdateTableWithDT(e) {
        //load table by search string
        $('#dtTable').load(`/Services/DayTypes/Search/${$('#PeriodYear').val()}/?Search=${encodeURIComponent(e)}`, AttachEventsToTableWithDT);
    }

    function initDateTimePicker() {
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepicker').datetimepicker(options);
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;   //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            UpdateTableWithDT($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //validate description
    $('#dtDescription').on('input', function () {
        if ($('#dtDescription').val() === '') {
            $('#descEmpty').slideDown('fast');
            $('#saveDT').attr('disabled', true);
        }
        else {
            $('#descEmpty').slideUp('fast');
            $('#saveDT').attr('disabled', false);
        }
    });

    //show modal for delete selected ip network
    $('#btnDelete, #btnDeleteMenu').on('click', function () {
        $('#confirmDelete').modal('show');
    });

    //confirm deleting
    $('#DeleteConfirm').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/Services/DayTypes/Delete/' + selectedDT,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    UpdateTableWithDT($('#tbSearch').val());
                    selectedDT = null;
                    UpdateDTButtonsUI();
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#DeleteConfirm').attr('disabled', true);
                    $('#DeleteConfirmCancel').attr('disabled', false);
                    $('#cannotDelete').attr('hidden', false);
                }
            }
        });
    });

    //show modal to add dt
    $('#btnAdd, #btnAddMenu').on('click', function () {

        $('#titleAdd').attr('hidden', false);
        $('#titleEdit').attr('hidden', true);

        $('#saveDT').attr('disabled', true);

        $('#dtID').val('0');
        $('#dtDescription').val('');

        try { $('#datetimepicker').data("DateTimePicker").setDate(new Date()); } catch (e) { console.log(e); }

        $('#dtDayType').val($("#dtDayType option:first").val());

        $('#everyyear').attr('checked', false);

        $('#editModal').modal('show');
    });

    //show modal to edit dt
    $('#btnEdit, #btnEditMenu').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/DayTypesServices/GetDayType/' + selectedDT,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#titleAdd').attr('hidden', true);
                    $('#titleEdit').attr('hidden', false);

                    $('#saveDT').attr('disabled', false);

                    $('#dtID').val(response.DT.ID);

                    $('#dtDescription').val(response.DT.Description);
                    $('#lblEdit').html(response.DT.Description);

                    $('#dtDayType').val($("#dtDayType option[value=" + response.DT.DayType + "]").val());

                    $('#everyyear').attr('checked', response.DT.EveryYear);

                    try { $('#datetimepicker').data("DateTimePicker").setDate(new Date(response.DT.Day)); } catch (e) { console.log(e); }

                    $('#editModal').modal('show');
                }
            }
        });
    });

    //save new ip or edited ip
    $('#saveDT').on('click', function () {
        var data = {
            'ID': $('#dtID').val(),
            'Description': $('#dtDescription').val(),
            'DayType': $('#dtDayType option:selected').val(),
            'DayStr': $('#datetimepicker').data('date'),
            'Every': $('#everyyear').is(':checked')
        };

        $.ajax({
            type: "POST",
            async: true,
            data: data,
            datatype: 'json',
            url: '/Services/DayTypes/Edit/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    selectedDT = null;
                    UpdateTableWithDT($('#tbSearch').val());
                    $('#editModal').modal('hide');
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL, #ExportEXCELMenu').on('click', function () { Export("xlsx"); });
    $('#ExportHTML, #ExportHTMLMenu').on('click', function () { Export("html"); });
    $('#ExportCSV, #ExportCSVMenu').on('click', function () { Export("csv"); });
    $('#ExportPDF, #ExportPDFMenu').on('click', function () { Export("pdf"); });

    //shange year
    $('#PeriodYear').change(() => {
        UpdateTableWithDT($('#tbSearch').val());
    });

    //init datetimpicker
    initDateTimePicker();

    //setup current period on start
    $('#PeriodYear').val(new Date().getFullYear() + '');
    UpdateTableWithDT($('#tbSearch').val());
});