﻿Tariscope.Cookie = (function () {
    var _minDate = Tariscope.Date.getMinDate();
    var _maxDate = Tariscope.Date.getMaxDate();

    return {
        // create a new cookie
        create: function (name, value, expireYear, expireMonth, expireDay, path, domain, secure) {
            var cookie_string = name + "=" + escape(value);

            if (exp_y) {
                var expires = new Date(expireYear, expireMonth, expireDay);
                cookie_string += "; expires=" + expires.toGMTString();
            }

            if (path) cookie_string += "; path=" + escape(path);
            if (domain) cookie_string += "; domain=" + escape(domain);
            if (secure) cookie_string += "; secure";

            document.cookie = cookie_string;
        },

        // get cookie
        get: function (cookieName) {
            var results = document.cookie.match('(^|;) ?' + cookieName + '=([^;]*)(;|$)');

            if (results) {
                return (unescape(results[2]));
            }
            else {
                return null;
            }
        },

        // remove cookie
        remove: function (cookieName) {
            var currentDate = new Date();
            currentDate.setTime(currentDate.getTime() - 1);
            document.cookie = cookieName += "=; expires=" + currentDate.toGMTString();
        }
    }
})();