﻿window.NodeIsLoaded = false;   //show, Node loaded or not
var Nodes = [];             //list of all Nodes
var Devices = [];           //list of all Nodes

{
    let NodeLevelMargin = 7;

    let NodesState = {};
    let NodesEntryState = {};
    let DevicesEntryState = {};
    let DeviceContentState = {};

    let itemsList = [];             //list of all added menu items
    let itemsLevel = [];            //list for all added menu items margin set

    let RootName = 'NewNodesMenu';
    let NodesID = 'CNode_';
    let NodeManagement = 'CNodeManagement';
    let NodeWizard = 'CNodeWizard';
    let DeviceManagement = 'CDeviceManagement';
    let AbonentsID = 'CAbonents_';
    let AbonentsLimitedID = 'CAbonentsLimited_';
    let DevicesID = 'CDevices_';
    let ConcreteDevicesID = 'CSelectedDevice_';
    let NP = 'NumPlane_';
    let RG = 'Rgate_';
    let PR = 'RPref_';
    let RS = 'RClas_';
    let DeviceContent = 'DeviceContent';

    function BuildItem(root, id, title, level, url, ic, chevrone, hide = true) {
        /* create menu tree-item */
        var li = document.createElement('li');
        li.id = id;
        li.className = "treeItem";

        var a = document.createElement('a');
        a.setAttribute('href', url == '#' ? 'javascript:;' : url);
        a.style.marginLeft = NodeLevelMargin * level + "px";

        var icon = document.createElement('i');
        icon.id = "iconTree";
        icon.className = ic;

        var ttl = document.createElement('span');
        ttl.innerHTML = title;

        a.appendChild(icon);
        a.appendChild(ttl);

        if (chevrone) {
            var chev = document.createElement('i');
            chev.className = "fa fa-chevron-down treeChevroneRight treeChevroneSmall";

            a.appendChild(chev);
        }

        li.appendChild(a);


        $(li).insertAfter($('#' + root));

        itemsList.push(li);
        itemsLevel.push(level);

        if (hide)
            $(li).hide();

        return li.id;
    }

    function changeLevel(item, level) {
        /*change left margin for menu items*/
        $(item).find('a').css('margin-left', NodeLevelMargin * level + "px");
    }

    function showChevron(item, show) {
        /* show or hide chevron icon*/
        if (show) {
            $(item).find($('.treeChevroneRight')).hide();
        }
        else {
            $(item).find($('.treeChevroneRight')).show();
        }
    }

    function rotateChevron(item, back) {
        /* show or hide chevron icon*/
        if (back) {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(-90deg)');
        }
        else {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(0)');
        }
    }

    function AddNodeManagement(Parent) {
        let item = BuildItem(Parent, NodeWizard, $('#LeftSideLocalizationString_DeviceWizard').val(), 1, '/Wizard', "fa fa-magic", false);

        Nodes.push(item);
        NodesState[item] = true;

        let item2 = BuildItem(item, NodeManagement, $('#LeftSideLocalizationString_NodeManagement').val(), 1, '/CommunicationNodes/Management', "fa fa-cog", false);

        Nodes.push(item2);
        NodesState[item2] = true;

        

        return item2;
    }

    function AddNDeviceManagement(Label, Parent, id) {
        let item = BuildItem(Parent, Label + DeviceManagement, $('#LeftSideLocalizationString_DevicesManagement').val(), 5, '/Devices/' + id, "fa fa-cog", false);

        Devices.push(item);

        return item;
    }

    function AddNode(Parent, e, s = true, r = true) {

        let id = NodesID + e.ID;

        var node = BuildItem(Parent, id, e.Name, 1, '#', "fa fa-cube", true, s);

        var abonents = BuildItem(node, AbonentsID + e.ID, $('#LeftSideLocalizationString_Subscribers').val(), 3, '/Subscribers/' + e.ID, "fa fa-users", false);

        var abonentsLimited;

        if (r) {
            abonentsLimited = BuildItem(abonents, AbonentsLimitedID + e.ID, $('#LeftSideLocalizationString_RSubscribers').val(), 3, '/RestrictedSubscribers/' + e.ID, "fa fa-user-times", false);
        }

        var devices = BuildItem(r ? abonentsLimited : abonents, DevicesID + e.ID, $('#LeftSideLocalizationString_Devices').val(), 3, '#', "fa fa-laptop-code", true);


        $('#' + devices).on('click', function () {//show node devices
            ShowDevices(node);
        });

        for (key in e.Devices) {
            AddDevice(id, devices, key, e.Devices[key], 5, r);
        }

        AddNDeviceManagement(id, devices, e.ID);

        DevicesEntryState[id] = true;

        Nodes.push(node);
        NodesState[node] = s;

        NodesEntryState[e.ID] = true;

        $('#' + node).on('click', function () {//show node children (abonents, limited abonents, devices)
            ShowNodeEntry(node.replace(NodesID, ''));
        });

        return node;
    }

    function AddDevice(Label, Parent, id, name, level, r) {
        let item = BuildItem(Parent, Label + ConcreteDevicesID + id, name, level, '#', "fa fa-laptop", true);
        Devices.push(item);

        AddDeviceEntries(DeviceContent, item, id, level + 2, r);

        $('#' + item).on('click', function () {
            ShowDeviceContent(item);
        });
    }

    function AddDeviceEntries(Label, Parent, id, level, r) {
        BuildItem(Parent, Label + Parent + PR + id, $('#LeftSideLocalizationString_OBSSettings').val(), level, '/Devices/Edit/' + id, "fa fa-cog", false);

        if (r) {
            BuildItem(Parent, Label + Parent + RS + id, $('#LeftSideLocalizationString_RC').val(), level, '/Devices/RestrictionClasses/' + id, "fa fa-ruler-combined", false);
        }

        BuildItem(Parent, Label + Parent + PR + id, $('#LeftSideLocalizationString_Prefixes').val(), level, '/Devices/Prefixes/' + id, "fa fa-font", false);
        BuildItem(Parent, Label + Parent + RG + id, $('#LeftSideLocalizationString_RG').val(), level, '/Devices/RoutesGateways/' + id, "fa fa-route", false);
        BuildItem(Parent, Label + Parent + NP + id, $('#LeftSideLocalizationString_DNPlan').val(), level, '/Devices/DNPlans/' + id, "fa fa-arrows-alt-h", false);

        DeviceContentState[Label + Parent] = true;
    }



    window.ShowNodes = function (parent, force = false) {
        /*show all Nodes*/
        Nodes.forEach(function (element) {
            if (force || NodesState[element]) {
                $('#' + element).slideDown("fast");
                NodesState[element] = false;
            }
            else {
                CloseAllNodesEntry();
                $('#' + element).slideUp("fast");
                NodesState[element] = true;
            }

            rotateChevron(parent, !NodesState[element]);
        });
    };

    window.ShowNodeEntry = function (parent, force = false) {

        /*show entry of incoming and outgoing for Node*/
        if (force || !NodesEntryState[parent]) {
            CloseAllDevices();

            $('#' + AbonentsID + parent).slideUp("fast");
            $('#' + AbonentsLimitedID + parent).slideUp("fast");
            $('#' + DevicesID + parent).slideUp("fast");

            NodesEntryState[parent] = true;
        }
        else {
            CloseAllNodesEntry();

            $('#' + AbonentsID + parent).slideDown("fast");
            $('#' + AbonentsLimitedID + parent).slideDown("fast");
            $('#' + DevicesID + parent).slideDown("fast");

            NodesEntryState[parent] = false;
        }

        rotateChevron(NodesID + parent, !NodesEntryState[parent]);
    };

    window.DeleteNode = function (id) {
        let es = [];

        es.push($('li[id^="DeviceContentCNode_' + id + '"'));
        es.push($('#CDevices_' + id));
        es.push($('#CAbonentsLimited_' + id));
        es.push($('#CAbonents_' + id));
        es.push($('li[id^="CNode_' + id + '"'));

        es.forEach(e => {
            e.animate({ opacity: 0.1 }, 300, function () { e.remove(); });
        });
    };

    window.RenameNode = function (id, name) {
        $('#CNode_' + id).find('span').text(name);
    };

    window.AddNewNode = function (node, r) {
        AddNode(NodeManagement, node, NodesState[NodeManagement], r);
    };

    window.ShowDevices = function (node, force = false) {
        Devices.forEach(e => {
            if (e.includes(node)) {
                if (force || !DevicesEntryState[node]) {
                    CloseAllDeviceContent();
                    $('#' + e).slideUp("fast");
                }
                else {
                    $('#' + e).slideDown("fast");
                }
            }
        });

        if (force || !DevicesEntryState[node]) {
            DevicesEntryState[node] = true;
            rotateChevron(DevicesID + node.replace(NodesID, ''), false);
        }
        else {
            DevicesEntryState[node] = false;
            rotateChevron(DevicesID + node.replace(NodesID, ''), true);
        }
    };

    window.ShowDeviceContent = function (parent, force = false) {
        if (force || !DeviceContentState[DeviceContent + parent]) {

            $('li[id^="' + DeviceContent + parent).slideUp("fast");

            DeviceContentState[DeviceContent + parent] = true;
        }
        else {
            CloseAllDeviceContent();
            $('li[id^="' + DeviceContent + parent).slideDown("fast");
            DeviceContentState[DeviceContent + parent] = false;
        }

        rotateChevron(parent, !DeviceContentState[DeviceContent + parent]);
    };



    function CloseAllNodesEntry() {
        CloseAllDeviceContent();
        CloseAllDevices();

        for (var key in NodesEntryState) {
            if (!NodesEntryState[key]) {
                $('#' + AbonentsID + key).slideUp("fast");
                $('#' + AbonentsLimitedID + key).slideUp("fast");
                $('#' + DevicesID + key).slideUp("fast");

                NodesEntryState[key] = true;
                rotateChevron(NodesID + key, false);
            }
        }
    }

    function CloseAllDevices() {
        for (var key in DevicesEntryState) {
            if (!DevicesEntryState[key]) {

                $('li[id^="' + key + ConcreteDevicesID + '"]').slideUp("fast");
                $('li[id^="' + key + DeviceManagement + '"]').slideUp("fast");

                DevicesEntryState[key] = true;
                rotateChevron(DevicesID + key.replace(NodesID, ''), false);
            }
        }
    }

    function CloseAllDeviceContent() {
        for (var key in DeviceContentState) {
            if (!DeviceContentState[key]) {

                $('li[id^="' + DeviceContent + '"]').slideUp("fast");

                DeviceContentState[key] = true;
                rotateChevron(key.replace(DeviceContent, ''), false);
            }
        }
    }


    function LoadNodes(callback = null) {
        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/CommunicationNodes/GetMenu/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    var settings = AddNodeManagement(RootName);

                    response.list.forEach(function (element) {
                        AddNode(settings, element, true, response.restr);
                    });

                    $('#NewNodesMenu').on('click', () => {
                        ShowNodes(RootName);
                    });


                    NodeIsLoaded = true;
                    if (callback !== null)
                        callback();
                }
                else {
                    console.log("Load Nodes filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    $(document).ready(function () {

        /*hide chevron icon and set margin left to 0 whet menu is closing*/
        $('#MenuHamburger').on('click', function () {
            if ($('#SideMenu').width() >= 250) {
                itemsList.forEach(function (element) {
                    changeLevel(element, 0);
                    showChevron(element, true);
                });

                showChevron($('#NewNodesMenu'), true);
            }
            else {
                var i = 0;
                itemsList.forEach(function (element) {
                    changeLevel(element, itemsLevel[i]);
                    showChevron(element, false);
                    i++;
                });

                showChevron($('#NewNodesMenu'), false);
            }

        });

        LoadNodes();
    });
}