﻿function UpdateButtons() {
    if (selectedCodes.length >= 1) {
        $("#btnEdit").attr("disabled", false);
        $("#btnMove").attr("disabled", false);
        $("#btnDelete").attr("disabled", false);
        $("#btnResetSelection").attr("disabled", false);

        $("#btnEditMenu").removeClass("disDiv");
        $("#btnMoveMenu").removeClass("disDiv");
        $("#btnDeleteMenu").removeClass("disDiv");
        $("#btnResetSelectionMenu").removeClass("disDiv");
    }
    else {
        $("#btnEdit").attr("disabled", true);
        $("#btnMove").attr("disabled", true);
        $("#btnDelete").attr("disabled", true);
        $("#btnResetSelection").attr("disabled", true);

        $("#btnEditMenu").addClass("disDiv");
        $("#btnMoveMenu").addClass("disDiv");
        $("#btnDeleteMenu").addClass("disDiv");
        $("#btnResetSelectionMenu").addClass("disDiv");
    }
}

const saveResultUpdated = 0;
const saveResultRecreated = 1;

$(document).ready(() => {
    let isAdd = true;

    function initdatetime() {
        //init datetimepicker
        var options = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),
            locale: $('#LocaleThread').val(),
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true,
            format: 'L'
        };

        $('#datetimepickerTo').datetimepicker(options);
        $('#datetimepickerEditTo').datetimepicker(options);
        $('#datetimepickerFrom').datetimepicker(options);
        $('#datetimepickerEditFrom').datetimepicker(options);
    }

    function ShowIfName() {
        if (!(!$('#addCodeName').val() || !$('#addCodeName').val().trim()))
            $('#addCode').prop('disabled', false);
    }

    function ShowIfCode() {
        if (!(!$('#addCodeCode').val() || !$('#addCodeCode').val().trim()) && !CheckOnZeroStart())
            $('#addCode').prop('disabled', false);
    }

    function CheckOnZeroStart() {
        return $('#addCodeCode').val().startsWith('0');
    }

    function ShowUploadModal(show) {
        if (show) {
            $("#uploadFilemodal").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#uploadFilemodal").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
        }
    }

    function SetProgress(e) {
        //set progress for anything
        $('#restoreProgress').css('width', e + '%');
    }

    function ShowCountries() {
        $.ajax({
            type: "POST",
            url: '/TelephoneCodes/GetContries',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#CountiesContainer').empty();
                    let data = '';


                    response.countries.forEach(e => {
                        data += '<div class="form-check" style="margin-top: 5px;">';
                        data += '<input data-code="' + e.Key + '" class="countryinput" id="Country.' + e.Key + '" hidden type="checkbox" name="Country.' + e.Key + '" />';
                        data += '<label class="switch" for="Country.' + e.Key + '" style="margin-bottom: 0; margin-top: 5px;"></label>';
                        data += '<span style="margin-left:5px; vertical-align: middle">' + e.Value + '</span></div>';
                    });
                    $('#CountiesContainer').html(data);
                    AttachToCountries();
                    $('#ImportSettingsmodal').modal('show');
                }
            }
        });
    }

    function AttachToCountries() {
        $('.countryinput').change(function () {
            if (!$(this).prop('checked'))
                $('#SelectAllcountries').prop('checked', false);
        });
    }

    function GetDataAboutImport() {
        $.ajax({
            type: "POST",
            url: '/TelephoneCodes/GetImportProcess',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    if (response.IsComplete) {
                        ShowImportModal(false);
                        if (response.IsCompleteResult) {
                            $('#successImportmodal').modal('show');
                        }
                        else {
                            $('#failImportMsg').text(response.IsCompleteMsg);
                            $('#failImportmodal').modal('show');
                        }
                    }
                    else {
                        $('#CountryOnImport').text(response.Country);
                        $('#CountImported').text(response.Count);
                        $('#TotalToImport').text(response.Total);

                        setTimeout(GetDataAboutImport, 500);
                    }
                }
            }
        });
    }

    function ShowImportModal(show) {
        if (show) {
            $("#importDatamodal").modal({
                backdrop: "static",
                keyboard: false,
                show: true
            });
        }
        else {
            $("#importDatamodal").modal('hide');

            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
        }
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 700;   //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            Load();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //save state of multiselect option to cockie
    $('#switchMultiselect').on('click', function () {

        var state = !$('#multiselect').is(':checked') ? 'checked' : 'e';

        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/SaveMultiselectState/?state=' + state,
            traditional: true
        });
    });

    //show modal to add a new code
    $('#btnAdd, #btnAddMenu').on('click', () => {
        isAdd = true;

        $('#ApplyToAllLangs').prop('checked', false);

        $('#areaPreview').attr('src', '/Content/Images/AreaCode_0.jpg');

        $('#addCodemodalTitleID').text($('#AddTitle').val());
        $('#AutoFitSection').show();

        if (selectedCodes.length === 0 || selectedCodes.length > 1) {
            $('#AutoFit').prop('checked', true);
            $('#AutoFitSection').addClass('disDiv');
        }
        else {
            $('#AutoFit').prop('checked', false);
            $('#AutoFitSection').removeClass('disDiv');
        }

        $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date(1900, 0));
        $('#datetimepickerTo').data("DateTimePicker").setDate(new Date(3000, 0));

        $('#emptyName').hide();
        $('#emptyCode').hide();

        $('#addCodeName').val('');
        $('#addCodeCode').val('');
        $('#addCodeBrack').val('');

        $('#IsLocalSection').removeClass('disDiv');
        $('#IsLocal').prop('checked', false);
        $('#NumberingZoneSection').show();

        $('#addCode').prop('disabled', true);

        $('#addCodemodal').modal('show');
    });

    //show error when empty code
    $('#addCodeCode').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyCode').slideDown('fast');
            $('#startZeroCode').slideUp('fast');
            $('#addCode').prop('disabled', true);

            $('#areaPreview').attr('src', '/Content/Images/AreaCode_0.jpg');
        }
        else {
            $('#emptyCode').slideUp('fast');

            if (CheckOnZeroStart()) {
                $('#startZeroCode').slideDown('fast');
                $('#addCode').prop('disabled', true);
            }
            else {
                $('#startZeroCode').slideUp('fast');
                ShowIfName();
            }

            $('#areaPreview').attr('src', '/Content/Images/AreaCode_' + $(this).val().substring(0, 1) + '.jpg');
        }
    });

    //show error when empty name
    $('#addCodeName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#addCode').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            ShowIfCode();
        }
    });

    //save new code
    $('#addCode').on('click', () => {
        $('#addCodemodal').modal('hide');
        ShowSpinner(true);

        if (isAdd) {//add single
            let formData = new FormData();
            formData.append('to', $('#datetimepickerTo').data('date'));
            formData.append('from', $('#datetimepickerFrom').data('date'));
            formData.append('name', $('#addCodeName').val());
            formData.append('brackets', $('#addCodeBrack').val());
            formData.append('code', $('#addCodeCode').val());
            formData.append('parent', selectedCodes.length > 0 ? selectedCodes[0] : -1);
            formData.append('autofit', $('#AutoFit').prop('checked'));
            formData.append('addall', $('#ApplyToAllLangs').prop('checked'));
            formData.append('islocal', $('#IsLocal').prop('checked'));

            $.ajax({
                type: "POST",
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                url: '/TelephoneCodes/Add',
                success: function (response) {
                    ShowSpinner(false);
                    if (response !== null && response.success === true) {
                        try {
                            if ($('tbody[id="contentArea"]').length > 0) {//non tree
                                window.clusterize.prepend([GetRow(response.code, false)]);
                            }
                            else {//tree
                                $('.tree').treegrid('attachNode', GetRow(response.code, true), true);
                                $('.tree').treegrid('attachNode', GetEmptyRow(response.code.ID), false);
                                $('tr[data-id="' + response.code.ID + '"]').treegrid('initState');
                                $('tr[class="treegrid-0 treegrid-parent-' + response.code.ParentId + '"]').remove();
                            }
                        } catch (e) {
                            console.log(e);
                        }
                    }
                    else {
                        $('#cannotAddcodemodal').modal('show');
                    }
                }
            });
        }
        else {//edit single
            let formData = new FormData();
            formData.append('to', $('#datetimepickerTo').data('date'));
            formData.append('from', $('#datetimepickerFrom').data('date'));
            formData.append('name', $('#addCodeName').val());
            formData.append('brackets', $('#addCodeBrack').val());
            formData.append('code', $('#addCodeCode').val());
            formData.append('id', selectedCodes[0]);
            formData.append('addall', $('#ApplyToAllLangs').prop('checked'));
            formData.append('islocal', $('#IsLocal').prop('checked'));

            $.ajax({
                type: "POST",
                data: formData,
                datatype: 'application/octet-stream',
                contentType: false,
                processData: false,
                traditional: true,
                url: '/TelephoneCodes/Save',
                success: function (response) {
                    ShowSpinner(false);
                    if (response !== null && response.success === true) {

                        if (response.saveResult === saveResultUpdated) {
                            let tr = $('tr[data-id="' + selectedCodes[0] + '"]');
                            tr.find('td[data-name="FromDate"]').text($('#datetimepickerFrom').data('date'));
                            tr.find('td[data-name="ToDate"]').text($('#datetimepickerTo').data('date'));
                            tr.find('td[data-name="Code"]').text($('#addCodeCode').val());

                            let name = $('#addCodeName').val();
                            if ($('#addCodeBrack').val())
                                name += ' (' + $('#addCodeBrack').val() + ')';

                            tr.find('td[data-name="Name"]').find('span[data-n="1"]').text(name);

                            if ($('tbody[id="contentArea"]').length > 0) {//non tree
                                window.clusterize.updateRow(window.clusterize.findIndex((element, index, array) => {
                                    return element.includes('data-id="' + selectedCodes[0] + '"');
                                }), '<tr data-id="' + selectedCodes[0] + '">' + tr.html() + '</tr>');
                            }
                        }
                        else if (response.saveResult === saveResultRecreated) {
                            window.location.reload();
                        }
                    }
                    else {
                        $('#cannotEditcodemodal').modal('show');
                    }
                }
            });
        }
    });

    //show modal to delete phone codes
    $('#btnDelete, #btnDeleteMenu').on('click', () => { $('#deleteCodemodal').modal('show'); });

    //confirm delete
    $('#DeleteConfirm').on('click', () => {
        $('#deleteCodemodal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/TelephoneCodes/Delete/?IDs=' + encodeURIComponent(selectedCodes.join(',')),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    selectedCodes.forEach(e => {
                        if ($('tbody[id="contentArea"]').length > 0) {//non tree
                            window.clusterize.deleteRow(window.clusterize.findIndex((element, index, array) => { return element.includes('data-id="' + e + '"'); }));
                            $('tr[data-id="' + e + '"]').remove();
                        }
                        else {//tree
                            try {
                                $('tr[data-id="' + e + '"]').treegrid('removeNode');
                            } catch (e) { console.log(e); }
                        }
                    });
                    selectedCodes = [];
                    UpdateButtons();
                    ShowSpinner(false);
                }
                else {
                    ShowSpinner(false);
                    $('#cannotDeletecodemodal').modal('show');
                }
            }
        });
    });

    //show modal with info
    $('#btnInfo, #btnInfoMenu').on('click', () => { $('#codesInfomodal').modal('show'); });

    //reset selection
    $('#btnResetSelection, #btnResetSelectionMenu').on('click', () => {
        selectedCodes = [];
        $('#tariscope-tlphc tr.selected').removeClass('selected');
        UpdateButtons();
    });

    //show modal to edit code
    $('#btnEdit, #btnEditMenu').on('click', () => {
        if (selectedCodes.length === 1) {
            isAdd = false;
            $('#ApplyToAllLangs').prop('checked', false);
            $('#addCodemodalTitleID').text($('#EditTitle').val());
            $('#AutoFitSection').hide();

            $.ajax({
                type: "POST",
                url: '/TelephoneCodes/Get/' + selectedCodes[0],
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date(response.code.From));
                        $('#datetimepickerTo').data("DateTimePicker").setDate(new Date(response.code.To));

                        $('#emptyName').hide();
                        $('#emptyCode').hide();

                        $('#addCodeName').val(response.code.Name);

                        if (response.code.IsLocal === true) {
                            $('#addCodeCode').val(response.code.Code.substring(1));
                            $('#NumberingZoneSection').hide();
                            $('#IsLocal').prop('checked', true);
                        }
                        else {
                            $('#addCodeCode').val(response.code.Code);
                            $('#IsLocal').prop('checked', false);
                        }

                        $('#areaPreview').attr('src', '/Content/Images/AreaCode_' + $('#addCodeCode').val().substring(0, 1) + '.jpg');

                        $('#addCodeBrack').val(response.code.BracketsText);

                        $('#addCode').prop('disabled', false);
                        $('#addCodemodal').modal('show');
                    }
                }
            });
        }
        else {
            $('#ApplyToAllLangsMulti').prop('checked', false);
            $('#editCodeName').val('');
            $('#editCodeBrack').val('');
            $('#datetimepickerEditFrom').data("DateTimePicker").setDate(null);
            $('#datetimepickerEditTo').data("DateTimePicker").setDate(null);
            $('#multiEditcode').modal('show');
        }
    });

    //confirm multi edit
    $('#editCodes').on('click', () => {
        $('#multiEditcode').modal('hide');
        ShowSpinner(true);

        var formData = new FormData();
        formData.append('to', $('#datetimepickerEditTo').data('date'));
        formData.append('from', $('#datetimepickerEditFrom').data('date'));
        formData.append('name', $('#editCodeName').val());
        formData.append('brackets', $('#editCodeBrack').val());
        formData.append('addall', $('#ApplyToAllLangsMulti').prop('checked'));

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/TelephoneCodes/MultiSave/?IDs=' + encodeURIComponent(selectedCodes.join(',')),
            success: function (response) {
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    selectedCodes.forEach(e => {
                        let tr = $('tr[data-id="' + e + '"]');

                        if ($('#datetimepickerEditFrom').data('date'))
                            tr.find('td[data-name="FromDate"]').text($('#datetimepickerEditFrom').data('date'));
                        if ($('#datetimepickerEditTo').data('date'))
                            tr.find('td[data-name="ToDate"]').text($('#datetimepickerEditTo').data('date'));

                        let newName = $('#editCodeName').val();
                        let oldName = tr.find('td[data-name="Name"]').find('span[data-n="1"]').text();

                        if ($('#editCodeName').val() && $('#editCodeBrack').val()) {//replase name and in brackets text
                            console.log('replace name and bracket');
                            newName += ' (' + $('#editCodeBrack').val() + ')';
                            tr.find('td[data-name="Name"]').find('span[data-n="1"]').text(newName);
                        }
                        else if (!$('#editCodeName').val() && $('#editCodeBrack').val()) {//replace only text in brackets
                            let name = oldName.replace(/[(](.+)[)]/g, '(' + $('#editCodeBrack').val() + ')');

                            if (name === oldName)
                                name += ' (' + $('#editCodeBrack').val() + ')';

                            tr.find('td[data-name="Name"]').find('span[data-n="1"]').text(name);
                        }
                        else if ($('#editCodeName').val() && !$('#editCodeBrack').val()) {//replace only name
                            let name = oldName.replace(/(.+)[(]/, $('#editCodeName').val() + ' (');

                            if (name === oldName)
                                name = $('#editCodeName').val();

                            tr.find('td[data-name="Name"]').find('span[data-n="1"]').text(name);
                        }

                        if ($('tbody[id="contentArea"]').length > 0) {//non tree
                            window.clusterize.updateRow(window.clusterize.findIndex((element, index, array) => {
                                return element.includes('data-id="' + e + '"');
                            }), '<tr data-id="' + e + '">' + tr.html() + '</tr>');
                        }
                    });
                }
            }
        });
    });

    //open window to select file
    $('#btnImport').on('click', () => { $("#FileInput").click(); });

    //uploading files into server (with progress)
    $("#FileInput").change(function () {
        SetProgress(0);

        var data = document.getElementById("FileInput").files[0];
        var formData = new FormData();
        formData.append(data.name, data);

        ShowUploadModal(true);

        $.ajax({
            type: 'POST',
            async: true,
            url: '/TelephoneCodes/Upload/',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            xhr: function () {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener("progress", function (e) {
                    if (e.lengthComputable) { SetProgress(Math.round((e.loaded / e.total) * 100)); }
                }, false);
                return xhr;
            },
            error: function (jqxhr, status, errorThrown) {
                if (jqxhr.status === 423)
                    window.location.href = "/Account/Trial";

                console.log('jqxhr:');
                console.log(jqxhr);
                console.log('status:');
                console.log(status);
                console.log('errorThrown:');
                console.log(errorThrown);

            },
            success: function (response) {
                if (response.success === true) {
                    ShowUploadModal(false);
                    ShowCountries();
                }
                else {
                    console.log(response.msg);
                }
            }
        });
    });

    //unselect all countries
    $('#unselectAllCountries').on('click', () => {
        $('.countryinput').prop('checked', false);
        $('#SelectAllcountries').prop('checked', false);
    });

    //select all countries
    $('#SelectAllcountries').change(() => {
        if ($('#SelectAllcountries').prop('checked'))
            $('.countryinput').prop('checked', true);
    });

    //start import codes from file
    $('#confirmImportstart').on('click', () => {
        var formData = new FormData();
        formData.append('IncludeProviders', $('#IncludeProviders').prop('checked'));
        formData.append('IncludeContryName', $('#IncludeContryName').prop('checked'));
        formData.append('SelectAllcountries', $('#SelectAllcountries').prop('checked'));

        let cc = [];

        if (!$('#SelectAllcountries').prop('checked')) {
            let els = $('.countryinput');
            els.map(e => {
                if ($(els[e]).prop('checked'))
                    cc.push($(els[e]).data('code'));
            });
        }

        formData.append('CC', cc.join(','));

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/TelephoneCodes/StartImportFromFile',
            success: function (response) {
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    ShowImportModal(true);
                    GetDataAboutImport();
                }
            }
        });
    });

    //disable tree
    $('#DisableTree').change(() => {
        Load();
        var state = $('#DisableTree').is(':checked') ? 'checked' : 'e';
        $.ajax({
            type: "POST",
            async: true,
            url: '/TelephoneCodes/SaveDisTree/?state=' + state,
            traditional: true
        });
    });

    //go to import
    $('#btnImportWizard, #btnImportWizardMenu').on('click', () => { window.location = '/TelephoneCodes/Import'; });

    //start to import online 
    $('#btnImportOnline, #btnImportOnlineMenu').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            traditional: true,
            url: '/TelephoneCodes/LoadOnlineCodes',
            success: function (response) {
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    ShowCountries();
                }
                else {
                    $('#failImportMsg').text(response.msg);
                    $('#failImportmodal').modal('show');
                }
            }
        });
    });

    //hide or show numbering zone
    $('#IsLocal').change(() => {
        if ($('#IsLocal').prop('checked')) {
            $('#NumberingZoneSection').slideUp('fast');
        }
        else {
            $('#NumberingZoneSection').slideDown('fast');
        }
    });

    //mode codes
    $('#btnMove, #btnMoveMenu').on('click', () => {
        $('#newParentcode').val('');
        $('#emptyParent').hide();
        $('#saveNewParent').prop('disabled', true);
        $('#moveCodesmodal').modal('show');
    });

    //empty parent error
    $('#newParentcode').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyParent').slideDown('fast');
            $('#saveNewParent').prop('disabled', true);
        }
        else {
            $('#emptyParent').slideUp('fast');
            $('#saveNewParent').prop('disabled', false);
        }
    });

    //confirm save new parent
    $('#saveNewParent').on('click', () => {
        $('#moveCodesmodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            traditional: true,
            url: '/TelephoneCodes/ModeCodes/?Parent=' + encodeURIComponent($('#newParentcode').val()) + '&IDs=' + encodeURIComponent(selectedCodes.join(',')),
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.location.reload();
                }
                else {
                    ShowSpinner(false);
                    $('#moveCodesErrromodal').modal('show');
                }
                
            }
        });
    });

    Load();
    initdatetime();
});