﻿$(document).ready(function () {
    let SQLMode;

    function GetSQLForFilter() {
        //show sql filter
        SQLMode = 1;
        $('#sqlContainer').load("/TariscopeViews/GetSQLEditor/?sql=" + encodeURIComponent($('#Filter').val()), () => { $('#SQLEditor').modal('show'); });
    }

    function GetSQLForBaseFilter() {
        //show base sql filter
        SQLMode = 2;
        $('#sqlContainer').load("/TariscopeViews/GetSQLEditor/?sql=" + encodeURIComponent($('#BaseFilter').val()), () => { $('#SQLEditor').modal('show'); });
    }

    function SaveSQLFilter() {

        if (SQLMode === 1) {
            $('#Filter').val(window.SQLEditor.getValue());
        }
        else if (SQLMode === 2) {
            $('#BaseFilter').val(window.SQLEditor.getValue());
        }

        $('#SQLEditor').modal('hide');
    }

    function ReloadFields() {
        var f = $("[id^='field_']");
        $('#FieldsConcentrator').empty();

        f.map(function (e) {
            if ($(f[e]).prop('checked') === true) {
                $('#FieldsConcentrator').append('<span class="label label-default">' + $(f[e]).attr('FieldName') + '</span>&nbsp;');
            }
        });

        if ($('#FieldsSortingConcentrator').is(':empty')) {
            $('#FieldsConcentrator').append('<span>' + $('#NoFSelected').val() + '</span>');
        }

        $('#FieldsEditor').modal('hide');
    }

    function ReloadSortedFields() {
        var f = $("[id^='sorted_']");
        $('#FieldsSortingConcentrator').empty();

        f.map(function (e) {
            if ($(f[e]).prop('checked') === true) {
                $('#FieldsSortingConcentrator').append('<span class="label label-default">' + $(f[e]).attr('FieldName') + '</span>&nbsp;');
            }
        });

        if ($('#FieldsSortingConcentrator').is(':empty')) {
            $('#FieldsSortingConcentrator').append('<span>' + $('#NoFSorting').val() + '</span>');
        }

        $('#SortedFieldsEditor').modal('hide');
    }

    function ReloadGroupedFields() {
        var f = $("[id^='grouped_']");
        $('#FieldsGroupConcentrator').empty();

        f.map(function (e) {
            if ($(f[e]).prop('checked') === true) {
                if ($('#ViewGroup_' + $(this).attr('FieldBDName')).val() === "1")
                    $('#FieldsGroupConcentrator').append('<span class="label label-default">' + $(f[e]).attr('FieldName') + '</span>&nbsp;');
            }
        });

        if ($('#FieldsGroupConcentrator').is(':empty')) {
            $('#FieldsGroupConcentrator').append('<span>' + $('#NoFGrouping').val() + '</span>');
        }

        $('#GroupedFieldsEditor').modal('hide');
    }

    //open modal for edit sql filters
    $('#btnEditFilter').on('click', GetSQLForFilter);
    $('#btnEditBaseFilter').on('click', GetSQLForBaseFilter);

    //save sql to fields
    $('#btnSaveSQL').on('click', SaveSQLFilter);

    //show modal for select fields
    $('#btnEditFields').on('click', () => { $('#FieldsEditor').modal('show'); });

    //reload fields
    $('#btnSaveFields').on('click', ReloadFields);

    //show modal for select sorted fields
    $('#btnEditSorting').on('click', () => { $('#SortedFieldsEditor').modal('show'); });

    //reload sorted fields
    $('#btnSaveSortedFields').on('click', ReloadSortedFields);

    //show/hide sorted fields
    $('[id^="sorted_"]').change(function () {
        $('[id="sorted_dir_' + $(this).attr('FieldBDName') + '"]').css('opacity', $(this).prop('checked') === true ? "1" : "0");
    });

    //show/hide grouped fields
    $('[id^="grouped_"]').change(function () {
        console.log($('[id="grouped_dir_' + $(this).attr('FieldBDName') + '"]'));
        $('[id="grouped_dir_' + $(this).attr('FieldBDName') + '"]').css('opacity', $(this).prop('checked') === true ? "1" : "0");
    });

    //show modal for select grouped fields
    $('#btnEditGroup').on('click', () => { $('#GroupedFieldsEditor').modal('show'); });

    //reload grouped fields
    $('#btnSaveGroupedFields').on('click', ReloadGroupedFields);

    //move buttons (top down)
    $('.tcxField').mouseover(function () {
        $(this).append($('#btnsTopDown'));
    });

    //mode top
    $('#btnMoveTcxFieldTop').on('click', function () {
        let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
        let CurrentElement = $(this).parent().parent();
        let PrevElement = $(this).parent().parent().prev();

        if (PrevElement.length > 0) {
            let ExpectPrevNumber = $(PrevElement).find('input').attr('enumnumber') * 1;
            let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
            let PrevInput = $(InputToMove).prev();
            let RealPrevNumber = (PrevInput.length > 0 ? ($(PrevInput).val() * 1) : -1);

            $(CurrentElement).insertBefore($(PrevElement));

            if (ExpectPrevNumber === RealPrevNumber)
                $(InputToMove).insertBefore(PrevInput);
        }
    });

    //mode down
    $('#btnMoveTcxFieldDown').on('click', function () {
        let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
        let CurrentElement = $(this).parent().parent();
        let NextElement = $(this).parent().parent().next();

        if (NextElement.length > 0) {
            let ExpectNextNumber = $(NextElement).find('input').attr('enumnumber') * 1;
            let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
            let NextInput = $(InputToMove).next();
            let RealNextNumber = (NextInput.length > 0 ? ($(NextInput).val() * 1) : -1);

            $(CurrentElement).insertAfter($(NextElement));

            if (ExpectNextNumber === RealNextNumber)
                $(InputToMove).insertAfter(NextInput);
        }
    });
});