﻿$(document).ready(function () {
    var selectedJob = null;
    var loadID = null;
    var focused = true;

    var btnStatus = -1;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/TariscopeTasks/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/TariscopeTasks/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function UpdateJobsButtonsUI() {
        /*update ui for buttons when not selected any service some buttons disabled*/
        if (selectedJob === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }

        if (selectedJob !== null) {
            $("#btnRun_list").attr("disabled", btnStatus == 0);
            $("#btnStop_list").attr("disabled", btnStatus == 1);
        }
        else {
            $("#btnRun_list").attr("disabled", true);
            $("#btnStop_list").attr("disabled", true);
        }
    }

    function RowClick(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            selectedJob = null;
        }
        else {
            selectedJob = e.find('td[data-name="ID"]').text();
            btnStatus = e.find('td[data-name="buttons"]').text();
            $('#tableWithJobs tr.selected').removeClass('selected');
            e.addClass('selected');
            btnStatus = $($('#tableWithJobs tbody tr[id="' + selectedJob + '"]')[0]).find('td[data-name="buttons"]').text();
        }

        UpdateJobsButtonsUI();
    }

    function AttachEventsToTable() {
        //events for table
        $('#tableWithJobs tbody').on('click', 'tr', function () { RowClick($(this)); });
        $('#tableWithJobs tbody').on('dblclick', 'tr', function () {
            RowClick($(this));
            if (selectedJob != null)
                $('#btnEdit').click();
        });

        //events for check box run/stop task
        $('.CB_Table').change(function () {
            console.log();
            $.ajax({
                type: "POST",
                url: '/TariscopeTasks/SetActive/' + $(this).data('jobid'),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        clearTimeout(loadID);
                        UpdateTableWithJobs();
                    }
                }
            });
        });

        //set selected
        if (selectedJob !== null) {
            $($('#tableWithJobs tbody tr[id="' + selectedJob + '"]')[0]).addClass('selected');
            btnStatus = $($('#tableWithJobs tbody tr[id="' + selectedJob + '"]')[0]).find('td[data-name="buttons"]').text();
        }

        UpdateJobsButtonsUI();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/TariscopeTasks/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        clearTimeout(loadID);
                        UpdateTableWithJobs();
                    }
                }
            });
        });
    }

    function UpdateTableWithJobs() {
        if (focused) {
            $('#tasksTable').load('/TariscopeTasks/Search/?s=' + encodeURIComponent($('#tbSearch').val()), () => {
                AttachEventsToTable();
                loadID = setTimeout(UpdateTableWithJobs, 2000);
            });
        }
    }

    function AttachEventsForList() {
        var header = document.getElementById("tasksHEad");                 //for sticky head
        var sticky = header.offsetTop;       

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*attach events for select column*/
        $('#MenuSelectColumn input').on('click', function (event) {
            var visible = $(event.target).prop('checked');
            var colName = $(event.target).attr('data-value');

            $.ajax({
                type: "POST",
                url: '/TariscopeTasks/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        clearTimeout(loadID);
                        UpdateTableWithJobs();
                    }
                }
            });
        });

        //enable/disable panel with credentials
        $('#sqlAuthType').change(function () {
            if ($(this).val() === 0) {
                $('#sqlCredentialsPanel').addClass('disDiv');
            }
            else {
                $('#sqlCredentialsPanel').removeClass('disDiv');
            }
        });

        //disable save button if empty name for rename
        $('#renameJobName').on('input', function () {
            if ($(this).val() === null || $(this).val().match(/^ *$/) !== null) {
                $('#emptyRename').slideDown('fast');
                $('#modalButtonRename').attr('disabled', true);
            }
            else {
                $('#emptyRename').slideUp('fast');
                $('#modalButtonRename').attr('disabled', false);
            }
        });

        //confirm save new name
        $('#modalButtonRename').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/TariscopeTasks/RenameTask/?id=' + selectedJob + '&newName=' + $('#renameJobName').val(),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        $('#renameJobmodal').modal('hide');
                    }
                }
            });
        });

        //show modal for delete
        $('#btnDelete').on('click', function () {
            $('#confirmDelete').modal('show');
        });

        //deleting selected job
        $('#DeleteConfirm').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/TariscopeTasks/DeleteTask/' + selectedJob,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        selectedJob = null;
                        $('#confirmDelete').modal('hide');
                    }
                }
            });
        });

        //open page for add new task
        $('#btnAdd').on('click', function () {
            window.open('/Tasks/Add/', '_parent');
        });

        //open page for edit selected task
        $('#btnEdit').on('click', function () {
            window.open('/Tasks/Edit/' + selectedJob, '_parent');
        });

        /*attach events for export*/
        $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
        $('#ExportHTML').on('click', function () { Export("html"); });
        $('#ExportCSV').on('click', function () { Export("csv"); });
        $('#ExportPDF').on('click', function () { Export("pdf"); });

        //run selected task
        $('#btnRun_list').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/TariscopeTasks/RunTask/' + selectedJob,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        clearTimeout(loadID);
                        UpdateTableWithJobs();
                    }
                    ShowSpinner(false);
                }
            });
        });

        //show modal to confirm stop
        $('#btnStop_list').on('click', () => { $('#stopTaskModal').modal('show'); });

        //stop selected task
        $('#btnStop_listConfirm').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/TariscopeTasks/StopTask/' + selectedJob,
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        clearTimeout(loadID);
                        UpdateTableWithJobs();
                    }
                    ShowSpinner(false);
                }
            });
        });

        //got focus
        document.addEventListener('visibilitychange', function (ev) {
            let old = focused;
            focused = document.visibilityState == 'visible';

            if (!old && focused) {
                UpdateTableWithJobs();
            }
            else {
                clearTimeout(loadID);
            }
        });
    }

    AttachEventsForList();
    UpdateTableWithJobs();
});