﻿$(document).ready(() => {
    let user = null;

    function UpdateMainButtonsUI() {
        if (user == null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnResetPass").attr("disabled", true);
            $("#btnClaims").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnResetPass").attr("disabled", false);
            $("#btnClaims").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsMainTable() {
        var header = document.getElementById("servicesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*table events*/
        $('#tariscope-apiusers tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                user = null;
            }
            else {
                user = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-apiusers tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateMainButtonsUI();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Integrations/TariscopeApi/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        LoadTable();
                    }
                }
            });
        });

        UpdateMainButtonsUI();
    }

    function LoadTable() {
        user = null;

        $('#usersTable').load(encodeURI('/Integrations/TariscopeApi/Load/?s=' + encodeURIComponent($('#tbSearch').val())), AttachEventsMainTable);
    }

    function LoadDocumentation() {
        $('#DocumentationSection').load(encodeURI('/Integrations/TariscopeApi/Documentation'));
    }

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/TariscopeApi/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/TariscopeApi/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadTable();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //show error when empty username
    $('#EditUsername').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyName').slideDown('fast');
            $('#SaveUserBtn').prop('disabled', true);
        }
        else {
            $('#emptyName').slideUp('fast');
            $('#SaveUserBtn').prop('disabled', false);
        }
    });
    document.getElementById("EditUsername").onkeypress = function (e) {
        var chr = String.fromCharCode(e.which);
        if ('(),.-_><@@$/\[];:`~%^&*#"'.indexOf(chr) >= 0)
            return false;
    };

    //add a new user
    $('#btnAdd').on('click', () => {
        $('#editUserModalTitle').text($('#NewApiUserLbl').val());
        $('#EditUsername').val('');
        $('#emptyName').hide();
        $('#SaveUserBtn').prop('disabled', true);
        $('#EditDescription').val('');
        $('#PasswordSection').show();
        $('#CommonSection').show();
        $('#EditPassword').val('');
        $('#EditPasswordRepeat').val('');
        $('#passwordNotEquals').hide();

        $('#SaveUserBtn').unbind();
        $('#SaveUserBtn').on('click', () => {
            if ($('#EditPassword').val() == $('#EditPasswordRepeat').val()) {
                $('#editUserModal').modal('hide');
                ShowSpinner(true);

                $.ajax({
                    type: "POST",
                    async: true,
                    url: `/Integrations/TariscopeApi/Add/?Username=${encodeURIComponent($('#EditUsername').val())}&Description=${encodeURIComponent($('#EditDescription').val())}&Password=${encodeURIComponent($('#EditPassword').val())}`,
                    traditional: true,
                    success: function (response) {
                        ShowSpinner(false);
                        if (response != null && response.success == true) {
                            LoadTable();
                        }
                        else {
                            $('#ErrorDialogMsg').text(response.message);
                            $('#ErrorDialog').modal('show');
                        }
                    }
                });
            }
            else {
                $('#passwordNotEquals').slideDown('fast');
            }
        });

        $('#editUserModal').modal('show');
    });

    //delete selected
    $('#btnDelete').on('click', () => { $('#DeleteSelectedModal').modal('show'); });
    $('#ConfirmDeleteSelected').on('click', () => {
        $('#DeleteSelectedModal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: `/Integrations/TariscopeApi/Delete/${user}`,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                LoadTable();
            }
        });
    });

    //edit api user
    $('#btnEdit').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: `/Integrations/TariscopeApi/Get/${user}`,
            traditional: true,
            success: function (response) {
                $('#editUserModalTitle').text($('#EditApiUserLbl').val());
                $('#EditUsername').val(response.user.Username);
                $('#emptyName').hide();
                $('#SaveUserBtn').prop('disabled', false);
                $('#EditDescription').val(response.user.Description);
                $('#PasswordSection').hide();
                $('#CommonSection').show();
                $('#EditPassword').val('');
                $('#EditPasswordRepeat').val('');
                $('#passwordNotEquals').hide();

                $('#SaveUserBtn').unbind();
                $('#SaveUserBtn').on('click', () => {
                    $('#editUserModal').modal('hide');
                    ShowSpinner(true);

                    $.ajax({
                        type: "POST",
                        async: true,
                        url: `/Integrations/TariscopeApi/Update/${user}/?Username=${encodeURIComponent($('#EditUsername').val())}&Description=${encodeURIComponent($('#EditDescription').val())}`,
                        traditional: true,
                        success: function (response) {
                            ShowSpinner(false);
                            if (response != null && response.success == true) {
                                LoadTable();
                            }
                            else {
                                $('#ErrorDialogMsg').text(response.message);
                                $('#ErrorDialog').modal('show');
                            }
                        }
                    });
                });

                $('#editUserModal').modal('show');
            }
        });
    });

    //update the api user password
    $('#btnResetPass').on('click', () => {
        $('#editUserModalTitle').text($('#EditApiUserPasswordLbl').val());
        $('#EditUsername').val('');
        $('#emptyName').hide();
        $('#SaveUserBtn').prop('disabled', false);
        $('#EditDescription').val('');
        $('#PasswordSection').show();
        $('#CommonSection').hide();
        $('#EditPassword').val('');
        $('#EditPasswordRepeat').val('');
        $('#passwordNotEquals').hide();

        $('#SaveUserBtn').unbind();
        $('#SaveUserBtn').on('click', () => {
            if ($('#EditPassword').val() == $('#EditPasswordRepeat').val()) {
                $('#editUserModal').modal('hide');
                ShowSpinner(true);

                $.ajax({
                    type: "POST",
                    async: true,
                    url: `/Integrations/TariscopeApi/ResetPassword/${user}/?Password=${encodeURIComponent($('#EditPassword').val())}`,
                    traditional: true,
                    success: function (response) {
                        ShowSpinner(false);
                        if (!(response != null && response.success == true)) {
                            $('#ErrorDialogMsg').text(response.message);
                            $('#ErrorDialog').modal('show');
                        }
                    }
                });
            }
            else {
                $('#passwordNotEquals').slideDown('fast');
            }
        });

        $('#editUserModal').modal('show');
    });

    //go to edit claims
    $('#btnClaims').on('click', () => { window.open(`/Integrations/TariscopeApi/ClaimsSetup/${user}`, '_parent'); });

    //show more methods modal
    $('#MoreMethodsButton').on('click', () => {  $('#NewAPIModal').modal('show'); });

    LoadTable();
    LoadDocumentation();
});