﻿$(document).ready(() => {
    let selectedObs = null;
    let status = -1;
    let remote = -1;
    let updateInterval = 1500;
    var focused = true;

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Observers/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Observers/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    function ExpandLeftMenu() {
        try {
            if (ObserversIsLoaded) {
                ShowObservers('ObserverMenu', true);
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdateButtons() {
        //all buttons
        if (selectedObs === null) {
            $("#btnDelete").attr("disabled", true);
            $("#btnExportProfile").attr("disabled", true);
            $("#btnOpenLogfile").attr("disabled", true);

            $("#btnRun").addClass("disDiv");
            $("#btnStop").addClass("disDiv");
            $("#btnEdit").addClass("disDiv");
            $("#btnRename").addClass("disDiv");
            $("#btnScripts").addClass("disDiv");
        }
        else {
            $("#btnExportProfile").attr("disabled", false);
            $("#btnOpenLogfile").attr("disabled", false);

            //run/stop buttons
            switch (status) {
                case 1:
                    $("#btnRun").addClass("disDiv");
                    $("#btnStop").removeClass("disDiv");
                    break;
                case 2:
                case 3:
                    $("#btnRun").addClass("disDiv");
                    $("#btnStop").removeClass("disDiv");
                    break;
                default:
                    $("#btnRun").removeClass("disDiv");
                    $("#btnStop").addClass("disDiv");
                    break;
            }

            if (status == 4) {
                $("#btnEdit").removeClass("disDiv");
                $("#btnRename").removeClass("disDiv");
                $("#btnScripts").removeClass("disDiv");
                $("#btnDelete").attr("disabled", false);
            }
            else {
                $("#btnEdit").addClass("disDiv");
                $("#btnRename").addClass("disDiv");
                $("#btnScripts").addClass("disDiv");
                $("#btnDelete").attr("disabled", true);
            }

            if (remote) {
                $("#btnRun").addClass("disDiv");
            }
        }
    }

    function RowClick(e) {
        if (e.hasClass('selected')) {
            e.removeClass('selected');
            selectedObs = null;
            status = -1;
            remote = -1;
        }
        else {
            selectedObs = e.find('td[data-name="ProfileName"]').text();
            status = e.data('status') * 1;
            remote = e.data('remote') * 1;
            $('#tariscope-obss tr.selected').removeClass('selected');
            e.addClass('selected');
        }

        UpdateButtons();

    }

    function AttachEventsToTable() {
        if (selectedObs != null) {
            let row = $('tr > td[data-name="ProfileName"]:contains("' + selectedObs + '")').filter(function () {
                return $(this).text() === selectedObs;
            }).parent();

            if (row.length > 0) {
                $(row).addClass('selected');
                status = $(row).data('status') * 1;
            }
            else {
                selectedObs = null;
                status = -1;
            }
        }

        $('#tariscope-obss tbody').on('click', 'tr', function () { RowClick($(this)); });
        $('#tariscope-obss tbody').on('dblclick', 'tr', function () {
            RowClick($(this));
            if (selectedObs != null)
                $('#btnEdit').click();
        });

        UpdateButtons();

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Observers/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        Load();
                    }
                }
            });
        });
    }

    function Load() {
        if (focused) {
            $('#obssTable').load('/Observers/Load/?Search=' + encodeURIComponent($('#tbSearch').val()), AttachEventsToTable);
        }

        setTimeout(Load, updateInterval);
    }

    //edit observer
    $('#btnEdit').on('click', () => { window.location = '/Observers/Edit/' + encodeURIComponent(selectedObs); });

    //Open setup settings
    $('#btnSetup').on('click', () => { window.location = '/Observers/Setup/' + encodeURIComponent(selectedObs); });

    //show modal for add a new observer
    $('#btnAdd').on('click', () => {
        $('#newObserverName').val('');
        $('#emptyNewName').hide();
        $('#ServerSelectionSection').hide();
        $('#btnAddObserver').prop('disabled', true);
        $('#IsLocalOnserver').prop('checked', true);
        $('#addObservermodal').modal('show');
    });

    //show error when empty name for a new observer
    $('#newObserverName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyNewName').slideDown('fast');
            $('#btnAddObserver').prop('disabled', true);
        }
        else {
            $('#emptyNewName').slideUp('fast');
            $('#btnAddObserver').prop('disabled', false);
        }
    });
    document.getElementById("newObserverName").onkeypress = function (e) {
        var chr = String.fromCharCode(e.which);
        if ('(),.-_></\[];:`~%^&*#"'.indexOf(chr) >= 0)
            return false;
    };

    //confirm add a new observer
    $('#btnAddObserver').on('click', () => {
        $('#addObservermodal').modal('hide');

        $.ajax({
            type: "POST",
            url: '/Observers/Create/?Name=' + encodeURIComponent($('#newObserverName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    AddObserver(null, $('#newObserverName').val(), false);
                    $('#addObserverSuccess').modal('show');
                }
                else {
                    $('#addObserverFail').modal('show');
                }
            }
        });
    });

    //open settings for a new observer
    $('#openSettingsForNewObserver').on('click', () => { window.location = '/Observers/Edit/' + encodeURIComponent($('#newObserverName').val()); });

    //open observer scripts
    $('#btnScripts').on('click', () => { window.location = '/Observers/Scripts/' + encodeURIComponent(selectedObs); });

    //show modal for delete an observer
    $('#btnDelete').on('click', () => { $('#deleteObserver').modal('show'); });

    //confirm delete the observer
    $('#deleteObserverbtn').on('click', () => {
        $('#deleteObserver').modal('hide');
        $.ajax({
            type: "POST",
            url: '/Observers/Delete/?Name=' + encodeURIComponent(selectedObs),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    RemoveObserver(selectedObs);
                    selectedObs = null;
                }
                else {
                    $('#onlainFail').modal('show');
                }
            }
        });
    });

    //show modal for rename an observer
    $('#btnRename').on('click', () => {
        $('#renameObserverName').val(selectedObs);
        $('#emptyRenameName').hide();
        $('#btnRenameObserver').prop('disabled', false);
        $('#renameObservermodal').modal('show');
    });

    //show error when empty name for rename observer
    $('#renameObserverName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptyRenameName').slideDown('fast');
            $('#btnRenameObserver').prop('disabled', true);
        }
        else {
            $('#emptyRenameName').slideUp('fast');
            $('#btnRenameObserver').prop('disabled', false);
        }
    });
    document.getElementById("renameObserverName").onkeypress = function (e) {
        var chr = String.fromCharCode(e.which);
        if ('(),.-_></\[];:`~%^&*#"'.indexOf(chr) >= 0)
            return false;
    };

    //confirm rename the observer
    $('#btnRenameObserver').on('click', () => {
        $('#renameObservermodal').modal('hide');

        if (selectedObs === $('#renameObserverName').val())
            return;

        $.ajax({
            type: "POST",
            url: '/Observers/Rename/?OldName=' + encodeURIComponent(selectedObs) + '&NewName=' + encodeURIComponent($('#renameObserverName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    RenameObserver(selectedObs, $('#renameObserverName').val());
                    selectedObs = $('#renameObserverName').val();
                }
                else if (response.online) {
                    $('#onlainFail').modal('show');
                }
                else {
                    $('#addObserverFail').modal('show');
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //export observer profile
    $('#btnExportProfile').on('click', () => { window.open('/Observers/ExportProfile/' + encodeURIComponent(selectedObs), '_blank'); });

    //show modal for import observer profile
    $('#btnImportProfile').on('click', () => {
        $('#FileInputConfiguration').click();
    });

    //uploading file into server
    $("#FileInputConfiguration").change(function () {
        ShowSpinner(true);

        var formData = new FormData();
        Array.from(document.getElementById("FileInputConfiguration").files).forEach(e => {
            formData.append(e.name, e);
        });

        $.ajax({
            type: 'POST',
            async: true,
            url: '/Observers/ImportProfile/',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                if (response.success) {
                    AddObserver(null, response.ProfileName, false);
                }
            }
        });
    });

    //show message for run all observer
    $('#btnRunAll').on('click', () => { $('#runAllmodal').modal('show'); });

    //show modal for stop all observer
    $('#btnStopAll').on('click', () => { $('#stopAllmodal').modal('show'); });

    //run all configrm
    $('#runAllConfigrm').on('click', () => {
        $('#runAllmodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/Observers/RunAll',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);

                    $('#successLaunchMsg').text(response.msg);
                    $('#successLaunch').modal('show');
                }
            }
        });
    });

    //stop all configrm
    $('#stopAllConfigrm').on('click', () => {
        $('#stopAllmodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/Observers/StopAll',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);

                    $('#successLaunchMsg').text(response.msg);
                    $('#successLaunch').modal('show');
                }
            }
        });
    });

    /*attach event to checkboxes for select column for displaying*/
    $('#MenuSelectColumn input').on('click', function (event) {

        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        $.ajax({
            type: "POST",
            url: '/Observers/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
            traditional: true
        });
    });

    //run observer
    $('#btnRun').on('click', () => {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/Observers/Run/' + selectedObs,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    $('#successLaunchMsg').text(response.msg);
                    $('#successLaunch').modal('show');
                }
                else {
                    $('#errorLaunchMsg').text(response.msg);
                    $('#errorLaunch').modal('show');
                }
            }
        });
    });

    //stop observer
    $('#btnStop').on('click', () => {
        ShowSpinner(true);

        if (remote) {
            $.ajax({
                type: "POST",
                url: '/Observers/RequestStop/' + selectedObs,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);
                    $('#successLaunchMsg').text(response.msg);
                    $('#successLaunch').modal('show');
                }
            });
        }
        else {
            $.ajax({
                type: "POST",
                url: '/Observers/Stop/' + selectedObs,
                traditional: true,
                success: function (response) {
                    ShowSpinner(false);
                    if (response !== null && response.success === true) {
                        $('#successLaunchMsg').text(response.msg);
                        $('#successLaunch').modal('show');
                    }
                    else {
                        $('#errorLaunchMsg').text(response.msg);
                        $('#errorLaunch').modal('show');
                    }
                }
            });
        }
    });

    //got focus
    document.addEventListener('visibilitychange', function (ev) {
        focused = document.visibilityState == 'visible';
    });

    //open log file
    $('#btnOpenLogfile').on('click', () => {
        if (remote) {
            ShowSpinner(true);

            $.ajax({
                type: "POST",
                url: '/Observers/RequestLog/' + selectedObs,
                traditional: true,
                success: function (response) {
                    window.open(`/Logger/RemoteObserver/${selectedObs}`, '_parent');
                }
            });
        }
        else {
            window.open(`/Logger/Observer/${selectedObs}`, '_parent');
        }
    });

    //show help modal
    $('#btnRemoteInfo').on('click', () => {
        $('#remoteObserverHelp').modal('show');
    });

    Load();
    ExpandLeftMenu();
});