﻿$(document).ready(() => {
    function LoadSettings() {
        $.ajax({
            type: "POST",
            url: '/Netflow/LoadSettings/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#logLevel').val(response.LogLevel);
                    $('#Ports').val(response.Ports);
                    $('#LogPath').val(response.LogPath);
                    $('#LogSize').val(response.LogSize);
                    $('#newFile').val(response.newFile);
                    $('#compressingType').val(response.compressingType);
                    $('#agregationTime').val(response.agregationTime);
                    $('#AgrrFlow').prop('checked', response.AgrrFlow);
                    $('#AgrrPorts').prop('checked', response.AgrrPorts);
                    $('#AgrrProtocol').prop('checked', response.AgrrProtocol);
                    $('#UseTimeZone').prop('checked', response.UseTimeZone);
                    $('#dbWriteInterval').val(response.dbWriteInterval);
                    $('#OnlineTariff').prop('checked', response.OnlineTariff);
                }
            }
        });
    }

    function LoadDataOfSvc() {
        //update information about service
        $.ajax({
            type: "POST",
            url: '/Netflow/SvcInfo/',
            async: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    switch (response.ServiceStatus) {
                        case -1://not installed
                            $('#serviceRunned').hide();
                            $('#serviceNotRunned').hide();
                            $('#serviceNotInstalled').slideDown('fast');
                            $('#serviceUndefined').hide();
                            break;
                        case 1://stop
                            $('#serviceRunned').hide();
                            $('#serviceNotRunned').slideDown('fast');
                            $('#serviceNotInstalled').hide();
                            $('#serviceUndefined').hide();
                            break;
                        case 4://run
                            $('#serviceRunned').slideDown('fast');
                            $('#serviceNotRunned').hide();
                            $('#serviceNotInstalled').hide();
                            $('#serviceUndefined').hide();
                            break;
                        default:
                            $('#serviceRunned').hide();
                            $('#serviceNotRunned').hide();
                            $('#serviceNotInstalled').hide();
                            $('#serviceUndefined').slideDown('fast');
                            break;
                    }
                }
            }
        });
    }

    //run service
    $('#runSvc').on('click', () => {
        $('#runSvc').addClass('disDiv');
        $.ajax({
            type: "POST",
            url: '/Netflow/Run/',
            success: () => { setTimeout(LoadDataOfSvc, 3000); }
        });
    });

    //back to settings
    $('#BackTo').on('click', () => { window.open('/Netflow', '_parent'); });

    //save svc config
    $('#btnSave, #btnNeedSave').on('click', () => {

        var formData = new FormData();

        formData.append('logLevel', $('#logLevel').val());
        formData.append('Ports', $('#Ports').val());
        formData.append('LogPath', $('#LogPath').val());
        formData.append('LogSize', $('#LogSize').val());
        formData.append('newFile', $('#newFile').val());
        formData.append('compressingType', $('#compressingType').val());
        formData.append('agregationTime', $('#agregationTime').val());
        formData.append('dbWriteInterval', $('#dbWriteInterval').val());
        formData.append('AgrrFlow', $('#AgrrFlow').prop('checked'));
        formData.append('AgrrPorts', $('#AgrrPorts').prop('checked'));
        formData.append('AgrrProtocol', $('#AgrrProtocol').prop('checked'));
        formData.append('UseTimeZone', $('#UseTimeZone').prop('checked'));
        formData.append('OnlineTariff', $('#OnlineTariff').prop('checked'));

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/Netflow/SaveSettings/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#settingsSaved').slideDown('fast');
                    $('#settingsNotSaved').hide();
                    $('#needSaveAlert').hide();
                    setTimeout(() => { $('#settingsSaved').slideUp('fast'); }, 5000);
                }
                else {
                    $('#settingsSaved').hide();
                    $('#settingsNotSaved').slideDown('fast');
                }
            }
        });
    });

    //change auth type
    $('#sqlAuthType').change(() => {
        if ($('#sqlAuthType').val() * 1 === 0) {
            $('#sqlCredentialsPanel').addClass('disDiv');
        }
        else {
            $('#sqlCredentialsPanel').removeClass('disDiv');
        }
    });

    LoadSettings();
    LoadDataOfSvc();
});