﻿$(document).ready(() => {
    let selectedLinkTsID = null;
    let selectedLinkStID = null;

    function Init() {
        let dt = new Date();
        $('#PeriodYear').val(dt.getFullYear() + '');
        $('#PeriodMonth').val((dt.getMonth() + 1) + '');

        $('#TsService').select2({
            theme: "bootstrap",
            templateSelection: function (data) {
                var $result = $('<p style="margin-top: 5px;">' + data.text + '</p>');
                return $result;
            }
        });

        $('#StServices').select2({
            theme: "bootstrap",
            templateResult: function (data) {
                let r = data.text.split('~');
                var $result = $(
                    '<div class="row" style="width: 90%;">' +
                    '<div class="col-md-9">' + r[0] + '</div>' +
                    '<div class="col-md-3">' + r[1] + '</div>' +
                    '</div>'
                );
                return $result;
            },
            templateSelection: function (data) {
                var r = data.text.split('~');
                var $result = $('<p style="margin-top: 5px;">' + r[0] + '</p>');
                return $result;
            }
        });
    }

    function UpdateButtons() {
        if (selectedLinkTsID === null) {
            $("#RemoveBindging").addClass("disDiv");
        }
        else {
            $("#RemoveBindging").removeClass("disDiv");
        }
    }

    function AttachEventToLinksTable() {
        selectedLinkTsID = null;

        $('#tariscope-suretaxservices tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedLinkTsID = null;
                selectedLinkStID = null;
            }
            else {
                selectedLinkTsID = $(this).find('td[data-name="TariscopeServiceID"]').text();
                selectedLinkStID = $(this).find('td[data-name="SureTaxServiceID"]').text();
                $('#tariscope-suretaxservices tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        UpdateButtons();
    }

    function LoadRelatedServices() {
        $('#tableLinks').load('/Integrations/SureTax/GetRelated', AttachEventToLinksTable);
    }


    //save credentials
    $('#SaveSureTaxCredentials').on('click', () => {
        ShowSpinner(true);

        var formData = new FormData();
        formData.append('BusinessUnit', $('#BusinessUnit').val());
        formData.append('ClientNumber', $('#ClientNumber').val());
        formData.append('ValidationKey', $('#ValidationKey').val());
        formData.append('SureTaxLink', $('#SureTaxLink').val());

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/Integrations/SureTax/SaveCredentials/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                }
            }
        });
    });

    //show modal to remove binding
    $('#RemoveBindging').on('click', () => { $('#deleteBinding').modal('show'); });

    //delete binding
    $('#deleteBindingBtn').on('click', () => {
        $('#deleteBinding').modal('hide');
        ShowSpinner(true);

        var formData = new FormData();
        formData.append('TS', selectedLinkTsID);
        formData.append('ST', selectedLinkStID);

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/Integrations/SureTax/DeleteBinding/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadRelatedServices();
                }
            }
        });
    })

    //bind service
    $('#BindServicesBtn').on('click', () => {
        ShowSpinner(true);

        var formData = new FormData();
        formData.append('TS', $('#TsService').val());
        formData.append('ST', $('#StServices').val());

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/Integrations/SureTax/MakeBind/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(false);
                    LoadRelatedServices();
                }
            }
        });
    });

    //add a new suretax code
    $('#AddNewSureTaxCode').on('click', () => {
        if (!($('#NewSureTaxServiceName').val() || !$('#NewSureTaxServiceName').val().trim()) &&
            !($('#NewSureTaxServiceCode').val() || !$('#NewSureTaxServiceCode').val().trim()))
            return;

        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/Integrations/SureTax/AddCode/?Name=' + encodeURIComponent($('#NewSureTaxServiceName').val()) + '&Code=' + encodeURIComponent($('#NewSureTaxServiceCode').val()),
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#StServices').append('<option value="' + $('#NewSureTaxServiceCode').val() + '">' + $('#NewSureTaxServiceName').val() + '~' + $('#NewSureTaxServiceCode').val() + '</option>');
                    $('#NewSureTaxServiceName').val('');
                    $('#NewSureTaxServiceCode').val('');
                    ShowSpinner(false);
                }
            }
        });
    })

    //open dialog to select file
    $('#ImportSureTaxServicesBtn').on('click', () => { $('#FileInput').click(); });

    //upload suretax services
    $('#FileInput').on('change', () => {
        ShowSpinner(true);

        var data = new FormData();
        var file = ($("#FileInput"))[0].files[0];

        data.append($('#SelectFileFormat option:selected').val(), file);

        $.ajax({
            type: "POST",
            async: true,
            url: '/Integrations/SureTax/AddCode/UploadFile',
            data: data,
            datatype: 'json',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    ShowSpinner(false);
                    document.location.reload(true);
                }
                else
                    ShowSpinner(false);
            }
        });
    });

    //begin rating
    $('#SureTaxBeginRateBtn').on('click', () => {
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            url: '/Integrations/SureTax/Rate/' + $('#PeriodYear').val() + '/' + $('#PeriodMonth').val() + '/?Recharge=' + $('#RechargeTaxes').prop('checked'),
            success: function (response) {
                ShowSpinner(false);
                if (response.success === true) {
                    $('#rateSuccessMsg').text(response.message);
                    $('#rateSuccessModal').modal('show');
                }
                else {
                    $('#rateFailsMsg').text(response.message);
                    $('#rateFailModal').modal('show');
                }
                $('#outputs').val(response.outputs.join('\n'));
            }
        });
    });

    //fix right padding
    $('#deleteBinding, #rateSuccessModal, #rateFailModal').on('hidden.bs.modal', function () {
        $('body').removeClass('modal-open');
        $('.modal-backdrop').remove();
        setTimeout(function () { $('body').css('padding-right', 0); }, 1000);
    });

    Init();
    LoadRelatedServices();
});