﻿$('#deviceID').val($('#DeviceID').val());

$(document).ready(() => {
    function SendData() {
        ShowSpinner(true);

        var formData = new FormData();

        formData.append('AutoDNPlane', $('#AutoDNPlane').prop('checked'));
        formData.append('DeviceID', $('#DeviceID').val());

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/DeviceWizard/Step5_v/',
            success: function (response) {
                if (response !== null && response.success === true) { GoNext(); }
                else { ShowError(response.Errors); }
            }
        });
    }

    //setup current step
    $('#CurrentStep').val(5);

    //go to the next step
    $('#NextStep').on('click', SendData);

    //disable section
    $('#AutoDNPlane').change(() => {
        if ($('#AutoDNPlane').prop('checked')) {
            $('#DNSection').addClass('disDiv')
        }
        else {
            $('#DNSection').removeClass('disDiv')
        }
    });

    //show cancel modal
    $('#CancelWizard').on('click', () => { $('#CancelWizardmodal').modal('show'); });
});