﻿$(document).ready(() => {
    function InitCodesSelects() {
        //country codes
        $('#CountryCodes').select2({
            theme: "bootstrap",
            templateSelection: function (data) {
                var $result = $('<p style="margin-top: 5px;">' + data.text + '</p>');
                return $result;
            },
            tags: true
        });

        let cCode = $('#cCode').val();
        if ($('#CountryCodes').find("option[value='" + cCode + "']").length) {
            $('#CountryCodes').val(cCode).trigger('change');
        } else {
            $('#CountryCodes').append(new Option(cCode, cCode, true, true)).trigger('change');
        }
    }

    function SendData() {
        ShowSpinner(true);

        var formData = new FormData();

        formData.append('DeviceName', $('#DeviceName').val());
        formData.append('NodeID', $('#NodeID').val());
        formData.append('LongDistanceCode', $('#LongDistanceCode').val());
        formData.append('InternationalCode', $('#InternationalCode').val());
        formData.append('CountryCodes', $('#CountryCodes').val());
        formData.append('RegionCodes', $('#RegionCodes').val());

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/DeviceWizard/Step2_v/',
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#DeviceID').val(response.ID);
                    GoNext();
                }
                else { ShowError(response.Errors); }
            }
        });
    }

    //setup current step
    $('#CurrentStep').val(2);

    //go to the next step
    $('#NextStep').on('click', SendData);

    //show cancel modal
    $('#CancelWizard').on('click', () => { $('#CancelWizardmodal').modal('show'); });

    InitCodesSelects();
});