﻿$(document).ready(() => {
    function SetupMainCurrencySelect() {
        setTimeout(function () {
            $('#MainCurrency').val($('#MainCurrencyID').val());

            $('#MainCurrency').select2({
                theme: "bootstrap",
                placeholder: 'select main currency',
                templateResult: function (data) {
                    let r = data.text.split('|');
                    var $result = $(
                        '<div class="row" style="width: 90%;">' +
                        '<div class="col-md-8">' + r[0] + '</div>' +
                        '<div class="col-md-4">' + r[1] + '</div>' +
                        '</div>'
                    );
                    return $result;
                },
                templateSelection: function (data) {
                    var r = data.text.split('|');
                    var $result = $('<p style="margin-top: 5px;">' + r[0] + '</p>');
                    return $result;
                }
            });
        }, 250);
    }

    function SendData() {
        ShowSpinner(true);

        var formData = new FormData();

        formData.append('CompanyName', $('#CompanyName').val());
        formData.append('CountryCode', $('#CountryCode').val());
        formData.append('VATPrecent', $('#VATPrecent').val());
        formData.append('MainCurrency', $('#MainCurrency').val());
        formData.append('AutoGenerateAccountID', $('#AutoGenerateAccountID').prop('checked'));
        formData.append('EnableTariscopeJobs', $('#EnableTariscopeJobs').prop('checked'));
        formData.append('CreateDBBackups', $('#CreateDBBackups').prop('checked'));
        formData.append('EveryMonthClearDB', $('#EveryMonthClearDB').prop('checked'));
        formData.append('EveryMonthOptyDB', $('#EveryMonthOptyDB').prop('checked'));
        formData.append('UpdateCurrencyProfile', $('#UpdateCurrencyProfile').prop('checked'));
        formData.append('BackupPeriod', $('#BackupPeriod').val());
        formData.append('BackupPath', $('#BackupPath').val());
        formData.append('CurrencyProfile', $('#CurrencyProfile').val());

        $.ajax({
            type: "POST",
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            url: '/DeviceWizard/Step0_v/',
            success: function (response) {
                if (response !== null && response.success === true) { GoNext(); }
                else { ShowError(response.Errors); }
            }
        });
    }

    //setup current step
    $('#CurrentStep').val(0);

    //event to go to the next step
    $('#NextStep').on('click', SendData);

    //change on ts sheduler
    $('#EnableTariscopeJobs').change(() => {
        if ($('#EnableTariscopeJobs').prop('checked')) {
            $('#TSShedulerSection').slideDown('fast');
        }
        else {
            $('#TSShedulerSection').slideUp('fast');
        }
    });

    //disable sections if need
    $('#CreateDBBackups').change(() => {
        if ($('#CreateDBBackups').prop('checked')) {
            $('#BackupSection').removeClass('disDiv');
        }
        else {
            $('#BackupSection').addClass('disDiv');
        }
    });
    $('#UpdateCurrencyProfile').change(() => {
        if ($('#UpdateCurrencyProfile').prop('checked')) {
            $('#CurrencyProfile').removeClass('disDiv');
        }
        else {
            $('#CurrencyProfile').addClass('disDiv');
        }
    });

    //show cancel modal
    $('#CancelWizard').on('click', () => { $('#CancelWizardmodal').modal('show'); });

    SetupMainCurrencySelect();
});