﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.Data.SqlClient;
using SoftPi.Tariscope;
using SoftPi.Tariscope.DAL;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;

/// <summary>
/// Is used to inform a user that n% of limit is spended. 
/// </summary>
class CriticalPercentageLimitScript : IScript
{
    private int _chargePercentage = 70;
    private int _categoryId = 7;


    private IScriptHost _host;

    public void Init(IScriptHost host)
    {
        _host = host;
    }

    public void Main(object Parameters)
    {

        _host.AddEvent("Script critical-percentage-limit started");
        using (var cn = new SqlConnection(_host.DatabaseConnectionString))
        {
            cn.Open();
            var abonents = LoadAbonents();

            foreach (var abonent in abonents)
            {
                var abonentCredits = AbonentCredits.Instance(cn).Load(abonent.ID);
                foreach (var cr in abonentCredits)
                {
                    if (cr.CategoryID == _categoryId & (cr.Debit * 100) / cr.Credit > _chargePercentage)
                    {
                        var category = Categories.Instance(cn).Load().Where(x => x.ID == cr.ID).FirstOrDefault();
                        SendMail(abonent);
                    }
                }
            }
        }
        _host.AddEvent("Script critical-percentage-limit finished");

    }

    public void SendMail(Abonent abonent)
    {

        using (var cn = new SqlConnection(_host.DatabaseConnectionString))
        {
            cn.Open();
            var categoryName = Categories.Instance(cn).Load().Where(x => x.ID == _categoryId).FirstOrDefault().Name;

            var subject = string.Format("{0}% of limit is spended.", _chargePercentage);
            var message = string.Format("Abonent {0} - {1} reached limit of {2} percentage in {3} category", abonent.FullName, abonent.EMail, _chargePercentage, categoryName);

            _host.AddEvent(message);
            _host.SendMail(abonent.EMail, subject, message);
        }
    }

    public IEnumerable<Abonent> LoadAbonents()
    {
        using (var cn = new SqlConnection(_host.DatabaseConnectionString))
        {
            cn.Open();
            var abonentsComand = MSSQL.NewQuery(cn, "select * from ab_mc_abonents");
            var reader = abonentsComand.ExecuteReader();

            using (reader)
            {
                return MSSQL.GetList<Abonent>(reader);
            }
        }
    }
}

