﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using Microsoft.Data.SqlClient;
using SoftPi.Tariscope.DAL;

public class SetCosAvayaScript : IScript
{
    private IScriptHost Host;

    // Change this constants to set your specific parameters
    const string PBX_LOGIN = "login";
    const string PBX_PASSWORD = "password";

    const int KEYCODE_RETURN = 23;      // Ctrl-W

    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            SubscriberLimitingActionParameters ActionParameters = (SubscriberLimitingActionParameters)Parameters;

            this.Host.AddEvent(string.Format("Restrict subscriber:{0} Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
            this.Host.AddEvent(ActionParameters.ActionType.ToString());

            string CategoryName;
            List<DN> Dns;
            using (SqlConnection cn = new SqlConnection(this.Host.DatabaseConnectionString))
            {
                cn.Open();
                if (ActionParameters.Credit.CategoryID.HasValue)
                    CategoryName = new Categories(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
                else
                    CategoryName = "All categories";
                Dns = DNs.Instance(cn).Load(ActionParameters.Abonent.ID).Where(x => DateTime.Now > x.FromDateValue && DateTime.Now < x.ToDateValue).ToList();
            }


            Host.Send(Convert.ToChar(13).ToString());    // Посылка символа
            Host.WaitFor("Login:");
            Host.Send(PBX_LOGIN + Convert.ToChar(13).ToString());     // Посылка логина
            Host.WaitFor("Password:");                                  // Ожидание от Definity
            Host.Send(PBX_PASSWORD + Convert.ToChar(13).ToString());
            Host.Wait(200);
            Host.Send("ossis3" + Convert.ToChar(13).ToString());
            Host.WaitFor(Convert.ToChar(10).ToString() + "t" + Convert.ToChar(10).ToString());             // Ожидание от Definity
            foreach (DN CurrentDN in Dns)
            {
                Host.Send("cchange station " + CurrentDN.DN + Convert.ToChar(10).ToString() + "f8001ff00" + Convert.ToChar(10).ToString() + "d" + ActionParameters.CosValue + Convert.ToChar(10).ToString() + "t" + Convert.ToChar(10).ToString());
                Host.WaitFor(Convert.ToChar(10).ToString() + "t" + Convert.ToChar(10).ToString());
            }
            Host.SendData(new byte[] { 24 });
            Host.Wait(1000);
            ActionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            this.Host.AddEvent(ex.ToString());
        }
    }
}
