﻿using System;
using System.Net;
using System.Net.Sockets;
using Microsoft.Data.SqlClient;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;

public class GuardianConnector : IScript
{
    //////////////////////////
    ///     PARAMETERS     ///
    //////////////////////////

    public int CommunicationPort = 34523;

    //////////////////////////
    ///       SCRIPT       ///
    //////////////////////////

    IScriptHost Host;
    IPAddress Address;

    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
        Address = IPAddress.Parse("127.0.0.1");
        Host.AddEvent("Guardian connector script initialized");
    }

    public async void Main(Object parameters)
    {
        var callParams = parameters as NewCallActionParameters;

        try
        {
            using (var cn = new SqlConnection(Host.DatabaseConnectionString))
            {
                cn.Open();
                var cmd = SoftPi.Tariscope.MSSQL.NewQuery(cn, "SELECT ID FROM Calls WHERE ID=@callid AND CallDirection = 3");
                cmd.Parameters.AddWithValue("@callid", callParams.Id);

                using (var rs = cmd.ExecuteReader())
                    if (rs.HasRows && rs.Read())
                        try
                        {
                            using (TcpClient client = new TcpClient())
                            {
                                client.Connect(Address, CommunicationPort);
                                if (client.Connected)
                                {
                                    Host.AddEvent("Connected to the SoftPI Guardian successfully");
                                    var bytes = BitConverter.GetBytes(callParams.Id);
                                    using (var requestStream = client.GetStream())
                                    {
                                        await requestStream.WriteAsync(bytes, 0, bytes.Length);
                                        Host.AddEvent(string.Format("The call (id: {0}) transferred to the SoftPI Guardian", callParams.Id));
                                    }
                                }
                                else
                                {
                                    Host.AddEvent("Unable to connect to the SoftPI Guardian");
                                }
                            }
                        }
                        catch (Exception e1)
                        {
                            Host.AddEvent(string.Format("Guardian connector communication error: {0}", e1.Message));
                        }
            }
        }
        catch (Exception e2)
        {
            Host.AddEvent(string.Format("Guardian connector error: {0}", e2.Message));
        }
    }

    void OnClose(ref bool Cancel)
    {
        return;
    }
}
