﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using SoftPi.Tariscope.Common;
using System.Net;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPi.Tariscope.DAL;
using Microsoft.Data.SqlClient;

public class SetCos3cxScript : IScript
{
    private IScriptHost _host;

    // Change this constants to set your specific parameters
    const string PBX_PASSWORD = "admin_password";
    const string PBX_HOST = "your_pbx_address:5000"; // 10.10.0.5:5000

    const string URL_TEMPLATE = "http://{0}/ivr/PbxAPI.aspx?func=upd_ext&extnum={2}&pwd={1}&disable_external={3}";
    public void Init(IScriptHost host)
    {
        this._host = host;
        _host.Close += OnClose;
    }
    private void OnClose(ref bool Cancel)
    {
        return;
    }
    public void Main(object Parameters)
    {
        try
        {
            WebClient wc = new WebClient();
            SubscriberLimitingActionParameters ActionParameters = (SubscriberLimitingActionParameters)Parameters;

            _host.AddEvent(string.Format("Restrict subscriber:{0} Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, ActionParameters.Credit.CategoryID));
            _host.AddEvent(ActionParameters.ActionType.ToString());

            string CategoryName;
            List<DN> Dns;
            using (SqlConnection cn = new SqlConnection(_host.DatabaseConnectionString))
            {
                cn.Open();
                Dns = DNs.Instance(cn).Load(ActionParameters.Abonent.ID).Where(x => DateTime.Now > x.FromDateValue && DateTime.Now < x.ToDateValue).ToList();
                if (ActionParameters.Credit.CategoryID.HasValue)
                    CategoryName = new Categories(cn).Details(ActionParameters.Credit.CategoryID.Value).Name;
                else
                    CategoryName = "All categories";
            }
            int extensionState = 1;
            if (ActionParameters.ActionType == RestrictStatus.QueueUnrestrict)
                extensionState = 0;

            foreach (DN CurrentDN in Dns)
            {
                _host.AddEvent("DN" + CurrentDN.DN);
                string Url = string.Format(URL_TEMPLATE, PBX_HOST, PBX_PASSWORD, CurrentDN.DN, extensionState);
                _host.AddEvent(Url);
                var result = wc.DownloadString(Url);
                _host.AddEvent(result);
            }
            _host.Wait(1000);

            if (ActionParameters.ActionType == RestrictStatus.QueueRestrict)
            {
                var MessageText = string.Format("Restrict subscriber:{0}, Cos:{1}, Category: {2}, Limit: {3}, Charged: {4}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                _host.SendMail("", "Tariscope limiting notification", MessageText);

                _host.Wait(5000);

                var MessageText2 = string.Format("Dear {0}!     You limit exceeded for category: {1}. Limit: {2}, Charged: {3}", ActionParameters.Abonent.AbonentName, CategoryName, ActionParameters.Credit.Credit, ActionParameters.Credit.Debit);
                _host.SendMail(ActionParameters.Abonent.EMail, "Telephony limiting", MessageText2);
                _host.Wait(5000);
            }
            else if (ActionParameters.ActionType == RestrictStatus.QueueUnrestrict)
            {
                var MessageText = string.Format("Unrestrict subscriber:{0}, Cos:{1}, Category: {2}", ActionParameters.Abonent.AbonentName, ActionParameters.CosValue, CategoryName);
                _host.SendMail("", "Tariscope limiting notification (Unrestrict)", MessageText);

                _host.Wait(5000);
            }

            ActionParameters.Result = MediationActionResult.Success;
        }
        catch (Exception ex)
        {
            _host.AddEvent(ex.ToString());
        }
    }
}
