﻿window.SQLEditor = CodeMirror.fromTextArea(document.getElementById('CodeMirrorTextArea'), {
    mode: "text/x-mssql",
    indentWithTabs: true,
    smartIndent: true,
    lineNumbers: true,
    lineWrapping: true,
    theme: 'eclipse'
});

var show = setInterval(function () {
    window.SQLEditor.refresh();
}, 10);
setTimeout(function () {
    clearInterval(show);
}, 500);

function makeid(length) {
    var result = '';
    var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;
    for (var i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
}

function SetHeight() {
    windowHeight = window.innerHeight -
        $('.main-header').outerHeight() -
        $('.content-header').outerHeight() -
        $('.box-header').outerHeight() -
        $('.main-footer').outerHeight();

    if (windowHeight < 400)
        windowHeight = 400;

    $('.clusterize-scroll').css('max-height', windowHeight + 'px');
}

function AddTable(data) {
    let scrollId = 'scrollArea_' + makeid(8);
    let contentId = 'contentArea_' + makeid(8);
    let rowsId = 'totalLines_' + makeid(8);

    //create head row
    let headers = '<tr>';
    for (var i = 0; i < data[0].length; i++) {
        headers += '<th>';
        headers += data[0][i];
        headers += '</th>';
    }
    headers += '</tr>';

    let table = '<div class="clusterize" style="border-top: 2px solid #f4f4f4;">' +
        '<div id="' + scrollId + '" class="clusterize-scroll">' +
        '<table class="table tableSM table-bordered table-responsive table-tariscope">' +
        '<thead class="stickyHead">' + headers + '</thead>' +
        '<tbody id="' + contentId + '" class="clusterize-content"></tbody></table></div></div>' +
        '<h5>' + $('#TotalRows').val() + ' <kbd id="' + rowsId + '">...</kbd><hr/>';

    var rows = [];

    for (var u = 1; u < data.length; u++) {
        //create row
        let tr = '<tr>';
        for (var j = 0; j < data[u].length; j++) {
            //create cell
            tr += '<td>';
            tr += data[u][j];
            //add cell to row
            tr += '</td>';
        }
        //add row to table
        tr += '</tr>';
        rows.push(tr);
    }

    $('.tab1').append('<div class="form-group" style="height: 100%;">' + table + '</div>');

    //init clusterize
    var clusterize = new Clusterize({
        rows: rows,
        rows_in_block: 50,
        blocks_in_cluster: 4,
        scrollId: scrollId,
        contentId: contentId
    });

    SetHeight();
    $('#' + rowsId).text(clusterize.getRowsAmount());
}

function AddMessage(message) {
    $('.tab2').append('<p>' + message + '</p>');
}

function Clear(empty) {
    $('.answerBody').empty();
    $('#rezultPanel').slideUp('fast');

    if (empty)
        window.SQLEditor.setValue('');
}

function ShowTableAndMessage() {
    $('.nav-tabs').show();
    $('#resultLbl').hide();

    $('.ltab1').addClass('active');
    $('.tab1').addClass('active');

    $('.ltab2').removeClass('active');
    $('.tab2').removeClass('active');

    $('.ltab2').show();
    $('.ltab1').show();

    $('#rezultPanel').slideDown('fast');
}

function ShowTables() {
    $('#resultLbl').show();

    $('.ltab1').addClass('active');
    $('.tab1').addClass('active');

    $('.ltab2').removeClass('active');
    $('.tab2').removeClass('active');

    $('.ltab2').hide();
    $('.ltab1').hide();

    $('#rezultPanel').slideDown('fast');
}

function ShowMessages() {
    $('#resultLbl').show();

    $('.ltab2').addClass('active');
    $('.tab2').addClass('active');

    $('.ltab1').removeClass('active');
    $('.tab1').removeClass('active');

    $('.ltab2').hide();
    $('.ltab1').hide();

    $('#rezultPanel').slideDown('fast');
}

function ExecuteAnimation(id, show) {
    if (show) {
        $('#' + id).hide();
        $('#' + id + 'Animation').show();
        $('#sqlsteps').show(); 
    }
    else {
        $('#' + id).show();
        $('#' + id + 'Animation').hide();
        $('#sqlsteps').hide();
    }
}

$(document).ready(() => {
    //execute sql
    $('#btnRun').on('click', () => {
        ExecuteAnimation('btnRun', true);
        Clear(false);
        $('#sqlSection').addClass('disDiv');
        $('#btnClear').prop('disabled', true);
        $('#btnStop').prop('disabled', false);

        var formData = new FormData();
        formData.append('sql', window.SQLEditor.getValue());

        $.ajax({
            type: "POST",
            url: '/SQL/Run',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    var result = JSON.parse(response.result);

                    result.HTMLTables.forEach(x => {
                        AddTable(x);
                    });

                    result.Messages.forEach(x => {
                        AddMessage(x);
                    });

                    if (result.HTMLTables.length > 0 && result.Messages.length > 0) {
                        ShowTableAndMessage();
                    }
                    else if (result.HTMLTables.length > 0) {
                        ShowTables();
                    }
                    else {
                        ShowMessages();
                    }

                    if (result.HTMLTables.length === 0 && result.Messages.length === 0) {
                        AddMessage($('#CannotRun').val());
                    }

                    $('#sqlSection').removeClass('disDiv');
                    $('#btnClear').prop('disabled', false);
                    $('#btnStop').prop('disabled', true);

                    ExecuteAnimation('btnRun', false);
                }
            }
        });
    });

    $('#btnExport').on('click', () => {
        ExecuteAnimation('btnExport', true);
        var formData = new FormData();
        formData.append('sql', window.SQLEditor.getValue());

        let exportRequest = $.ajax({
            type: "POST",
            url: '/SQL/Export',
            data: formData,
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true,
            success: function (response) {

                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.path + "')");

                    window.open('/SQL/DownloadExport/?file=' + response.path, '_blank');

                    console.log("Download completed!");

                    if (!$('.clusterize').length)
                        $('#btnRun').click();
                }
                else {
                    Clear(false);
                    console.log("Export failed! Message: " + response.message);

                    for (let message of response.messages)
                        AddMessage(message);

                    ShowMessages();
                }

                ExecuteAnimation('btnExport', false);
                exportRequest = null;
            }
        });
    });

    //clear all
    $('#btnClear').on('click', () => { Clear(true); });

    //cancel
    $('#btnStop').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/SQL/Cancel',
            datatype: 'application/octet-stream',
            contentType: false,
            processData: false,
            traditional: true
        });
    });
});