﻿$(document).ready(() => {

    let loadPerChunk = 50;
    let loader = null;

    function createTD(dt, ht, hd, isTH = false) {
        //create cell
        var td = document.createElement(isTH ? 'th' : 'td');
        td.setAttribute('data-name', dt);
        td.innerText = ht;

        if (!hd)
            td.setAttribute('hidden', 'hidden');

        return td;
    }

    function GetDepartment(left, e, parent, hd) {
        //create department row
        var tr = document.createElement('tr');
        tr.setAttribute('data-d', 1);
        tr.setAttribute('data-id', e.ID);
        tr.setAttribute('data-isdepartment', 'true');
        tr.setAttribute('data-departmentid', e.ID);
        tr.setAttribute('data-departmentparentid', e.ParentID);
        tr.setAttribute('data-loaded', 'false');
        tr.setAttribute('data-opened', 'false');
        tr.setAttribute('data-parentID', parent);
        tr.setAttribute('data-items', '0');
        tr.setAttribute('data-departmentsloaded', 'false');

        var tdDesc = document.createElement('th');
        tdDesc.setAttribute('data-name', 'Description');
        tdDesc.className = 'Tree';

        var span1 = document.createElement('span');
        span1.setAttribute('data-id', e.ID);
        span1.className = 'expandButton';
        span1.innerHTML = '<i data-id="' + e.ID + '" class="fa fa-plus"></i>';
        span1.style.marginLeft = (left * 1 + 15) + 'px';


        //event for open next children
        $(span1).on('click', function () {
            ExpandChildren(e.ID);
        });

        var span2 = document.createElement('span');
        span2.className = 'descSpan';
        span2.innerHTML = e.Name;
        span2.style.marginLeft = '5px';

        //row description
        tdDesc.appendChild(span1);
        tdDesc.appendChild(span2);

        tr.appendChild(tdDesc);
        tr.appendChild(createTD('FirstDN', "", hd[1], false));
        tr.appendChild(createTD('AbonentPlaneID', "", hd[2], false));
        tr.appendChild(createTD('Description', "", hd[3], false));
        tr.appendChild(createTD('Information', "", hd[4], false));
        tr.appendChild(createTD('ConnectDate', "", hd[5], false));
        tr.appendChild(createTD('DisconnectDate', "", hd[6], false));
        tr.appendChild(createTD('AbonentType', "", hd[7], false));
        tr.appendChild(createTD('PersonalCode', "", hd[8], false));
        tr.appendChild(createTD('TaxCode', "", hd[9], false));
        tr.appendChild(createTD('Credit', "", hd[10], false));
        tr.appendChild(createTD('Debit', "", hd[11], false));
        tr.appendChild(createTD('Code', "", hd[12], false));
        tr.appendChild(createTD('ContractID', "", hd[13], false));
        tr.appendChild(createTD('ContractDate', "", hd[14], false));
        tr.appendChild(createTD('RestrictStatus', "", hd[15], false));
        tr.appendChild(createTD('GetAccountId', "", hd[16], false));
        tr.appendChild(createTD('ID', e.ID, hd[17], false));
        tr.appendChild(createTD('DepartmentName', "", hd[18], false));

        tr.style.display = 'none';

        return tr;
    }

    function GetIcon(id) {
        //get icon for animate
        return $('i[data-id="' + id + '"]');
    }

    function GetSapnIcon(id) {
        //get icon for animate
        return $('span[data-id="' + id + '"]');
    }

    function GetDate(dt) {
        let date = new Date(dt);
        let year = date.getFullYear();
        if (year === 1900 || year === 3000)
            return '';
        else return date.toLocaleDateString();

    }

    function GetAbonent(left, e, parent, hide = true, hd) {
        //create abonent row
        var tr = document.createElement('tr');
        tr.setAttribute('data-d', 0);
        tr.setAttribute('data-id', e.ID);
        tr.setAttribute('data-isdepartment', 'false');
        tr.setAttribute('data-departmentid', e.DepartmentID);
        tr.setAttribute('data-abonentid', e.ID);
        tr.setAttribute('data-parentID', parent);

        var span = document.createElement('span');
        span.innerHTML = e.FullName;
        span.style.marginLeft = (left * 1 + 28) + 'px';

        var td = createTD('Name', "", true);
        td.appendChild(span);

        tr.appendChild(td);
        tr.appendChild(createTD('FirstDN', e.FirstDN, hd[1]));
        tr.appendChild(createTD('AbonentPlaneID', $('#ListOfRatePlans').find(`option[value="${e.AbonentPlaneID}"]`).text(), hd[2]));
        tr.appendChild(createTD('Description', e.Description, hd[3]));
        tr.appendChild(createTD('Information', e.Information, hd[4]));
        tr.appendChild(createTD('ConnectDate', GetDate(e.ConnectDate), hd[5]));
        tr.appendChild(createTD('DisconnectDate', GetDate(e.DisconnectDate), hd[6]));

        let AbonentType;
        try {
            AbonentType = $('#LeftSideMenuAdditional_AbonentType_' + e.AbonentType).val();
        } catch (e) {
            AbonentType = e.AbonentType;
        }
        tr.appendChild(createTD('AbonentType', AbonentType, hd[7]));
        tr.appendChild(createTD('PersonalCode', e.PersonalCode, hd[8]));
        tr.appendChild(createTD('TaxCode', e.TaxCode, hd[9]));
        tr.appendChild(createTD('Credit', e.Credit.toFixed(2), hd[10]));
        tr.appendChild(createTD('Debit', e.Debit.toFixed(2), hd[11]));
        tr.appendChild(createTD('Code', e.Code, hd[12]));
        tr.appendChild(createTD('ContractID', e.ContractID, hd[13]));
        tr.appendChild(createTD('ContractDate', GetDate(e.ContractDate), hd[14]));
        tr.appendChild(createTD('RestrictStatus', e.RestrictStatus, hd[15]));
        tr.appendChild(createTD('GetAccountId', e.AccountId, hd[16]));
        tr.appendChild(createTD('ID', e.ID, hd[17]));
        tr.appendChild(createTD('DepartmentName', e.DepartmentName, hd[18]));

        if (hide === true)
            tr.style.display = 'none';

        return tr;
    }

    function LoadAbonents(parent, last) {
        if (loader !== null)
            loader.abort();

        let d = $('#tariscope-subs tr[data-id="' + parent + '"]');

        let loadedForBranch = d.attr('data-items') * 1;

        loader = $.ajax({
            type: "POST",
            async: 'async',
            url: '/Subscribers/GetAbonents/' + parent + '/?Skip=' + loadedForBranch + '&Load=' + loadPerChunk,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    let left = GetSapnIcon(parent).css('margin-left').replace('px', '');
                    let id = last;

                    response.abonents.forEach((abonent) => {
                        $('#tariscope-subs tr[data-id="' + id + '"]')[0].closest('tr').after(GetAbonent(left, abonent, parent, true, response.hd));
                        id = abonent.ID;
                        loadedForBranch++;
                    });

                    OpenChildren(parent);

                    d.attr('data-items', loadedForBranch);

                    if (response.abonents.length !== 0) {
                        LoadAbonents(parent, id);
                    }
                    else {
                        d.attr('data-loaded', 'true');
                    }
                }
            }
        });
    }

    function LoadChildren(e) {
        //load children of selected branch
        $.ajax({
            type: "POST",
            async: 'async',
            url: '/Subscribers/GetDepartments/' + e,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    let left = GetSapnIcon(e).css('margin-left').replace('px', '');
                    let id = e;

                    //add departments
                    let d = $('#tariscope-subs tr[data-id="' + e + '"]');
                    if (d.attr('data-departmentsloaded') === 'false')
                        response.departmetns.forEach((department) => {
                            $('#tariscope-subs tr[data-id="' + id + '"]')[0].closest('tr').after(GetDepartment(left, department, e, response.hd));
                            id = department.ID;
                        });
                    d.attr('data-departmentsloaded', 'true');

                    //load abonents
                    loadedForBranch = 0;
                    LoadAbonents(e, id);

                    OpenChildren(e);
                    GetIcon(e).css('transform', 'rotate(45deg)');
                }
            }
        });
    }

    function OpenChildren(id) {
        //open loaded or closed children
        var collection = $('#tariscope-subs tr[data-parentID="' + id + '"]');
        collection.each(function (index) {
            $(collection[index]).show();
        });
    }

    function CloseChildren(id) {
        if (loader !== null)
            loader.abort();

        //close openen children
        var collection = $('#tariscope-subs tr[data-parentID="' + id + '"]');
        collection.hide();

        var childdepartments = [];

        collection.each((index) => {

            if ($(collection[index]).data('opened') === true) {
                CloseChildren($(collection[index]).attr('data-id'));
            }

            if ($(collection[index]).data('isdepartment') === true) {
                childdepartments.push($(collection[index]));
            }

            //$(collection[index]).slideUp('fast');
        });

        //close opened subchildren
        childdepartments.map((e) => {
            CloseChildren(e.data('departmentid'));
        });

        GetIcon(id).css('transform', 'rotate(0)');
    }

    function ExpandChildren(id) {
        var ID = id + ''; //always must be string
        var parent = $('#tariscope-subs tr[data-departmentid="' + ID + '"]')[0];

        //load
        if ($(parent).attr('data-opened') === 'false' && $(parent).attr('data-loaded') === 'false') {
            LoadChildren(ID);

            $(parent).attr('data-opened', 'true');
        }
        //open children
        else if ($(parent).attr('data-opened') === 'false' && $(parent).attr('data-loaded') === 'true') {
            $(parent).attr('data-opened', 'true');

            OpenChildren(ID);
            GetIcon(ID).css('transform', 'rotate(45deg)');
        }
        //hide children
        else {
            $(parent).attr('data-opened', 'false');

            GetIcon(ID).css('transform', 'rotate(0)');
            CloseChildren(ID);
        }
    }

    //expand children
    $('.expandButton').click(function () { ExpandChildren($(this).data('id')); });

    //expand root department
    setTimeout(() => { ExpandChildren($('#firstDep').data('id')); }, 500);
});