﻿$(document).ready(() => {
    function LoadFreDNs() {
        ShowSpinner(true);
        $('#freeDNsTable').load('/Subscribers/LoadFreeDNsTable/?Search=' + encodeURIComponent($('#tbSearchFree').val()), () => { ShowSpinner(false); });
    }

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearchFree');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            LoadFreDNs();
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //back to abonent
    $('#btnBackToAbonentFromFreeDNs').on('click', () => {
        $('#additionalSection').slideUp('fast');
        $('#accountsSection').slideDown('fast');
    });

    LoadFreDNs();
});