﻿var selectedCode;
var add_edit_clone = 1;
var rowIndex = null;        //var for select via shift
var tempIndex = null;       //var for select via shift

function RemoveFromArray(array, element) {
    //remove element form array
    const index = array.indexOf(element);

    if (index !== -1) {
        array.splice(index, 1);
    }
}

function ExportP(t) {
    $('[data-toggle="dropdown"]').parent().removeClass('open');
    ShowSpinner(true);
    /*function for download file with exported data*/

    console.log("call Export('" + t + "')");

    $.ajax({
        type: "POST",
        async: true,
        cache: false,
        timeout: 600000,
        url: '/DestinationCodes/Export/?type=' + t + '&all=' + $('#exportall').is(':checked'),
        traditional: true,
        success: function (response) {
            if (response != null && response.success == true) {
                console.log("Export successfully!");
                console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                window.open('/DestinationCodes/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                console.log("Download completed!");

                $('#exportall').prop('checked', false);
            }
            else {
                console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
            }

            ShowSpinner(false);
        },
        error: function (xhr, ajaxOptions, thrownError) {
            alert(xhr.status);
            alert(thrownError);
        }
    });
};

function UpdateDestinationCodesButtonsUI() {

    /*update ui for buttons when not selected any code some buttons disabled*/

    //multi
    if (selectedCode.length > 1) {
        $("#btnAdd").attr("disabled", true);
        $("#btnCopy").attr("disabled", true);
        $("#btnRename").attr("disabled", true);

        $("#btnDelete").attr("disabled", false);
        $("#btnEdit").attr("disabled", false);
        $("#btnQInfo").attr("disabled", false);
    }

    //single
    if (selectedCode.length == 1) {
        $("#btnAdd").attr("disabled", false);
        $("#btnCopy").attr("disabled", false);
        $("#btnDelete").attr("disabled", false);
        $("#btnEdit").attr("disabled", false);
        $("#btnRename").attr("disabled", false);
        $("#btnQInfo").attr("disabled", false);
    }

    //nothing
    if (selectedCode.length == 0) {
        $("#btnCopy").attr("disabled", true);
        $("#btnRename").attr("disabled", true);
        $("#btnEdit").attr("disabled", true);
        $("#btnDelete").attr("disabled", true);
        $("#btnQInfo").attr("disabled", true);
        $("#btnAdd").attr("disabled", true);
    }
}

function AttachEventsToTableWithDestinationCodes() {
    /*table events*/
    $('#tableWithDestinationCodes tbody').on('click', 'tr', function (e) {

        if (e.shiftKey) {//select via shift
            var newIndex = $(this).index();

            var table = $('#tableWithDestinationCodes');

            //init first row
            if (rowIndex == null)
                rowIndex = $(this).index();

            tempIndex = rowIndex;

            //clear prev selected
            selectedCode = [];
            $('#tableWithDestinationCodes tr.selected').removeClass('selected');

            var direction = (newIndex >= rowIndex);

            if (direction) {//select down
                while (tempIndex <= newIndex) {
                    tempIndex += 1;

                    var tr = $('tr:eq(' + tempIndex + ')', table);

                    if (tr.css('display') != 'none') {
                        tr.addClass('selected');
                        RemoveFromArray(selectedCode, tr.find('td[data-name="ID"]').text());
                        selectedCode.push(tr.find('td[data-name="ID"]').text());
                    }
                }
            }
            else {//select up
                while (tempIndex > (newIndex - 1)) {
                    var tr = $('tr:eq(' + (tempIndex + 1) + ')', table);

                    if (tr.css('display') != 'none') {
                        tr.addClass('selected');
                        RemoveFromArray(selectedCode, tr.find('td[data-name="ID"]').text());
                        selectedCode.push(tr.find('td[data-name="ID"]').text());
                    }

                    tempIndex -= 1;
                }
            }
        }
        else {//else single or multi select
            rowIndex = $(this).index();

            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                if ($('#multiselect').is(':checked'))
                    RemoveFromArray(selectedCode, $(this).find('td[data-name="ID"]').text());
                else {
                    selectedCode = [];
                    $('#tableWithDestinationCodes tr.selected').removeClass('selected');
                }
            }
            else {
                if (!$('#multiselect').is(':checked')) {
                    selectedCode = [];
                    $('#tableWithDestinationCodes tr.selected').removeClass('selected');
                }
                selectedCode.push($(this).find('td[data-name="ID"]').text());
                $(this).addClass('selected');
            }
        }
        UpdateDestinationCodesButtonsUI();
    });

    //hide spinner
    ShowSpinner(false);
}

function UpdateTableWithDestinationCodes(e) {
    //load table by search string
    $('#codesTable').load('/DestinationCodes/SearchDestinationcodes/?s=' + encodeURIComponent(e), AttachEventsToTableWithDestinationCodes);
}

function AttachEventsForDestinationCodes() {
    //back to providers
    $('#BackTo').on('click', LoadPreview);
    $('#ABackTo').on('click', LoadPreview);


    /*atach input event to search textbox*/
    //$('#tbSearch').on('input', function (e) { UpdateTableWithDestinationCodes($('#tbSearch').val()); });

    //setup before functions
    var typingTimer;                //timer identifier
    var doneTypingInterval = 750;  //time in ms, 0.75 second for example
    var $input = $('#tbSearch');

    //on keyup, start the countdown
    $input.on('keyup', function () {
        clearTimeout(typingTimer);
        typingTimer = setTimeout(function () {
            UpdateTableWithDestinationCodes($('#tbSearch').val());
        }, doneTypingInterval);
    });
    //on keydown, clear the countdown 
    $input.on('keydown', function () { clearTimeout(typingTimer); });

    //load table and hide spinner
    UpdateTableWithDestinationCodes($('#tbSearch').val());

    //events to expand and collaps buttons
    $('#btnExpand').on('click', function () { ExpandAll(true); });
    $('#btnCollaps').on('click', function () { ExpandAll(false); });

    /*attach events for select column*/
    $('#MenuSelectColumn input').on('click', function (event) {
        var visible = $(event.target).prop('checked');
        var colName = $(event.target).attr('data-value');

        $.ajax({
            type: "POST",
            url: '/DestinationCodes/SetTableColumnVisability?colName=' + colName + "&visible=" + visible,
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    //show or hide columns without reload
                    //couse codesmay be a lot
                    for (let i = 0; i < 11; i++) {

                        header = $('#col_' + i),
                            table = header.closest("table"),
                            selector = "tbody tr td:nth-child(" + (i + 1) + ")",
                            column = table.find(selector).add(header);

                        column.attr('hidden', !response.cols[i]);

                        //for sticky head of table
                        $('#col_0' + i).attr('hidden', !response.cols[i]);
                        NeedSetSize = true;
                    }
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { ExportP("xlsx"); });
    $('#ExportHTML').on('click', function () { ExportP("html"); });
    $('#ExportCSV').on('click', function () { ExportP("csv"); });
    $('#ExportPDF').on('click', function () { ExportP("pdf"); });

    //get destination description and show modal
    $('#btn-tools').on('click', 'button[data-name="Rename"]', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/GetDestinationDescription/' + selectedCode[0],
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#emptyRename').attr('hidden', true);
                    $('#modalButtonSaveDesc').attr('disabled', false);
                    $('#changeDescDesCod').val(response.Description);
                    $('#changeDescDesCodModal').modal('show');
                }
            }
        });
    });

    /*attach event to text box with name*/
    /*show alert message when name is empty*/
    $('#changeDescDesCod').on('input', function (e) {
        if ($('#changeDescDesCod').val() == "") {
            $('#emptyRename').slideDown('fast');
            $('#modalButtonSaveDesc').attr('disabled', true);
        }
        else {
            $('#emptyRename').slideUp('fast');
            $('#modalButtonSaveDesc').attr('disabled', false);
        }
    });

    //change description
    $('#modalButtonSaveDesc').on('click', function () {
        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/ChangeDescription/?id=' + selectedCode[0] + '&newDesc=' + encodeURIComponent($('#changeDescDesCod').val()),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    var tableRow = $("td").filter(function () { return $(this).text() == response.id; }).closest("tr");
                    $(tableRow[0].children[0]).html(tableRow[0].children[0].innerHTML.replace(response.oldDesc, response.newDesc));

                    $('#changeDescDesCodModal').modal('hide');
                }
            }
        });
    });

    //show modal for delete selected codes
    $('#btn-tools').on('click', 'button[data-name="Delete"]', function () {
        $('#cannotDelete').attr('hidden', true);
        $('#confirmDelete').modal('show');
        $('#DeleteConfirm').attr('disabled', false);
        $('#DeleteConfirmCancel').attr('disabled', false);
    });

    //delete selected codes
    $('#confirmDelete').on('click', function () {
        $('#DeleteConfirm').attr('disabled', true);
        $('#DeleteConfirmCancel').attr('disabled', true);

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/DeleteDestionationCodes/?ids=' + selectedCode.toString(),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    selectedCode.toString().split(',').forEach(function (e) { selectedCode.toString().split(',').forEach(function (e) { window.DeleteBranch(e); }); });

                    selectedCode = [];
                    UpdateDestinationCodesButtonsUI();
                    $('#confirmDelete').modal('hide');
                }
                else {
                    $('#DeleteConfirm').attr('disabled', true);
                    $('#DeleteConfirmCancel').attr('disabled', false);
                    $('#cannotDelete').attr('hidden', false);
                }
            }
        });
    })

    //attach events to buttons for clear data (fromdate, todate)
    $('#btnClearToDate').on('click', function () { try { $('#datetimepickerTo').data("DateTimePicker").setDate(null) } catch (e) { } });
    $('#btnClearFromDate').on('click', function () { try { $('#datetimepickerFrom').data("DateTimePicker").setDate(null) } catch (e) { } });

    //show modal for add new code
    $('#btn-tools').on('click', 'button[data-name="Add"]', function () {

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/GetDestinationDescription/' + selectedCode[0],
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#adcID').val('0');
                    $('#adcParentID').val(selectedCode[0]);
                    $('#adcOwner').val(response.Description);
                    $('#adcDescription').val('');
                    $('#adcCode').val('');

                    $("#adcRate").val($("#adcRate option:first").val());
                    $("#adcCategory").val($("#adcCategory option:first").val());
                    $("#adcCallType").val($("#adcCallType option:first").val());

                    $('#adcLat').val('0');
                    $('#adcLg').val('0');

                    try { $('#datetimepickerFrom').data("DateTimePicker").setDate(null) } catch (e) { }
                    try { $('#datetimepickerTo').data("DateTimePicker").setDate(null) } catch (e) { }

                    $('#addTitle').attr('hidden', false);
                    $('#editTitle').attr('hidden', true);
                    $('#copyTitle').attr('hidden', true);

                    $('#emptyRename2').slideUp('fast');
                    $('#btnSave').attr('disabled', true);

                    add_edit_clone = 1;

                    $('#adcModal').modal('show');
                }
            }
        });


    });

    /*attach event to text box with description*/
    /*show alert message when description is empty*/
    $('#adcDescription').on('input', function (e) {
        if ($('#adcDescription').val() == "") {
            $('#emptyRename2').slideDown('fast');
            $('#btnSave').attr('disabled', true);
        }
        else {
            $('#emptyRename2').slideUp('fast');
            $('#btnSave').attr('disabled', false);
        }
    });

    //comfirm add/edit/copy
    $('#btnSave').on('click', function () {
        var data = {
            'ID': $('#adcID').val(),
            'ParentID': $('#adcParentID').val(),
            'Description': $('#adcDescription').val(),
            'Code': $('#adcCode').val(),
            'Latitude': $('#adcLat').val(),
            'Longitude': $('#adcLg').val(),
            'FromDateStr': $('#datetimepickerFrom').data('date'),
            'ToDateStr': $('#datetimepickerTo').data('date'),
            'RateID': $('#adcRate option:selected').val(),
            'CategoryID': $('#adcCategory option:selected').val(),
            'CallType': $('#adcCallType option:selected').val(),
            'add_edit_clone': add_edit_clone
        };

        $.ajax({
            type: "POST",
            async: true,
            data: data,
            datatype: 'json',
            url: '/DestinationCodes/EditDestionationCode/',
            traditional: true,
            success: function (response) {
                $('#adcModal').modal('hide');
                if (response != null && response.success == true) {

                    if (!$('#tableWithDestinationCodes').hasClass('NotTree')) {
                        //logic for tree-table
                        window.ExpandID = response.Parents;
                        window.SelectCallback = function () {
                            $($('#tableWithDestinationCodes tbody tr[data-id="' + response.newElement.ID + '"]')[0]).addClass('selected');
                            selectedCode = [];
                            selectedCode.push(response.newElement.ID.toString());
                            UpdateDestinationCodesButtonsUI();
                        };

                        $('body').css('padding-right', 0);
                        window.LoadDestinationCodes('Provider_' + response.ProviderID, response.IsOutgoing, response.IsTreeNow);
                    }
                    else {
                        //for table view
                        window.DeleteBranch(response.newElement.ID, true);
                        window.AddRow(response.newElement, response.hd);
                        $('#tableWithDestinationCodes tr.selected').removeClass('selected');
                        $($('#tableWithDestinationCodes tbody tr[data-id="' + response.newElement.ID + '"]')[0]).addClass('selected');
                        selectedCode = [];
                        selectedCode.push(response.newElement.ID.toString());
                        UpdateDestinationCodesButtonsUI();
                    }
                }
                else {
                    $('body').css('padding-right', 0);
                    $('#pMessage').text(response.msg);
                    console.log(response);
                    $('#messageModal').modal('show');
                }
            }
        });
    });

    //button for browse entered geo location
    $('#btnGoToMaps').on('click', function () {
        window.open('https://maps.google.com/maps?q=' + $('#adcLat').val().replace(',', '.') + ',' + $('#adcLg').val().replace(',', '.') + '+' + $('#adcDescription').val(), '_blank');
    });

    //show modal for copy from code
    $('#btn-tools').on('click', 'button[data-name="Copy"]', function () {

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/GetDestinationForCopy/' + selectedCode[0],
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true && response.Description != null) {

                    $('#adcID').val('0');
                    $('#adcParentID').val(response.Copy.ParentID);
                    $('#adcOwner').val(response.Description);

                    $('#adcDescription').val(response.Copy.Description);
                    $('#lblCopy').html(response.Copy.Description);

                    $('#adcCode').val(response.Copy.Code);

                    $("#adcRate").val($("#adcRate option[value=" + response.Copy.RateID + "]").val());
                    $("#adcCategory").val($("#adcCategory option[value=" + response.Copy.CategoryID + "]").val());
                    $("#adcCallType").val($("#adcCallType option[value=" + response.Copy.CallType + "]").val());

                    $('#adcLat').val(response.Copy.Latitude);
                    $('#adcLg').val(response.Copy.Longitude);

                    var from = new Date(response.Copy.FromDate);
                    if (from.getFullYear() == 1900)
                        from = null;

                    var to = new Date(response.Copy.ToDate);
                    if (to.getFullYear() == 3000)
                        to = null;

                    try { $('#datetimepickerFrom').data("DateTimePicker").setDate(from) } catch (e) { }
                    try { $('#datetimepickerTo').data("DateTimePicker").setDate(to) } catch (e) { }

                    $('#addTitle').attr('hidden', true);
                    $('#editTitle').attr('hidden', true);
                    $('#copyTitle').attr('hidden', false);

                    $('#emptyRename2').slideUp('fast');
                    $('#btnSave').attr('disabled', false);

                    add_edit_clone = 3;

                    $('#adcModal').modal('show');
                }
                else {
                    $('#pMessage').text(response.msg);
                    $('#messageModal').modal('show');
                }
            }
        });


    });

    //save state of multiselect option to cockie
    $('#switchMultiselect').on('click', function () {

        var state = !$('#multiselect').is(':checked') ? 'checked' : 'e';

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/SaveMultiselectState/?state=' + state,
            traditional: true
        });
    });

    //show modal for copy from code
    $('#btn-tools').on('click', 'button[data-name="Edit"]', function () {

        if (selectedCode.length > 1) {//multi edit
            $('#multiDescription').val('');
            $('#multiTextBr').val('');
            $('#multiFirstSymbols').val('0');
            $('#multiSymbolsChnage').val('');
            $('#multiRate').val($("#multiRate option:first").val());
            $('#multiCategory').val($("#multiCategory option:first").val());
            $('#multiCallType').val($("#multiCallType option:first").val());

            $('#multiEditModal').modal('show');
        }
        else {//single edit
            $.ajax({
                type: "POST",
                async: true,
                url: '/DestinationCodes/GetDestinationForCopy/' + selectedCode[0],
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {

                        $('#adcID').val(response.Copy.ID);
                        $('#adcParentID').val(response.Copy.ParentID);
                        $('#adcOwner').val(response.Description);

                        $('#adcDescription').val(response.Copy.Description);
                        $('#lblEdit').html(response.Copy.Description);

                        $('#adcCode').val(response.Copy.Code);

                        $("#adcRate").val($("#adcRate option[value=" + response.Copy.RateID + "]").val());
                        $("#adcCategory").val($("#adcCategory option[value=" + response.Copy.CategoryID + "]").val());
                        $("#adcCallType").val($("#adcCallType option[value=" + response.Copy.CallType + "]").val());

                        $('#adcLat').val(response.Copy.Latitude);
                        $('#adcLg').val(response.Copy.Longitude);

                        var from = new Date(response.Copy.FromDate);
                        if (from.getFullYear() == 1900)
                            from = null;

                        var to = new Date(response.Copy.ToDate);
                        if (to.getFullYear() == 3000)
                            to = null;

                        try { $('#datetimepickerFrom').data("DateTimePicker").setDate(from) } catch (e) { }
                        try { $('#datetimepickerTo').data("DateTimePicker").setDate(to) } catch (e) { }

                        $('#addTitle').attr('hidden', true);
                        $('#editTitle').attr('hidden', false);
                        $('#copyTitle').attr('hidden', true);

                        $('#emptyRename2').slideUp('fast');
                        $('#btnSave').attr('disabled', false);

                        add_edit_clone = 2;

                        $('#adcModal').modal('show');
                    }

                }
            });
        }
    });

    //confirm multisave
    $('#btnMultiSave').on('click', function () {
        var data = {
            'IDs': selectedCode.toString(),
            'Description': $('#multiDescription').val(),
            'Brackets': $('#multiTextBr').val(),
            'First': $('#multiFirstSymbols').val(),
            'Symbols': $('#multiSymbolsChnage').val(),
            'RateID': $('#multiRate option:selected').val(),
            'CategoryID': $('#multiCategory option:selected').val(),
            'CallType': $('#multiCallType option:selected').val()
        };

        $.ajax({
            type: "POST",
            async: true,
            data: data,
            datatype: 'json',
            url: '/DestinationCodes/EditMultiDestinationCodes/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    if (!$('#tableWithDestinationCodes').hasClass('NotTree')) {
                        //logic for tree-table
                        window.ExpandID = response.Parents;
                        window.SelectCallback = function () {
                            selectedCode = [];
                            response.IDs.forEach(function (e) {
                                selectedCode.push(e.toString());
                                $($('#tableWithDestinationCodes tbody tr[data-id="' + e + '"]')[0]).addClass('selected');
                            })
                            UpdateDestinationCodesButtonsUI();
                        };

                        $('body').css('padding-right', 0);
                        LoadDestinationCodes('Provider_' + response.ProviderID, response.IsOutgoing, response.IsTreeNow);
                    }
                    else {
                        //for table view
                        $('#tableWithDestinationCodes tr.selected').removeClass('selected');
                        selectedCode = [];
                        response.list.forEach(function (e) {
                            selectedCode.push(e.ID.toString());
                            window.DeleteBranch(e.ID, true);
                            window.AddRow(e, response.hd);
                            $($('#tableWithDestinationCodes tbody tr[data-id="' + e.ID + '"]')[0]).addClass('selected');
                        })
                        UpdateDestinationCodesButtonsUI();
                    }

                    $('#multiEditModal').modal('hide');
                }
            }
        });
    });

    //show modal for copy from code
    $('#btn-tools').on('click', 'button[data-name="SCoord"]', function () {

        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/GetStartCoord/',
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#scLat').val(response.Latitude);
                    $('#scLong').val(response.Longitude);
                    $('#startcoordModal').modal('show');
                }
            }
        });
    });

    //save entered start coord
    $('#saveStartCoord').on('click', function () {
        $('body').css('padding-right', 0);
        $('#startcoordModal').modal('hide');
        ShowSpinner(true);
        $.ajax({
            type: "POST",
            async: true,
            url: '/DestinationCodes/SetStartCoord/?lat=' + $('#scLat').val() + '&lon=' + $('#scLong').val() + '&update=' + $('#UpdateStart').is(':checked'),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {

                    if ($('#UpdateStart').is(':checked')) {
                        var rows = $('#tableWithDestinationCodes tbody').children('tr');
                        for (var i = 0; i < response.diss.length; i++) {
                            $(rows[i]).find('td[data-name="Distance"]').html(response.diss[i]);
                        }
                    }
                    $('body').css('padding-right', 0);
                    ShowSpinner(false);
                }
            }
        });
    });

    //open page for import destination codes
    $('#btn-tools').on('click', 'button[data-name="Import"]', function () {

        //load partial for copy selected rate
        if (selectedCode == null || selectedCode.length == 0) {
            $('#selectRootModal').modal('show');
        }
        else {
            ShowSpinner(true);

            $.ajax({
                type: "POST",
                async: true,
                url: '/DestinationCodes/GetProviderInfo',
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        $('#ProvidersContent').load('/DestinationCodesImport/GetDestinationCodesImportPreview/?ProviderID=' + response.ProviderID +
                            '&Outgoing=' + response.IsOutgoing +
                            '&RoodCodeID=' + selectedCode[0], function () {
                                ShowSpinner(false);
                            });
                    }
                }
            });
        }
    });

    //disable close dropdown when with selecting visavility of column
    $('.dropdown-menu').click(function (e) {
        e.stopPropagation();
    });

    initDateTimePicker();
}

function initDateTimePicker() {
    var options = {
        todayHighlight: true,
        autoclose: true,
        daysOfWeekDisabled: "0",
        daysOfWeekHighlighted: "0",
        language: navigator.language,
        locale: navigator.language,
        useCurrent: false,
        showClear: true,
        showClose: true,
        allowInputToggle: true
    };

    $('#datetimepickerFrom').datetimepicker(options);
    $('#datetimepickerTo').datetimepicker(options);
};

$(document).ready(function () {
    selectedCode = [];
    AttachEventsForDestinationCodes();
});