﻿$(document).ready(() => {
    function UpdateSQLLoginSection() {
        if ($('#sqlAuthTypePlus').val() * 1 === 0) {
            $('#sqlCredentialsPanelPlus').addClass('disDiv');
        }
        else {
            $('#sqlCredentialsPanelPlus').removeClass('disDiv');
        }
    }

    //expand panel for edit my sql connection
    $('#editMsLyncSQLConnection').on('click', () => {
        $('#editMsLyncSQLConnection').addClass('disDiv');

        $.ajax({
            type: "POST",
            url: '/Observers/ParseConnectionStringPlus/?CN=' + encodeURIComponent($('#ConnectionString').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    $('#sqlServerNamePlus').val(response.server);
                    $('#sqlDBNamePlus').val(response.db);
                    $('#sqlLoginPlus').val(response.user);
                    $('#sqlPassPlus').val(response.pass);

                    $('#sqlAuthTypePlus').val(response.auth);
                    UpdateSQLLoginSection();

                    $('#editMsLyncSQLConnection').fadeTo('fast', 0, () => { $('#editMsLyncSQLConnection').removeClass('disDiv'); });
                    $('#MsLyncSqlConnectionSection').slideDown('fast');
                }
            }
        });
    });

    //cancel edit my sql connection
    $('#cancelEditMsLyncSql').on('click', () => {
        $('#MsLyncSqlConnectionSection').slideUp('fast');
        $('#editMsLyncSQLConnection').fadeTo('fast', 1);
    });

    //changed sql conn type
    $('#sqlAuthTypePlus').change(UpdateSQLLoginSection);

    //save ms lync sql connection
    $('#saveEditMsLyncSql').on('click', () => {
        $('#MsLyncSqlConnectionSection').addClass('disDiv');
        $('#MsLyncConnectionWait').slideDown('fast');

        $.ajax({
            type: "POST",
            url: '/Observers/BuildConnectionStringPlus/?CN=' + encodeURIComponent($('#ConnectionString').val())
                + '&DataSource=' + encodeURIComponent($('#sqlServerNamePlus').val())
                + '&InitialCatalog=' + encodeURIComponent($('#sqlDBNamePlus').val())
                + '&IntegratedSecurity=' + ($('#sqlAuthTypePlus').val() * 1 === 1)
                + '&UserID=' + encodeURIComponent($('#sqlLoginPlus').val())
                + '&Password=' + encodeURIComponent($('#sqlPassPlus').val()),
            traditional: true,
            success: function (response) {
                $('#MsLyncConnectionWait').slideUp('fast');

                if (response != null) {
                    if (response.success == true) {
                        $('#ConnectionString').val(response.cn);

                        $('#MsLyncSqlConnectionSection').slideUp('fast');

                        $('#MsLyncConnectionSuccess').slideDown('fast');
                        setTimeout(() => {
                            $('#MsLyncConnectionSuccess').slideUp('fast');
                            $('#editMsLyncSQLConnection').fadeTo('fast', 1);
                        }, 2500);
                    }
                    else {
                        $('#MsLyncConnectionFail').text(response.msg);

                        $('#MsLyncSqlConnectionSection').slideUp('fast');
                        $('#MsLyncConnectionFail').slideDown('fast');

                        setTimeout(() => {
                            $('#MsLyncConnectionFail').slideUp('fast');
                            $('#editMsLyncSQLConnection').fadeTo('fast', 1);
                        }, 10000);
                    }

                    $('#MsLyncSqlConnectionSection').removeClass('disDiv');
                }
            }
        });
    });
});