﻿var CE_timeout = 1000;
var CE_UpdateSvc = false;

$(document).ready(function () {
    var IsEdited = false;

    function ServiceCare() {
        $.ajax({
            type: "POST",
            url: `/care/state/${$('#ServiceCare').data('name')}`,
            success: function (response) {
                $('#ServiceCare').prop('checked', response.success);

                $('#ServiceCare').change(() => {
                    $.ajax({
                        type: "POST",
                        url: `/care/manage/${$('#ServiceCare').data('name')}/${$('#ServiceCare').prop('checked')}`,
                        success: function (response) {
                            if (response != null && response.success == true) {
                                ShowSpinner(false);
                                IsEdited = false;
                            }
                            else {
                                ShowSpinner(false);
                                $('#svcCautionModal').modal('show');
                            }
                        }
                    });
                });
            }
        });
    }

    function LoadDataOfSvc() {
        //update information about service
        console.log('LoadDataOfSvc: window.CE_UpdateSvc = ' + CE_UpdateSvc + ', IsEdited = ' + IsEdited);

        if (CE_UpdateSvc)
            $.ajax({
                type: "POST",
                url: '/Netflow/SvcInfo/',
                async: true,
                success: function (response) {
                    if (response !== null && response.success === true) {

                        $('#svcStatus').html(response.ServiceStatusText);

                        switch (response.ServiceStatus) {

                            case -1://not installed
                                //buttons
                                $('#btnInstall').show();
                                $('#btnUninstall').hide();
                                $('#btnRun').show();
                                $('#btnStop').hide();
                                $('#btnInstall').attr('disabled', false);
                                $('#btnUninstall').attr('disabled', false);
                                $('#btnRun').attr('disabled', true);
                                $('#btnStop').attr('disabled', false);

                                //login panel
                                $('#containerLocalAcc').removeClass('disDiv');
                                if (IsEdited)
                                    $('#LoginPanel').removeClass('disDiv');
                                else {
                                    $('#LocalAcc').prop('checked', response.IsLocal);
                                    $('#svcLogin').val(response.UserName);
                                    $('#svcPass').val('fake pass');

                                    if (response.IsLocal)
                                        $('#LoginPanel').addClass('disDiv');
                                    else
                                        $('#LoginPanel').removeClass('disDiv');
                                }
                                break;
                            case 1://stop
                                //buttons
                                $('#btnInstall').hide();
                                $('#btnUninstall').show();
                                $('#btnRun').show();
                                $('#btnStop').hide();
                                $('#btnInstall').attr('disabled', false);
                                $('#btnUninstall').attr('disabled', false);
                                $('#btnRun').attr('disabled', false);
                                $('#btnStop').attr('disabled', false);

                                //login panel
                                $('#LoginPanel').addClass('disDiv');
                                $('#containerLocalAcc').addClass('disDiv');
                                $('#LocalAcc').prop('checked', response.IsLocal);
                                $('#svcLogin').val(response.UserName);
                                $('#svcPass').val('fake pass');
                                break;
                            case 4://run
                                //button
                                $('#btnInstall').hide();
                                $('#btnUninstall').show();
                                $('#btnRun').hide();
                                $('#btnStop').show();
                                $('#btnInstall').attr('disabled', false);
                                $('#btnUninstall').attr('disabled', true);
                                $('#btnRun').attr('disabled', false);
                                $('#btnStop').attr('disabled', false);

                                //login panel
                                $('#LoginPanel').addClass('disDiv');
                                $('#containerLocalAcc').addClass('disDiv');
                                $('#LocalAcc').prop('checked', response.IsLocal);
                                $('#svcLogin').val(response.UserName);
                                $('#svcPass').val('fake pass');
                                break;
                            default:
                                $('#btnInstall').attr('disabled', true);
                                $('#btnUninstall').attr('disabled', true);
                                $('#btnRun').attr('disabled', true);
                                $('#btnStop').attr('disabled', true);
                                break;
                        }

                        setTimeout(LoadDataOfSvc, CE_timeout);
                    }
                }
            });
    }

    function AttachEventsForSettings() {
        //events for setting page
        //attach events for settings of service
        $('#LocalAcc').change(function () {
            IsEdited = !$(this).prop('checked');
        });

        //install service
        $('#btnInstall').on('click', function () {
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                url: '/Netflow/Install/?login=' + $('#svcLogin').val() + '&pass=' + $('#svcPass').val(),
                success: function (response) {
                    if (response !== null && response.success === true) {
                        ShowSpinner(false);
                        IsEdited = false;
                    }
                    else {
                        ShowSpinner(false);
                        $('#svcCautionModal').modal('show');
                    }
                }
            });
        });

        //uninstall service
        $('#btnUninstall').on('click', function () {
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                url: '/Netflow/Uninstall/',
                success: function (response) {
                    if (response !== null && response.success === true) {
                        ShowSpinner(false);
                        IsEdited = false;
                    }
                    else {
                        ShowSpinner(false);
                        $('#svcCautionModal').modal('show');
                    }
                }
            });
        });

        //run service
        $('#btnRun').on('click', function () {
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                url: '/Netflow/Run/',
                success: function (response) {
                    if (response !== null && response.success === true) {
                        ShowSpinner(false);
                        IsEdited = false;
                    }
                    else {
                        ShowSpinner(false);
                        $('#svcCautionModal').modal('show');
                    }
                }
            });
        });

        //stop service
        $('#btnStop').on('click', function () {
            ShowSpinner(true);
            $.ajax({
                type: "POST",
                url: '/Netflow/Stop/',
                success: function (response) {
                    if (response !== null && response.success === true) {
                        ShowSpinner(false);
                        IsEdited = false;
                    }
                    else {
                        ShowSpinner(false);
                        $('#svcCautionModal').modal('show');
                    }
                }
            });
        });
    }

    //open settings
    $('#btnSettings').on('click', () => { window.open('/Netflow/Settings', '_parent'); });

    //open log
    $('#btnLog').on('click', () => { window.open('/Netflow/Log', '_parent'); });

    AttachEventsForSettings();
    CE_UpdateSvc = true;
    LoadDataOfSvc();
    ServiceCare();
});