﻿$(document).ready(() => {
    let selectedDevice = null;

    function Export(t) {
        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/Devices/Export/?type=' + t,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/Devices/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }

                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    };

    function ExpandLeftMenu() {
        try {
            if (NodeIsLoaded) {
                ShowNodes('NewNodesMenu');
                ShowNodeEntry($('#nodeID').val() + '');
                ShowDevices('CNode_' + $('#nodeID').val() + '');
            }
            else {
                setTimeout(ExpandLeftMenu, 200);
            }
        } catch (e) {
            setTimeout(ExpandLeftMenu, 200);
        }

    }

    function UpdateButtons() {
        if (selectedDevice === null) {
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
        }
        else {
            $("#btnEdit").attr("disabled", false);
            $("#btnDelete").attr("disabled", false);
        }
    }

    function AttachEventsForTable() {
        selectedDevice = null;

        $('#tariscope-devices tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedDevice = null;
            }
            else {
                selectedDevice = $(this).find('td[data-name="ID"]').text();
                $('#tariscope-devices tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/Devices/SetSort/?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        Load();
                    }
                }
            });
        });

        UpdateButtons();
    }

    function Load() {
        $('#equipmentsTable').load('/Devices/Load/?Search=' + encodeURIComponent($('#tbSearch').val()), AttachEventsForTable);
    }

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    //show modal for delete pbx
    $('#btnDelete').on('click', () => {
        $('#cannoDeleteDev').hide();
        $('#deletePxbbtn').prop('disabled', false);
        $('#deletePbxmodal').modal('show');
    });

    //confirm delete pbx
    $('#deletePxbbtn').on('click', () => {
        $('#deletePbxmodal').modal('hide');
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/Devices/Delete/' + selectedDevice,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                if (response !== null && response.success === true) {
                    $('li[id*="CSelectedDevice_' + selectedDevice + '"]').each(function () { $(this).remove(); });
                    Load();
                }
                else {
                    $('#deletePbxmodal').modal('show');
                    $('#cannoDeleteDev').slideDown('fast');
                    $('#deletePxbbtn').prop('disabled', true);
                }
            }
        });
    });

    //go to edit device
    $('#btnEdit').on('click', () => { window.location = '/Devices/Edit/' + selectedDevice; });

    //show modal for add a new device
    $('#btnAdd').on('click', () => {
        $('#saveDevice').prop('disabled', true);
        $('#cannotEmpty').hide();
        $('#deviceName').val('');

        $('#addDevicemodal').modal('show');
    });

    //show error when the name is empty
    $('#deviceName').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#cannotEmpty').slideDown('fast');
            $('#saveDevice').prop('disabled', true);
        }
        else {
            $('#cannotEmpty').slideUp('fast');
            $('#saveDevice').prop('disabled', false);
        }
    });
    document.getElementById("deviceName").onkeypress = function (e) {
        var chr = String.fromCharCode(e.which);
        if ('(),.-_></\[];:`~%^&*#"'.indexOf(chr) >= 0)
            return false;
    };

    //add new device and redirect to edit it
    $('#saveDevice').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/Devices/Add/?Name=' + encodeURIComponent($('#deviceName').val()),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.location = '/Devices/Edit/' + response.id;
                }
                else {
                    $('#addDevicemodal').modal('hide');
                }
            }
        });
    });

    Load();
    ExpandLeftMenu();
});