﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using SoftPi.Tariscope.Common;
using System.IO;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Models;
using SoftPI.Tariscope.WebAdministration.Observer.Scripting.Interfaces;


public class AlcatelOXETCPclientScript : IScript
{
    private IScriptHost Host;
    private bool isCancelled;
    private List<byte> incomingData;

    private string TEST_REQ = "54 45 53 54 5F 52 45 51".Replace(" ", string.Empty);
    private byte[] TEST_RSP = ToBytes("00 08 54 45 53 54 5F 52 53 50");
    private byte[] TICKET_ACK = ToBytes("00 02 00 03");
    private string SINGLEBYTEMESSAGE = "";

    public void Init(IScriptHost host)
    {
        this.Host = host;
        host.Close += OnClose;
        incomingData = new List<byte>();
    }

    private void OnClose(ref bool Cancel)
    {
        isCancelled = true;
        return;
    }

    public void Main(object Parameters)
    {
        DialogInit();
        ServerInit();
        do
        {
            var result = this.Host.WaitFor(SINGLEBYTEMESSAGE, 1000);
            if (!this.Host.IsPortOpened())
                isCancelled = true;

            if (result)
            {
                // 
                this.Host.AddEvent("It has been received data from Alcatel OXE", 2);
                incomingData.AddRange(this.Host.GetReceivedBufferBlock());
                // 
                this.Host.AddEvent(ToHex(incomingData.ToArray()), 2);
                if (incomingData.Count >= 772)
                {
                    this.Host.AddEvent("Received: " + ToHex(incomingData.ToArray()), 2);
                    Host.SendData(TICKET_ACK);
                    incomingData.Clear();
                }
                else if (ToHex(incomingData.ToArray()).Contains(TEST_REQ))
                {
                    this.Host.SendData(TEST_RSP);
                    // 
                    this.Host.AddEvent("TEST_RSP has been sent", 2);
                    incomingData.Clear();
                }
            }
        }
        while (this.isCancelled == false);
    }


    //Dialog initialization
    private void DialogInit()
    {
        //Script sends the message
        this.Host.SendData(ToBytes("000153"));
        //Script waits for the PBX response
        this.Host.WaitFor(ToBytes("000150"));
        this.Host.AddEvent("  Identification response was received: 000150", 2);
        this.Host.Wait(100);
    }

    //Server initialization
    private void ServerInit()
    {
        //Script sends INIT_REQ
        this.Host.SendData(ToBytes("00 02 00 00"));
        //Script waits for INIT_RSP
        this.Host.WaitFor(ToBytes("03 04"));
        this.Host.AddEvent("  Server initialization response was received: 03 04", 2);
        this.Host.Wait(100);
    }

    private static byte[] ToBytes(string hexvalues)
    {
        hexvalues = hexvalues.Replace(" ", "");
        return Enumerable.Range(0, hexvalues.Length / 2)
            .Select(x => Convert.ToByte(hexvalues.Substring(x * 2, 2), 16))
            .ToArray();
    }


    private static string ToHex(byte[] bytes)
    {
        string hex = BitConverter.ToString(bytes);
        return hex.Replace("-", "");
    }

}
