﻿$(document).ready(function () {
    var selectedService = null;
    var updateInterval = 2000;

    var test = 0;

    UpdateServices();

    function UpdateServices() {
        $.ajax({
            type: "GET",
            url: "/api/tariscopeservices",
            contentType: "application/json",
            success: function (services) {
                var tbodyContent = '';

                $.each(services, function (index, service) {
                    if (service.ProfileName == selectedService) {
                        tbodyContent += '<tr class="selected">';

                        if (test == 0) {
                            console.log(service);
                        }
                    } else {
                        tbodyContent += '<tr>';
                    }

                    tbodyContent +=
                            '<td data-name="ProfileName">' + service.ProfileName + '</td>'
                            + '<td data-name="State">' + service.State + '</td>'
                            + '<td data-name="PBXName">' + service.PBXName + '</td>'
                            + '<td data-name="PBXType">' + service.PBXType + '</td>'
                            + '<td data-name="LogonAs">' + service.LogonAs + '</td>'
                            + '<td data-name="Uptime">' + service.Uptime + '</td>'
                            + '<td data-name="LastCdrDate">' + service.LastCdrDate + '</td>'
                            + '<td data-name="LastCallDate">' + service.LastCallDate + '</td>'
                            + '<td data-name="IsDatabaseConnected">' + service.IsDatabaseConnected + '</td>'
                            + '<td data-name="IsDataSourceConnected">' + service.IsDataSourceConnected + '</td>'
                            + '<td data-name="LastReport">' + service.LastReport + '</td>'
                        + '</tr>';
                });

                test = test + 1;

                $('#tariscope-services tbody').html(tbodyContent);
                setTimeout(UpdateServices, updateInterval);
            },
            dataType: "json"
        });
    };

    $('#tariscope-services tbody').on('dbclick', 'tr', function () {
        console.log("dbclick");
    });

    $('#btn-tools').on('click', 'button[data-name="Add"]', function () {
        set_cookie("mode", "add");
        set_cookie("profileName", null);

        var url = '/TariscopeServices/Configuration';
        location.href = url;
    });

    $('#btn-tools').on('click', 'button[data-name="Edit"]', function () {
        if (selectedService != null) {
            set_cookie("mode", "edit");
            set_cookie("profileName", selectedService);

            var url = '/TariscopeServices/Configuration';
            location.href = url;
        }
    });

    $('#btn-tools').on('click', 'button[data-name="Start"]', function () {
        if (selectedService != null) {
            $.ajax({
                type: "PUT",
                url: "/api/tariscopeservices/" + selectedService + "/start",
                contentType: "application/json",
                dataType: "json"
            });
        }
    });

    $('#btn-tools').on('click', 'button[data-name="Delete"]', function () {
        if (selectedService != null) {
            $.ajax({
                type: "PUT",
                url: "/api/tariscopeservices/" + selectedService + "/delete",
                contentType: "application/json",
                dataType: "json"
            });
        }
        
        selectedService = null;
    });

    $('#btn-tools').on('click', 'button[data-name="Install"]', function () {
        if (selectedService != null) {
            $.ajax({
                type: "PUT",
                url: "/api/tariscopeservices/" + selectedService + "/install",
                contentType: "application/json",
                dataType: "json"
            });
        }
    });

    $('#btn-tools').on('click', 'button[data-name="Uninstall"]', function () {
        if (selectedService != null) {
            $.ajax({
                type: "PUT",
                url: "/api/tariscopeservices/" + selectedService + "/uninstall",
                contentType: "application/json",
                dataType: "json"
            });
        }
        
        selectedService = null;
    });

    $('#btn-tools').on('click', 'button[data-name="Stop"]', function () {
        if (selectedService) {
            $.ajax({
                type: "PUT",
                url: "/api/tariscopeservices/" + selectedService + "/stop",
                contentType: "application/json",
                dataType: "json"
            });
        }
    });

    $('#btn-tools').on('click', 'button[data-name="StartAll"]', function () {
        $.ajax({
            type: "PUT",
            url: "/api/tariscopeservices/start",
            contentType: "application/json",
            dataType: "json"
        });
    });

    $('#btn-tools').on('click', 'button[data-name="StopAll"]', function () {
        $.ajax({
            type: "PUT",
            url: "/api/tariscopeservices/stop",
            contentType: "application/json",
            dataType: "json"
        });
    });

    $('#tariscope-services tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            selectedService = null;
        }
        else {
            selectedService = $(this).find('td[data-name="ProfileName"]').text();
            $('#tariscope-services tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
    });
})