﻿$(document).ready(function () {
    //var calls;
    //var fields = [
    //    'PBXID', 'RecType', 'CallType', 'NumberA', 'NumberB',
    //    'CallDate', 'CallTime', 'AccessCode', 'FromAbonent', 'FromTelephone',
    //    'ToTelephone', 'CategoryID', 'CallSeconds', 'Cost', 'RingTimeSeconds',
    //    'ReleaseCause'
    //];
    //Variables for modal tree checkbox.
    //All data for graid.
    var tableData;
    //Count children in node.
    var countNodeRows = {};
    //Active nodes or children in treecheckbox dialog.
    var tempActiveNodes = {};
    //Узел считается не отмеченым.
    var unchecked = -1;
    var pbxsObj;

    //Variables for modal filter.
    //Active nodes or children in filter dialog.
    var tempChoosenNodes = {};
    var equipmentsStr = undefined;

    //Variables for general calls page.
    var queryObject = {};
    queryObject.NodesClient = {};
    var pbxs = {};
    var recTypes = {};
    var callTypes = {};
    var categoryIds = {};
    var releaseCauses = {};

    //Gets pbxs.
    $.ajax({
        type: "GET",
        url: "/api/pbxs",
        contentType: "application/json",
        success: function (data) {
            pbxsObj = data;
            $.each(data, function (index, pbx) {
                pbxs[pbx.ID] = pbx.Name;
            });
        },
        dataType: "json"
    });

    //Gets categories.
    $.ajax({
        type: "GET",
        url: "/api/calls/categorytypes",
        contentType: "application/json",
        success: function (data) {
            $.each(data, function (index, category) {
                categoryIds[category.ID] = category.Name;
            });
        },
        dataType: "json"
    });

    //Gets dictionary id and name for terminate reason.
    $.ajax({
        type: "GET",
        url: "/api/calls/releasecause",
        contentType: "application/json",
        success: function (data) {
            releaseCauses = data;
        },
        dataType: "json"
    });

    //Gets dictionary id and name for record types.
    $.ajax({
        type: "GET",
        url: "/api/calls/recordTypes",
        contentType: "application/json",
        success: function (data) {
            recTypes = data;
        },
        dataType: "json"
    });

    //Gets dictionary id and name for call types.
    $.ajax({
        type: "GET",
        url: "/api/calls/types",
        contentType: "application/json",
        success: function (data) {
            callTypes = data;
        },
        dataType: "json"
    });

    //Add calls to table.
    function AddCalls(data) {
        $('#calls-statistic-general tbody').empty();
        if (data.length > 0) {
            var tr$ = $('#calls-statistic-general thead tr').clone();

            $.each(data, function (index, call) {
                var tempTr$ = tr$.clone();

                $.each(call, function (key, value) {
                    tempTr$.find('td[data-name=' + key + ']').text(ReplaceData(key, value));
                });

                $('#calls-statistic-general tbody').append(tempTr$);
            });
        }

    }

    //Replacing enum value or id to name.
    function ReplaceData(key, value) {
        switch (key) {
            case 'PBXID':
                return pbxs[value];
                break;
            case 'RecType':
                return recTypes[value];
                break;
            case 'CallType':
                return callTypes[value];
                break;
            case 'CategoryID':
                return categoryIds[value];
                break;
            case 'ReleaseCause':
                return releaseCauses[value];
                break;
            case 'CallDate':
                return $.tariscope.dateTime.ConvertToDate(value);
                break;
            case 'CallTime':
                return $.tariscope.dateTime.ConvertToTime(value);
                break;
            default:
                return value;
        }
    };

    //Event handler for open modal dialog filter.
    $(document).on("click", ".dialogFilterGeneralCalls", function (e) {
        e.preventDefault();

        $.get(this.href, function (data) {
            $('#dialogFilterGeneralCalls').html(data);
            $('#modFilterGeneralCalls').modal('show');
        });
        tempChoosenNodes = $.extend({}, queryObject.NodesClient);
    });

    //Event handler for open modal dialog treecheckbox.
    $(document).on("click", ".dialogEquipmentsTreeCheckBox", function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogEquipmentsTreeCheckBox').html(data);
            $('#modEquipmentsTreeCheckBox').modal('show');

            $.ajax({
                type: "GET",
                url: "/api/nodes",
                contentType: "application/json",
                success: function (data) {

                    $.each(data, function (index, node) {
                        node['Pbxs'] = [];
                        $.each(pbxsObj, function (index, pbx) {
                            if (pbx.NodeID == node.ID) {
                                node['Pbxs'].push(pbx);
                            }
                        });
                    });

                    tableData = data;
                    tempActiveNodes = $.extend({}, tempChoosenNodes);
                    $('#tree-checkbox tbody').html(LoadNodes(data));
                },
                dataType: "json"
            });
        });
    });

    //Event handler for button OK in modal dialog filter.
    $(document).on('click', '#ok-modal-filter', function () {
        ShowTable();
        $('#modFilterGeneralCalls').modal('hide');
    });

    function ShowTable()
    {
        queryObject.NodesClient = $.extend({}, tempChoosenNodes);
        var nodeIds = [];
        var pbxIds = [];

        $.each(tempChoosenNodes, function (index, node) {
            if ($.inArray(unchecked, node) != -1) {
            }
            else if (node.length == 0) {
                nodeIds.push(index);
            }
            else {
                $.each(node, function (index, pbxId) {
                    pbxIds.push(pbxId);
                });
            }
        });

        queryObject.NodeIds = nodeIds;
        queryObject.PbxIds = pbxIds;
        queryObject.Period = $('#period-filter').val();
        queryObject.From = $('#from-filter').val();
        queryObject.To = $('#to-filter').val();
        queryObject.Year = $('#year-filter').val();
        queryObject.Month = $('#month-filter').val();
        equipmentsStr = $('#equipments-filter').val();
        $.ajax({
            type: "POST",
            url: "/api/calls",
            contentType: "application/json",
            data: JSON.stringify(queryObject),
            success: function (data) {
                AddCalls(data);
            },
            dataType: "json"
        });
    }

    ShowTable();

    //Event handler for button OK in modal dialog treecheckbox.
    $(document).on('click', '#ok-modal-treecheckbox', function () {
        tempChoosenNodes = $.extend({}, tempActiveNodes);
        $('#equipments-filter').val(GetCheckedNames());
        $('#modEquipmentsTreeCheckBox').modal('hide');
    });

    /////////////////////Modal filter//////////////////////////////////////

    $(document).on('change', '#period-filter', function () {
        var periodId = parseInt($('#period-filter').val());

        $('#year-filter').closest('div.form-group').addClass('hidden');
        $('#month-filter').closest('div.form-group').addClass('hidden');
        $('#from-filter').closest('div.form-group').addClass('hidden');
        $('#to-filter').closest('div.form-group').addClass('hidden');

        switch (periodId) {
            case $.tariscope.enums.EnumFilterPeriod.CustomMonth:
                $('#year-filter').closest('div.form-group').removeClass('hidden');
                $('#month-filter').closest('div.form-group').removeClass('hidden');
                break;
            case $.tariscope.enums.EnumFilterPeriod.CustomYear:
                $('#year-filter').closest('div.form-group').removeClass('hidden');
                break;
            case $.tariscope.enums.EnumFilterPeriod.CustomPeriod:
                $('#from-filter').closest('div.form-group').removeClass('hidden');
                $('#to-filter').closest('div.form-group').removeClass('hidden');
                break;
        }
    });

    $('#modFilterGeneralCalls').on('shown.bs.modal', function (e) {
        $('#from-filter').datepicker({
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'yy-mm-dd'
        });

        $('#to-filter').datepicker({
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            dateFormat: 'yy-mm-dd'
        });

        $('#from-filter').val($.tariscope.dateTime.getCurrentDate());
        $('#to-filter').val($.tariscope.dateTime.getCurrentDate());

        if (queryObject.Period != undefined) {
            $('#period-filter').val(queryObject.Period);
        }
        if (queryObject.From != undefined) {
            $('#from-filter').val(queryObject.From);
        }
        if (queryObject.To != undefined) {
            $('#to-filter').val(queryObject.To);
        }
        if (queryObject.Year != undefined) {
            $('#year-filter').val(queryObject.Year);
        }
        if (queryObject.Month != undefined) {
            $('#month-filter').val(queryObject.Month);
        }
        if (equipmentsStr != undefined) {
            $('#equipments-filter').val(equipmentsStr);
        }
    })

    /////////////////////Modal tree checkbox pbx///////////////////////////

    //Add to table nodes with checkbox.
    function LoadNodes(data) {
        var rows = '';

        $.each(data, function (index, node) {
            var checkboxAttr = '';

            if (tempActiveNodes[node.ID] == undefined) {
                tempActiveNodes[node.ID] = [unchecked];
            }
            else if (tempActiveNodes[node.ID].length == 0) {
                checkboxAttr = 'checked="checked"';
            }

            var trNode = '<tr class="text-boold" data-nodeid="' + node.ID + '">';
            trNode += '<td><span class="arrow-right grid-icon"></span><label class="checkbox-inline text-boold">' +
                          '<input type="checkbox" ' + checkboxAttr + '>' + node.Name +
                      '</label></td>' +
                      '<td></td>' +
                      '<td></td>' +
                      '<td>' + node.ID + '</td>';
            trNode += '</tr>';
            rows += trNode;
        });
        return rows;
    };

    //Add children with checkbox for choosen node.
    function LoadChildren(parent$) {
        var nodeId = parent$.data('nodeid');
        var isChecked = parent$.find('input:checkbox:first').is(':checked');
        var checkboxAttr = '';

        $.each(tableData, function (index, node) {
            if (nodeId == node.ID) {
                countNodeRows[nodeId] = node.Pbxs.length;
                var rows = '';

                $.each(node.Pbxs, function (index, pbx) {
                    if (isChecked) {
                        checkboxAttr = 'checked="checked"';
                    }
                    else if ($.inArray(pbx.ID, tempActiveNodes[nodeId]) != unchecked) {
                        checkboxAttr = 'checked="checked"';
                    }

                    var trPbx = '<tr data-parentid="' + node.ID + '" data-pbxid=' + pbx.ID + '>' +
                        '<td style="padding-left:43px;"><label class="checkbox-inline">' +
                              '<input type="checkbox"' + checkboxAttr + '> ' + pbx.Name +
                        '<td>' + pbx.PBXType + '</td>' +
                        '<td>' + pbx.Address + '</td>' +
                        '<td>' + pbx.ID + '</td>' +
                        '</tr>';
                    rows += trPbx;
                    checkboxAttr = '';
                });

                $(parent$).after(rows);
            }
        });
    };

    //Remove children for choosen node.
    function RemoveChildren(parentId) {
        $('tr[data-parentid="' + parentId + '"]').remove();
    };

    //Event handler for collapse and expand nodes of the tree.
    $(document).on("click", "#tree-checkbox span.grid-icon", function () {
        var tr$ = $(this).closest('tr');

        if ($(this).hasClass('arrow-right')) {
            $(this).removeClass('arrow-right').addClass('arrow-down');
            LoadChildren(tr$);
        } else {
            $(this).removeClass('arrow-down').addClass('arrow-right');
            RemoveChildren($(tr$).data('nodeid'));
        }
    });

    //Если в node находится значение переменной uncheked, то этот узел считается не отмеченым.
    //Если в node нет чисел, то считается что он отмечен.
    //Если в node есть числа, то nodeId не учитывается а берутся все устройства которые в нем.
    $(document).on("click", "#tree-checkbox input[type=checkbox]", function () {
        var tr$ = $(this).closest('tr');
        var nodeId = tr$.data('nodeid');

        if ($(this).val() == 'all') {
            if (!$(this).is(':checked')) {
                $('#tree-checkbox input[type=checkbox]').prop('checked', false);
            }
            else {
                $('#tree-checkbox input[type=checkbox]').prop('checked', true);
            }
        }
        else if (typeof nodeId !== typeof undefined && nodeId !== false) {
            if ($(this).is(':checked')) {
                $('#tree-checkbox tr[data-parentid=' + nodeId + '] input[type=checkbox]').prop('checked', true);
                tempActiveNodes[nodeId] = [];
            }
            else {
                $('#tree-checkbox tr[data-parentid=' + nodeId + '] input[type=checkbox]').prop('checked', false);
                tempActiveNodes[nodeId] = [unchecked];
            }

            VerifyingSwitchingMainCheckbox();
        }
        else {
            var parentId = tr$.data('parentid');
            var nodeCheckBox$ = $('#tree-checkbox tr[data-nodeid=' + parentId + '] input[type=checkbox]');


            if (!$(this).is(':checked')) {
                tempActiveNodes[parentId] = [];
                $('#tree-checkbox tr[data-parentid=' + parentId + '] input[type=checkbox]:checked').each(function () {
                    tempActiveNodes[parentId].push($(this).closest('tr').data('pbxid'));
                });
                nodeCheckBox$.prop('checked', false);
            }
            else {
                var count = $('#tree-checkbox tr[data-parentid=' + parentId + '] input[type=checkbox]:checked').length;
                tempActiveNodes[parentId].clean(unchecked);
                tempActiveNodes[parentId].push(tr$.data('pbxid'));
                if (countNodeRows[parentId] == count) {
                    tempActiveNodes[parentId] = [];
                    nodeCheckBox$.prop('checked', true);
                }
            }

            VerifyingSwitchingMainCheckbox();
        }
    });

    //Verifying if all the nodes is checked in the tree.
    //If all nodes is cheked, the main checkbox will be checked.
    function VerifyingSwitchingMainCheckbox() {
        var countNodeCheckBox = $('#tree-checkbox tr[data-nodeid]').length;
        var countActiveNodeCheckBox = $('#tree-checkbox tr[data-nodeid] input:checkbox:checked').length;
        if (countActiveNodeCheckBox == countNodeCheckBox) {
            $('#check-all').prop('checked', true);
        }
        else {
            $('#check-all').prop('checked', false);
        }
    }

    function GetCheckedNames() {
        var names = '';
        $.each(tempActiveNodes, function (index, node) {
            if ($.inArray(unchecked, node) != -1) {
            }
            else if (node.length == 0) {
                names += ' ' + GetNameByIdKey('node', index) + ',';
            }
            else {
                $.each(node, function (index, pbxId) {
                    names += ' ' + GetNameByIdKey('pbx', pbxId) + ',';
                });
            }
        });

        return names.slice(0, -1);
    };

    function GetNameByIdKey(key, id) {
        var result = '';

        $.each(tableData, function (index, node) {
            if (key === 'node' && parseInt(id) == parseInt(node.ID)) {
                result = node.Name;
                return false;
            }
            else if (key === "pbx") {
                $.each(node.Pbxs, function (index, pbx) {
                    if (parseInt(id) == parseInt(pbx.ID)) {
                        result = pbx.Name;
                        return false;
                    }
                });
            }
        });

        return result;
    };
});