﻿$(document).ready(function () {
    $(function () {
        var $affix = $(".toolbar"),
            $parent = $affix.parent(),
            resize = function () { $affix.width($parent.width()); };
        $(window).resize(resize);
        resize();
    });

    $('#batch-payments-table tbody').on('click', 'tr', function () {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
            $('#edit-batch-payment').addClass('break-load-page');
        }
        else {
            $('#batch-payments-table tbody tr').removeClass('selected');
            $(this).addClass('selected');
            $("#edit-batch-payment").removeClass("break-load-page");
        }
    });

    $(".dialogEditManualPayment").click(function (e) {
        e.preventDefault();

        if ($(this).hasClass('break-load-page')) {
            return;
        }

        var isLoadManualData = false;

        if ($(this).hasClass('edit')) {
            isLoadManualData = true;
        }

        $.get(this.href, function (data) {
            $('#dialogEditManualPayment').html(data);
            $('#modEditManualPayment').modal('show');

            var pbxId = null;

            if (isLoadManualData) {
                pbxId = LoadManualPaymentData();
            }

            $.getJSON('/api/pbxs/', function (data) {
                var selectEquipments$ = $("#pbxs-edit-manual-payment");

                $.each(data, function (index, item) {
                    if (item.ID == pbxId) {
                        selectEquipments$.append('<option value="' + item.ID + '" selected>' + item.Name + '</option>');
                    }
                    else {
                        selectEquipments$.append('<option value="' + item.ID + '">' + item.Name + '</option>');
                    }
                });
                //data.Pbxs.forEach(function (item) {
                //    if (item.ID == pbxId) {
                //        selectEquipments$.append('<option value="' + item.ID + '" selected>' + item.Name + '</option>');
                //    }
                //    else {
                //        selectEquipments$.append('<option value="' + item.ID + '">' + item.Name + '</option>');
                //    }
                //});
            });
        });
    });

    function LoadManualPaymentData() {
        var row$ = $('#batch-payments-table tbody tr.selected');
        $('#row-index').text(row$.index());
        var pbxId = null;

        $(row$).find('td').each(function () {
            var tdText = $(this).text();
            var tdName = $(this).data('name');

            switch (tdName) {
                case 'RecDate':
                    $('#date-manual-payment').val(tdText);
                    break;
                case 'AbonentFullName':
                    $('#abonent-fullname-edit-manual-payment').val(tdText);
                    break;
                case 'DN':
                    $('#number-edit-manual-payment').val(tdText);
                    break;
                case 'Payment':
                    $('#amount-manual-payment').val(tdText);
                    break;
                case 'Description':
                    $('#description-edit-manual-payment').val(tdText);
                    break;
                case 'BankAuthority':
                    $('#bank-edit-manual-payment').val(tdText);
                    break;
                case 'PaymentType':
                    $('#payment-type-edit-manual-payment :contains(' + tdText + ')').attr("selected", "selected");
                    break;
                case 'AbonentID':
                    $('#abonent-id-edit-manual-payment').val(tdText);
                    break;
                case 'PbxId':
                    pbxId = tdText;
                    break;
            }
        });

        return pbxId;
    };

    $('#save-batch-payment').click(function () {
        if (parseInt($('#max-amount').text()) > 0) {
            if (parseInt($('#amount').text()) > parseInt($('#max-amount').text())) {
                $('#span-amount-text').addClass('bg-danger');
                $('#error-amount').show();
                return;
            }
            else {
                $('#span-amount-text').removeClass('bg-danger');
                $('#error-amount').hide();
            }
        }

        if ($('#batch-payments-table tbody .bg-danger').length > 0) {
            return;
        }

        var rows$ = $('#batch-payments-table tbody');
        var payments = [];
        var abonentIds = [];

        $(rows$).find('tr').each(function () {
            var row = {};

            $(this).find('td').each(function () {
                row[$(this).data('name')] = $(this).text();

                if ($(this).data('name') == 'AbonentID') {
                    abonentIds.push($(this).text());
                }
            });

            payments.push(row);
        });

        var missingIds = [];

        $.ajax({
            type: "POST",
            url: "/api/abonents/checkedids/",
            contentType: "application/json",
            data: JSON.stringify(abonentIds),
            success: function (data) {
                if (data.length > 0) {
                    $('#batch-payments-table tbody tr td').each(function () {
                        if ($(this).data('name') == 'AbonentID' && $.inArray(parseInt($(this).text()), data) > -1) {
                            $(this).closest('tr').addClass('bg-danger');
                        }
                    });
                } else {
                    $.ajax({
                        type: "POST",
                        url: "/api/account/batchpayment/",
                        contentType: "application/json",
                        data: JSON.stringify(payments),
                        success: function (data) {
                            //var url = "/Event/Success?message=" + data;                            
                            //window.location.href = url;
                            $('#wrapper-patch-payment').html("<h3>" + data + "</h3>");
                            //$.ajax({
                            //    type: "POST",
                            //    url: "/Event/Success/",
                            //    contentType: "application/json",
                            //    data: JSON.stringify(data),
                            //    dataType: "json"
                            //});
                        },
                        dataType: "json"
                    });
                }
            },
            dataType: "json"
        });
    });

    $(".dialogImportPayments").click(function (e) {
        e.preventDefault();

        $.get(this.href, function (data) {
            $('#dialogEditManualPayment').html(data);
            $('#modEditManualPayment').modal('show');
        });
    });

    $(document).ready(function () {
        $('#clickInputMaxAmount').click();
    });

    $(".dialogInputMaxAmount").click(function (e) {
        e.preventDefault();
        $.get(this.href, function (data) {
            $('#dialogInputMaxAmount').html(data);
            $('#modInputMaxAmount').modal('show');
        });
    });

    $('#remove-batch-payment').click(function () {
        $('#batch-payments-table > tbody tr.selected').remove();
        $('#count-payments').text($('#batch-payments-table > tbody tr:last').index() + 1);
        $('#amount').text($.tariscope.table.sumColumnByDataName('Payment', 'batch-payments-table'));
    });
});