﻿{
    const ADDITIONAL_MENU_ITEMS = "AdditionalOptions";
    const SERVICES_MENU_ITEMS = "CustomerServicesMenu";
    const REPORTING_MENU_ITEMS = "ReportsMenu";
    const VIEWS_MENU_ITEMS = "ViewsMenu";
    const GENERAL_MENU_ITEMS = "DashboardGeneralMenu";
    const NO_DASH_GENERAL_MENU_ITEMS = "GeneralMenu";
    const TASKS_MENU_ITEMS = "TasksMenu";
    const WORK_ORDER_MENU_ITEMS = "EmployeeMenu";

    let LevelMargin = 7;
    let Menus = [];             //Menu items with tree menu
    let MenusIncludes = {};     //when open left menu
    let itemsList = [];         //list of all added menu items
    let itemsLevel = [];        //list for all added menu items margin set
    let entries = [];           //list of all entriezs
    let entriesState = {};      //state for entries (true: open, false: closed)

    function BuildMenuItem(root, id, title, level, url, icon, chevrone, remote = false) {

        /* create menu tree-item */
        var li = document.createElement('li');
        li.id = root + id;
        li.className = "treeItem";

        var a = document.createElement('a');
        if (remote) {
            a.href = url;
            a.target = '_blank';
        }
        else if (url !== null) {
            a.href = '\\' + url;
        }
        else {
            a.href = 'javascript:;';
        }
        a.style.marginLeft = LevelMargin * level + "px";

        var ic = document.createElement('i');
        ic.id = "iconTree";
        ic.className = icon;

        var ttl = document.createElement('span');
        ttl.innerHTML = title;

        a.appendChild(ic);
        a.appendChild(ttl);

        if (chevrone) {
            var chev = document.createElement('i');
            chev.className = "fa fa-chevron-down treeChevroneRight treeChevroneSmall";

            a.appendChild(chev);
        }

        li.appendChild(a);

        $(li).insertAfter($('#' + root));

        itemsList.push(li);
        itemsLevel.push(level);

        $(li).hide();

        return li.id;
    }

    function ChangeMenuItemLevel(item, level) {
        /*change left margin for menu items*/
        $(item).find('a').css('margin-left', LevelMargin * level + "px");
    }

    function ShowMenuItemChevron(item, show) {
        /* show or hide chevron icon*/
        if (show) {
            $(item).find($('.treeChevroneRight')).hide();
        }
        else {
            $(item).find($('.treeChevroneRight')).show();
        }
    }

    function RotateMenuItemChevron(item, back) {
        /* show or hide chevron icon*/
        if (back) {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(-90deg)');
        }
        else {
            $('#' + item).find($('.treeChevroneRight')).css('transform', 'rotate(0)');
        }
    }

    function ShowEntries(parent, force = false) {
        /*show all providers*/
        entries.forEach(element => {
            if (element.includes(parent)) {
                if (force || entriesState[element]) {
                    $('#' + element).slideDown("fast");

                    entriesState[element] = false;
                }
                else {
                    $('#' + element).slideUp("fast");
                    entriesState[element] = true;
                }

                RotateMenuItemChevron(parent, !entriesState[element]);
            }
        });
    }

    function CheckIncludes() {
        for (key in MenusIncludes) {
            MenusIncludes[key].forEach(e => {
                if (window.location.href.includes(e))
                    ShowEntries(key);
            });
        }
        return false;
    }

    //additional opetion
    function _addAdditionalMenu() {
        //Menu item
        Menus.push(ADDITIONAL_MENU_ITEMS);
        MenusIncludes[ADDITIONAL_MENU_ITEMS] = ['/PersonalArea', '/Integrations', '/SQL', '/About', '/License', '/SystemVariables', '/DamagedDays', '/Dictionary', '/Categories', '/NotificationsAndMailing', '/Users', '/Database', '/ServiceRate', '/Logger/Main'];

        //Menu item subitems
        /*about*/
        let abt = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "About", $('#LeftSideLocalizationString_About').val(), 1, "About", "fa fa-info-circle", false);
        entriesState[abt] = true;
        entries.push(abt);

        /*license*/
        let lic = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "License", $('#LeftSideLocalizationString_License').val(), 1, "License", "fa fa-key", false);
        entriesState[lic] = true;
        entries.push(lic);

        /*sys vars*/
        let vars = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "SysVars", $('#LeftSideMenuAdditional_SysVars').val(), 1, "SystemVariables", "fa fa-code", false);
        entriesState[vars] = true;
        entries.push(vars);

        //damaged days
        let ddya = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "Ddays", $('#LeftSideMenuAdditional_DamagedDays').val(), 1, "DamagedDays", "fa fa-unlink", false);
        entriesState[ddya] = true;
        entries.push(ddya);

        //dictionaryes
        let dics = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "Dics", $('#LeftSideMenuAdditional_Dics').val(), 1, "Dictionary", "fa fa-book", false);
        entriesState[dics] = true;
        entries.push(dics);

        //mailing
        let notif = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "Notif", $('#LeftSideMenuAdditional_Mailing').val(), 1, "NotificationsAndMailing", "fa fa-comments", false);
        entriesState[notif] = true;
        entries.push(notif);

        //main log
        let log = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "Log", $('#LeftSideMenuAdditional_MainLog').val(), 1, "Logger/Main", "fa fa-file-code", false);
        entriesState[log] = true;
        entries.push(log);

        //sql pane
        let sql = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "SQL", $('#LeftSideMenuAdditional_SQL').val(), 1, "SQL", "fa fa-terminal", false);
        entriesState[sql] = true;
        entries.push(sql);

        //integrations
        let intg = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "Integrations", $('#LeftSideMenuAdditional_Integrations').val(), 1, "Integrations", "fa fa-hands-helping", false);
        entriesState[intg] = true;
        entries.push(intg);

        //database info
        let dbi = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "DBI", $('#LeftSideMenuAdditional_DBI').val(), 1, "Database", "fa fa-database", false);
        entriesState[dbi] = true;
        entries.push(dbi);

        if ($('#CustomerServicesMenu').length > 0) {
            //service-rate
            let svcrt = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "SVC_RT", $('#LeftSideMenuAdditional_ServiceRate').val(), 1, "ServiceRate", "fa fa-th-list", false);
            entriesState[svcrt] = true;
            entries.push(svcrt);
        }

        //categories
        let ctgrs = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "Ctgrs", $('#LeftSideMenuAdditional_CTG').val(), 1, "Categories", "fa fa-project-diagram", false);
        entriesState[ctgrs] = true;
        entries.push(ctgrs);

        //personal area
        let personal = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "PersonalArea", $('#LeftSideMenuAdditional_PersonalArea').val(), 1, "PersonalArea/Settings", "fa fa-user-circle", false);
        entriesState[personal] = true;
        entries.push(personal);

        //users
        let usrs = BuildMenuItem(ADDITIONAL_MENU_ITEMS, "Usres", $('#LeftSideMenuAdditional_USRS').val(), 1, "Users", "fa fa-user-cog", false);
        entriesState[usrs] = true;
        entries.push(usrs);
    }

    //services
    function _addServicesMenu() {
        //Menu item
        Menus.push(SERVICES_MENU_ITEMS);
        MenusIncludes[SERVICES_MENU_ITEMS] = ['/Services', '/Taxes'];

        //Menu item subitems
        //day types
        let dtp = BuildMenuItem(SERVICES_MENU_ITEMS, "DayTypes", $('#LeftSideLocalizationString_DayTypes').val(), 1, "Services\\DayTypes", "fa fa-calendar-alt", false);
        entriesState[dtp] = true;
        entries.push(dtp);

        //taxes
        let txt = BuildMenuItem(SERVICES_MENU_ITEMS, "Taxes", $('#LeftSideMenuAdditional_CSTaxes').val(), 1, "Taxes", "fa fa-credit-card", false);
        entriesState[txt] = true;
        entries.push(txt);

        //bundles list
        let svc = BuildMenuItem(SERVICES_MENU_ITEMS, "Services", $('#LeftSideMenuAdditional_CSBundlesList').val(), 1, "Services\\Bundles", "fa fa-th-list", false);
        entriesState[svc] = true;
        entries.push(svc);

        //services list
        let bdl = BuildMenuItem(SERVICES_MENU_ITEMS, "Bundles", $('#LeftSideMenuAdditional_CSServicesList').val(), 1, "Services", "fa fa-list-alt", false);
        entriesState[bdl] = true;
        entries.push(bdl);
    }

    //reporting
    function _addReportingMenu() {
        Menus.push(REPORTING_MENU_ITEMS);
        MenusIncludes[REPORTING_MENU_ITEMS] = ['/Logger/Reporter', '/Reporting'];

        //log
        let log = BuildMenuItem(REPORTING_MENU_ITEMS, "Log", $('#LeftSideMenuAdditional_ReportsLog').val(), 1, "Logger\\Reporter", "fa fa-file-code", false);
        entriesState[log] = true;
        entries.push(log);

        //reports list
        let reports = BuildMenuItem(REPORTING_MENU_ITEMS, "Reports", $('#LeftSideMenuAdditional_ReportsList').val(), 1, "Reporting", "fa fa-list-alt", false);
        entriesState[reports] = true;
        entries.push(reports);
    }

    //views
    function _addViewsMenu() {
        Menus.push(VIEWS_MENU_ITEMS);
        MenusIncludes[VIEWS_MENU_ITEMS] = ['/TariscopeViews', '/ProviderViews', '/Tracing'];

        //import proc
        let importCall = BuildMenuItem(VIEWS_MENU_ITEMS, "Import", $('#LeftSideMenuAdditional_Import').val(), 1, "TariscopeViews\\ImportCalls", "fa fa-file-import", false);
        entriesState[importCall] = true;
        entries.push(importCall);

        //cdr proc
        let cdr = BuildMenuItem(VIEWS_MENU_ITEMS, "Cdr", $('#LeftSideMenuAdditional_Transfer').val(), 1, "TariscopeViews\\CallsTransfer", "fa fa-exchange-alt", false);
        entriesState[cdr] = true;
        entries.push(cdr);

        //views list
        let views = BuildMenuItem(VIEWS_MENU_ITEMS, "Views", $('#LeftSideMenuAdditional_viewsList').val(), 1, "TariscopeViews", "fa fa-list-alt", false);
        entriesState[views] = true;
        entries.push(views);
    }

    //home
    function _addGeneralMenu() {
        let menuName = $("#" + GENERAL_MENU_ITEMS).length == 0 ? NO_DASH_GENERAL_MENU_ITEMS : GENERAL_MENU_ITEMS;     

        Menus.push(menuName);
        MenusIncludes[menuName] = ['/Screen', '/News'];

        //history
        let hist = BuildMenuItem(menuName, "History", $('#LeftSideMenuAdditional_HistoryLbl').val(), 1, $('#LeftSideMenuAdditional_HistoryUrl').val(), "fa fa-external-link-alt", false, true);
        entriesState[hist] = true;
        entries.push(hist);

        //last news
        let news = BuildMenuItem(menuName, "News", $('#LeftSideLocalizationString_LastNews').val(), 1, "News", "fa fa-rss", false);
        entriesState[news] = true;
        entries.push(news);

        if ($('#' + GENERAL_MENU_ITEMS).length != 0) {
            //dashboard
            let dash = BuildMenuItem(menuName, "Dashboard", $('#LeftSideLocalizationString_Dashboard').val(), 1, "Home", "fa fa-chalkboard", false);
            entriesState[dash] = true;
            entries.push(dash);
        }
    }

    //tasks
    function _addTasksMenu() {
        Menus.push(TASKS_MENU_ITEMS);
        MenusIncludes[TASKS_MENU_ITEMS] = ['/Tasks', '/Logger/Scheduler'];

        //log
        var log = BuildMenuItem(TASKS_MENU_ITEMS, "Log", $('#LeftSideLocalizationString_TaskLog').val(), 1, 'Logger\\Scheduler',  "fa fa-file-code", false);
        entries.push(log);
        entriesState[log] = true;

        //list
        var list = BuildMenuItem(TASKS_MENU_ITEMS, "List", $('#LeftSideLocalizationString_TaksList').val(), 1, 'Tasks\\List', "fa fa-list-ul", false);
        entries.push(list);
        entriesState[list] = true;
    }

    //views
    function _addworkJordersMenu() {
        Menus.push(WORK_ORDER_MENU_ITEMS);
        MenusIncludes[WORK_ORDER_MENU_ITEMS] = ['/WorkOrders'];

        //orders list
        let list = BuildMenuItem(WORK_ORDER_MENU_ITEMS, "List", $('#LeftSideMenuAdditional_OrdersList').val(), 1, "WorkOrders", "fa fa-list-alt", false);
        entriesState[list] = true;
        entries.push(list);

        //orders list
        let crt = BuildMenuItem(WORK_ORDER_MENU_ITEMS, "Create", $('#LeftSideMenuAdditional_CreateOrder').val(), 1, "WorkOrders\\Create", "fa fa-plus", false);
        entriesState[crt] = true;
        entries.push(crt);
    }

    /*Add menus here*/
    function AddItemsToMenu() {
        _addAdditionalMenu();
        _addServicesMenu();
        _addReportingMenu();
        _addViewsMenu();
        _addTasksMenu();
        _addworkJordersMenu();
        _addGeneralMenu();
    }

    function MenuClickEvents() {
        Menus.forEach(e => { $('#' + e).click(() => { ShowEntries(e); }); });
    }

    function HamburgerMenuEvent() {
        $('#MenuHamburger').on('click', function () {
            if ($('#SideMenu').width() >= 250) {
                itemsList.forEach(function (element) {
                    ChangeMenuItemLevel(element, 0);
                    ShowMenuItemChevron(element, true);
                });

                Menus.forEach((e) => { ShowMenuItemChevron($('#' + e), true); });

            }
            else {
                var i = 0;
                itemsList.forEach(function (element) {
                    ChangeMenuItemLevel(element, itemsLevel[i]);
                    ShowMenuItemChevron(element, false);
                    i++;
                });
                Menus.forEach(e => { ShowMenuItemChevron($('#' + e), false); });
            }

        });
    }

    $(document).ready(function () {
        AddItemsToMenu();
        MenuClickEvents();
        HamburgerMenuEvent();
        CheckIncludes();
    });
}