﻿$(document).ready(() => {
    var focused = true;
    var reqID = null;
    let separator = `<hr style="margin: 3px;" />`;

    function GetRow(text, time, icon, color, url, cancel, cancelUrl) {
        let template = `<li>
                            <div style="margin-left: 1em; margin-right: 1em;">
                                <a href="${url}">
                                    <i class="${icon}" style="margin-right: 5px; width: 20px; color: ${color}"></i>
                                    <mark>${time}</mark> ${text}
                                </a>
                                ${(cancel ? `<i class="fas fa-times bgtaskcancelBtn" data-cancel="${cancelUrl}" style="margin-top: 5px; margin-right: -10px; width: 20px; color: tomato;"></i>` : "")}
                            </div>
                        </li>`

        return template;
    }

    function GetTasks() {
        if (focused) {
            $.ajax({
                type: "POST",
                async: true,
                url: `/BackgroundTasks`,
                success: function (response) {
                    if (response !== null && response.success === true) {
                        let rows = [];
                        let completed = 0;

                        $('.bgtaskcancelBtn').unbind();

                        for (var i = 0; i < response.tasks.length; i++) {
                            let task = response.tasks[i];
                            rows.push(GetRow(task.Title, task.Time, task.Icon, task.Color, task.Link, task.IsCancelButton, task.PostCancel));

                            if (i < response.tasks.length && response.tasks.length > 1)
                                rows.push(separator);

                            if (task.Completed)
                                completed++;
                        }

                        //counter
                        $('#BackgroundNotificatorTasksCounter').text(completed);
                        if (completed == 0) {
                            $('#BackgroundNotificatorTasksCounter').hide();
                        }
                        else {
                            $('#BackgroundNotificatorTasksCounter').show();
                        }

                        //tasks
                        if (rows.length == 0) {
                            $('#BackgroundNotificatorTasks').hide();
                            $('#BackgroundNotificatorTasksContent').empty();
                        }
                        else {
                            $('#BackgroundNotificatorTasks').show();
                            $('#BackgroundNotificatorTasksContent').html(rows.join(''));

                            $('.bgtaskcancelBtn').on('click', function () {
                                console.log('click');
                                console.log($(this).data('cancel'));
                                $.ajax({
                                    type: "POST",
                                    url: $(this).data('cancel'),
                                    traditional: true,
                                    success: function (response) { }
                                });
                            });
                        }

                        reqID = setTimeout(GetTasks, 2000);
                    }
                }
            });
        }
    }

    //got focus
    document.addEventListener('visibilitychange', function (ev) {
        let old = focused;
        focused = document.visibilityState == 'visible';

        if (!old && focused) {
            GetTasks();
        }
        else {
            clearTimeout(reqID);
        }
    });

    GetTasks();
});