﻿$(document).ready(() => {
    let order = null;
    let state = null;

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);
    }

    function UpdateButtonsUI() {
        if (order == null) {
            $("#btnDetails").attr("disabled", true);
            $("#btnEdit").attr("disabled", true);
            $("#btnDelete").attr("disabled", true);
            $("#btnCancel").attr("disabled", true);
        }
        else {
            $("#btnDetails").attr("disabled", false);

            $("#btnEdit").attr("disabled", !(state == 0 || state == 1));
            $("#btnDelete").attr("disabled", (state == 0 || state == 1));
            $("#btnCancel").attr("disabled", !(state == 0 || state == 1));
        }
    }

    function AttachEventsMainTable() {
        var header = document.getElementById("servicesHead");                 //for sticky head
        var sticky = header.offsetTop;

        //event for show go top button
        $(window).on("scroll", function () {
            //for sticky head
            if (window.pageYOffset > (sticky + 100)) {
                header.classList.add("sticky");
            } else {
                header.classList.remove("sticky");
            }
        });

        /*table events*/
        $('#tariscope-orders tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                order = null;
                state = null;
            }
            else {
                order = $(this).find('td[data-name="ID"]').text();
                state = $(this).find('td[data-name="StateCode"]').text() * 1;
                $('#tariscope-orders tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtonsUI();
        });

        $('th').on('click', function () {
            $.ajax({
                type: "POST",
                url: '/WorkOrders/SetSort?colName=' + encodeURIComponent($(this).data('thname')),
                traditional: true,
                success: function (response) {
                    if (response != null && response.success == true) {
                        Load();
                    }
                }
            });
        });

        UpdateButtonsUI();
    }

    function Load() {
        let url = `/WorkOrders/Load/?Search=${encodeURIComponent($('#tbSearch').val())}`;
        url += `&From=${encodeURIComponent($('#datetimepickerFrom').data('date'))}&To=${encodeURIComponent($('#datetimepickerTo').data('date'))}&FromEnabled=${$('#PeriodFromEnable').prop('checked')}&ToEnabled=${$('#PeriodToEnable').prop('checked')}`;
        url += `&New=${$('#TypeNew').prop('checked')}`;
        url += `&InAction=${$('#TypeInAction').prop('checked')}`;
        url += `&Canceled=${$('#TypeCanceled').prop('checked')}`;
        url += `&Completed=${$('#TypeCompleted').prop('checked')}`;

        $('#ordersTable').load(url, AttachEventsMainTable);
    }

    function PrepareFilter() {
        $('input[type="hidden"][name="PeriodFromEnable"][value="false"]').remove();
        $('input[type="hidden"][name="PeriodToEnable"][value="false"]').remove();

        $('input[type="hidden"][name="TypeNew"][value="false"]').remove();
        $('input[type="hidden"][name="TypeInAction"][value="false"]').remove();
        $('input[type="hidden"][name="TypeInActionExpired"][value="false"]').remove();
        $('input[type="hidden"][name="TypeCompleted"][value="false"]').remove();
        $('input[type="hidden"][name="TypeCanceled"][value="false"]').remove();

        $('#TypeNew').prop('checked', true);
        $('#TypeInAction').prop('checked', true);
        $('#TypeInActionExpired').prop('checked', true);
    }

    function Export(t) {

        console.log("export to " + t);

        ShowSpinner(true);
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");

        let url = `/WorkOrders/Export/?type=${t}&?Search=${encodeURIComponent($('#tbSearch').val())}`;
        url += `&From=${encodeURIComponent($('#datetimepickerFrom').data('date'))}&To=${encodeURIComponent($('#datetimepickerTo').data('date'))}&FromEnabled=${$('#PeriodFromEnable').prop('checked')}&ToEnabled=${$('#PeriodToEnable').prop('checked')}`;
        url += `&New=${$('#TypeNew').prop('checked')}`;
        url += `&InAction=${$('#TypeInAction').prop('checked')}`;
        url += `&Canceled=${$('#TypeCanceled').prop('checked')}`;
        url += `&Completed=${$('#TypeCompleted').prop('checked')}`;

        $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: url,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/DamagedDays/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export filed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                }
                ShowSpinner(false);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                alert(xhr.status);
                alert(thrownError);
            }
        });
    }

    //create a new order
    $('#btnAdd').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/WorkOrders/HasEmployee',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    window.location = '/WorkOrders/Create/';
                }
                else {
                    $('#noEmployeeModal').modal('show');
                }
            }
        });
    });

    //show modal to filter
    $('#btnFilter').on('click', () => { $('#FilterOrderModal').modal('show'); });

    //checked from
    $('#PeriodFromEnable').change(() => {
        if ($('#PeriodFromEnable').prop('checked')) {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
        }
        else {
            $('#datetimepickerFrom').data("DateTimePicker").setDate(null);
        }
    });

    //checked to
    $('#PeriodToEnable').change(() => {
        if ($('#PeriodToEnable').prop('checked')) {
            $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
        }
        else {
            $('#datetimepickerTo').data("DateTimePicker").setDate(null);
        }
    });

    //apply filter
    $('#ApplyFilterBtn').on('click', Load);

    //show modal to cancel work order
    $('#btnCancel').on('click', () => { $('#ConfirmCancelOrderModal').modal('show') });

    //confrim cancel the order
    $('#ConfirmCancelBtn').on('click', () => {
        ShowSpinner(true);

        $.ajax({
            type: "POST",
            url: '/WorkOrders/Cancel/' + order,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                Load();
            }
        });
    });

    //show modal to delete order
    $('#btnDelete').on('click', () => { $('#confirmDelete').modal('show'); });

    //confirm delete order
    $('#DeleteConfirm').on('click', () => {
        $.ajax({
            type: "POST",
            url: '/WorkOrders/Delete/' + order,
            traditional: true,
            success: function (response) {
                if (response !== null) {
                    $('#confirmDelete').modal('hide');
                    Load();
                }
            }
        });
    });

    //show details
    $('#btnDetails').on('click', () => {
        ShowSpinner(true);

        let row = $(`tr[data-order="${order}"]`);

        $('#DetailsOrderModalTitle').text($(row).find('td[data-name="Title"]').text());
        $('#OrderCode').text($(row).find('td[data-name="Code"]').text());
        $('#OrderRecDate').text($(row).find('td[data-name="RecDate"]').text());
        $('#OrderDeadline').text($(row).find('td[data-name="Deadline"]').text());
        $('#OrderStartDate').text($(row).find('td[data-name="StartWork"]').text());
        $('#OrderEndDate').text($(row).find('td[data-name="EndWork"]').text());
        $('#OrderResponsible').text($(row).find('td[data-name="ResponsiblePerson"]').text());

        $.ajax({
            type: "POST",
            url: '/WorkOrders/Details/' + order,
            traditional: true,
            success: function (response) {
                ShowSpinner(false);
                $('#OrderDescription').val(response.desc);
                $('#OrderPerformers').val(response.perfs);
                $('#OrderLinked').val(response.linked);

                if (response.endcomment) {
                    $('#OrderEndComment').val(response.endcomment);
                    $('#OrderEndCommentSection').show();
                }
                else {
                    $('#OrderEndCommentSection').hide();
                }

                $('#DetailsOrderModal').modal('show');
            }
        });
    });

    //edit
    $('#btnEdit').on('click', () => { window.location = '/WorkOrders/Update/' + order; });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    initDateTimepickers();
    PrepareFilter();
    Load();
});