﻿$(document).ready(() => {
    let selectedRowName = null;
    let selectedRowText = null;
    let clusterize;
    let windowHeight;

    let ClasterSize = 50;
    let Loadsize = ClasterSize * 10;
    let LoadedRows = 0;
    let request = null;
    let requestForExport = null;

    function Export(t) {

        if (requestForExport !== null) {
            console.log("Export in action, try later");
            return;
        }

        console.log("export to " + t);

        $('#exportingProgressError').hide();
        $('#exportingProgress').show();
        /*function for download file with exported data*/

        console.log("call Export('" + t + "')");


        requestForExport = $.ajax({
            type: "POST",
            async: true,
            cache: false,
            timeout: 600000,
            url: '/TariscopeViews/Details/Export/?type=' + t + '&count=' + LoadedRows,
            traditional: true,
            success: function (response) {
                $('#exportingProgress').hide();

                if (response !== null && response.success === true) {
                    console.log("Export successfully!");
                    console.log("call DownloadExport('" + response.ExportFilePath + "' , '" + t + "')");

                    window.open('/TariscopeViews/Details/DownloadExport/?file=' + response.ExportFilePath + '&type=' + t, '_blank');

                    console.log("Download completed!");
                }
                else {
                    console.log("Export failed! Message: " + response.Message + "\nStackTrace: " + response.StackTrace);
                    $('#exportingProgressError').show();
                }

                requestForExport = null;
            },
            error: function (xhr, ajaxOptions, thrownError) {
                requestForExport = null;
                console.log(`${ajaxOptions} ${xhr.status} - ${thrownError}`);
                $('#exportingProgress').hide();
                $('#exportingProgressError').show();
            }
        });
    }

    function LoadCalls() {
        $('#viewsRowsTable').load("/TariscopeViews/Details/Read/" + Loadsize, AttachEventsToTable);
    }

    function LoadCallsAfter() {
        $('#viewsRowsTable').load("/TariscopeViews/Details/ReadAfter/" + Loadsize, AttachEventsToTable);
    }

    function LoadPartialCalls() {
        request = $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/ReadPartial/' + LoadedRows + '/' + Loadsize,
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {

                    if ($('#btnHeadTop').prop('disabled') === true) {//top orientation
                        clusterize.append(response.rows);
                    }
                    else {//left orientation
                        let i = 0;
                        for (key in response.rows) {
                            $($('#contentArea').children()[i++]).append(response.rows[key]);
                        }
                    }

                    UpdateCount(response.showLimit, response.loaded);

                    if (response.loaded === false) {
                        LoadPartialCalls();
                    }

                }
            }
        });
    }

    function SetHeight() {
        windowHeight = window.innerHeight -
            $('.main-header').outerHeight() -
            $('.content-header').outerHeight() -
            $('.box-header').outerHeight() -
            $('#totalData').outerHeight() -
            $('.main-footer').outerHeight();

        if (windowHeight < 400)
            windowHeight = 400;

        $('.clusterize-scroll').css('max-height', windowHeight + 'px');
    }

    function UpdateCount(rowlimited = false, loaded = false) {
        //update informaiton about rows count
        if ($('#btnHeadTop').prop('disabled') === true) {
            LoadedRows = clusterize.getRowsAmount();
        }
        else {
            LoadedRows = $($('#contentArea').children()[0]).children().length - 1;
        }

        $('#totalLines').text(LoadedRows);

        $('#ForLoadMore').hide();

        if (loaded === true) {
            $('#loadedLabel').show();

            if (rowlimited === true) {
                $('#ForLoadMore').show();
            }
        }
        else {
            $('#loadedLabel').hide();

            if (rowlimited === true) {
                $('#ForLoadMore').hide();
            }
        }

        SetHeight();
    }

    function UpdateButtons() {
        if (selectedRowName === null) {
            $('#btnFilterEq').prop('disabled', true);
            $('#btnFilterNotEq').prop('disabled', true);
            $('#btnSearch').prop('disabled', true);
        }
        else {
            $('#btnFilterEq').prop('disabled', false);
            $('#btnFilterNotEq').prop('disabled', false);
            $('#btnSearch').prop('disabled', false);
        }

        let current = $('#CurrentFilterIndex').val() * 1;
        let count = $('#CountFilters').val() * 1;

        $('#btnFilterPrev').prop('disabled', current < 0);
        $('#btnFilterNext').prop('disabled', current === (count - 1));
        $('#btnFilterClear').prop('disabled', count === 0);

        $('#btnDropSearch').prop('disabled', $('#SearchFilters').val() * 1 === 0);
    }

    function AttachEventsToTable() {

        clusterize = new Clusterize({
            scrollId: 'scrollArea',
            contentId: 'contentArea',
            rows_in_block: ClasterSize
        });

        $('#contentArea').on('click', 'td', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedRowName = null;
                selectedRowText = null;
            }
            else {
                selectedRowName = $(this).data('name');
                selectedRowText = $(this).text();
                $('#contentArea td.selected').removeClass('selected');
                $(this).addClass('selected');
            }

            UpdateButtons();
        });

        selectedRowName = null;
        selectedRowText = null;
        LoadedRows = 0;

        SetHeight();
        ShowSpinner(false);

        UpdateButtons();
        UpdateCount();
        LoadPartialCalls();
    }

    //resize window
    $(window).resize(() => {
        SetHeight();
        clusterize.refresh();
    });

    //load other calls
    $('#disableRowLimit').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/DisableRowLimit',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#ForLoadMore').hide();
                    $('#loadedLabel').hide();
                    LoadPartialCalls();
                }
            }
        });
    });

    //set head position
    $('#btnHeadTop').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/SetHeadTop',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    Loadsize = Loadsize * 50;
                    $('#btnHeadTop').prop('disabled', true);
                    $('#btnHeadLeft').prop('disabled', false);
                    LoadCallsAfter();
                }
            }
        });
    });
    $('#btnHeadLeft').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/SetHeadLeft',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    Loadsize = Loadsize / 50;
                    ShowSpinner(true);
                    $('#btnHeadTop').prop('disabled', false);
                    $('#btnHeadLeft').prop('disabled', true);
                    LoadCallsAfter();
                }
            }
        });
    });

    //set head position
    $('#btnShowEmpty').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/SetShowEmpty',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    $('#btnShowEmpty').prop('disabled', true);
                    $('#btnHideEmpty').prop('disabled', false);
                    LoadCallsAfter();
                }
            }
        });
    });
    $('#btnHideEmpty').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/SetHideEmpty',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    $('#btnShowEmpty').prop('disabled', false);
                    $('#btnHideEmpty').prop('disabled', true);
                    LoadCallsAfter();
                }
            }
        });
    });

    //open modal for select fields
    $('#btnFilterSelectColls').on('click', () => {
        $('#FieldsContainer').load('/TariscopeViews/Details/GetFields', () => { $('#FieldsEditor').modal('show'); });
    });

    //open view with new fields
    $('#btnSaveFields').on('click', () => {
        LoadedRows = 0;
        if (request !== null) {
            request.abort();
        }

        $('#FieldsEditor').modal('hide');
        ShowSpinner(true);

        var f = $("[id^='field_']");
        var v = [];

        f.map(function (e) {
            if ($(f[e]).prop('checked'))
                v.push($(f[e]).data('field'));
        });

        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/SetFields/?Fields=' + v.join(','),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });

    //equal,not equal and clear fielter
    $('#btnFilterEq').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/AddEqualFilter/?FieldName=' + encodeURIComponent(selectedRowName) + '&FieldValue=' + encodeURIComponent(selectedRowText),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });
    $('#btnFilterNotEq').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/AddNotEqualFilter/?FieldName=' + encodeURIComponent(selectedRowName) + '&FieldValue=' + encodeURIComponent(selectedRowText),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });
    $('#btnFilterClear').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/ClearFilter/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });

    //got to next or prev filter
    $('#btnFilterNext').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/NextFilter/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });
    $('#btnFilterPrev').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/PrevFilter/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });

    //open modal for search
    $('#btnSearch').on('click', () => {
        $('#searchText').val('');
        $('#searchSource').val($('option:first', $('#searchSource')).val());
        $('#searchFullWord').prop('checked', false);
        $('#searchReg').prop('checked', false);
        $('#btnConfirmSearch').prop('disabled', true);
        $('#emptySearch').hide();
        $('option:first', $('#searchSource')).text(selectedRowName);
        $('#searchModal').modal('show');
    });

    //show error when empty search param
    $('#searchText').on('input', function () {
        if (!$(this).val() || !$(this).val().trim()) {
            $('#emptySearch').slideDown('fast');
            $('#btnConfirmSearch').attr('disabled', true);
        }
        else {
            $('#emptySearch').slideUp('fast');
            $('#btnConfirmSearch').attr('disabled', false);
        }
    });

    //confirm search
    $('#btnConfirmSearch').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/Search/?SearchParam=' + encodeURIComponent($('#searchText').val()) +
                '&ColumnName=' + encodeURIComponent(selectedRowName) +
                '&Source=' + $('#searchSource').val() +
                '&Full=' + $('#searchFullWord').prop('checked') +
                '&Reg=' + $('#searchReg').prop('checked'),
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    $('#searchModal').modal('hide');
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });

    //reset search
    $('#btnDropSearch').on('click', () => {
        $.ajax({
            type: "POST",
            async: true,
            url: '/TariscopeViews/Details/ResetSearch/',
            traditional: true,
            success: function (response) {
                if (response !== null && response.success === true) {
                    ShowSpinner(true);
                    LoadCallsAfter();
                }
            }
        });
    });

    /*attach events for export*/
    $('#ExportEXCEL').on('click', function () { Export("xlsx"); });
    $('#ExportHTML').on('click', function () { Export("html"); });
    $('#ExportCSV').on('click', function () { Export("csv"); });
    $('#ExportPDF').on('click', function () { Export("pdf"); });

    ShowSpinner(true);
    LoadCalls();

    setTimeout(() => {
        if (window.innerWidth > 767)
            $('#MenuHamburger').click();
    }, 500);
});