﻿$(document).ready(function () {
    let selectedSDHidden;
    let selectedSDDisplay;
    let SDmode;

    function initDateTimepickers() {
        //init all datetimepickers
        var daytimeOpitions = {
            todayHighlight: true,
            autoclose: true,
            daysOfWeekDisabled: "0",
            daysOfWeekHighlighted: "0",
            language: $('#LocaleThread').val(),//navigator.language,
            locale: $('#LocaleThread').val(),//navigator.language,
            useCurrent: false,
            showClear: true,
            showClose: true,
            allowInputToggle: true
        };

        $('#datetimepickerFrom').datetimepicker(daytimeOpitions);
        $('#datetimepickerTo').datetimepicker(daytimeOpitions);
    }

    function AttachEventsForSDTables() {
        //attach events to table with destination and source
        $('#tariscope-SDD tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
                selectedSDHidden = '';
                selectedSDDisplay = '';
            }
            else {
                if ($(this).data('name') !== 'SDDataNonSelect') {
                    selectedSDHidden = $(this).find('td[data-name="SDDataHidden"]').text();
                    selectedSDDisplay = $(this).find('td[data-name="SDDataDisplay"]').text();
                    $('#tariscope-SDD tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            }
        });
        //search of a subscriber
        let inputs = $('#tariscope-SDD').find('input');

        if (inputs.length) {
            let search = $(inputs[0]);
            search.val('');
            search.unbind();
            search.on('input', () => {
                let str = search.val();

                if (!str || !str.trim()) {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        $(this).show();
                    });
                }
                else {
                    $('#tariscope-SDD').find('tbody').find('tr').each(function () {
                        if ($(this).find('td[data-name="SDDataDisplay"]').text().toLowerCase().includes(str.toLowerCase())) {
                            $(this).show();
                        }
                        else {
                            $(this).hide();
                        }
                    });
                }
            });
        }
    }

    function InitServiceInput() {
        $('#Services').select2({ theme: "bootstrap", placeholder: $('#txtServices').val() });
    }

    function LoadAbonents() {
        //load abonents
        $('#sourceDestTitle').text($('#txtAbonents').val());

        $('#modalContainer').load('/TariscopeViews/GetAbonents/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
            AttachEventsForSDTables();
            ShowSpinner(false);
            $('#containerModal').modal('show');
        });
    }

    //function LoadDevices() {
    //    //load devices
    //    $('#sourceDestTitle').text($('#txtDevices').val());

    //    $('#modalContainer').load('/TariscopeViews/GetDevices/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
    //        ShowSpinner(false);
    //        $('#containerModal').modal('show');
    //    });
    //}

    function LoadDevices() {
        //load departments. A device means a subscriber's group
        $('#sourceDestTitle').text($('#txtDevices').val());

        $('#modalContainer').load('/TariscopeViews/GetDepartments/?devices=' + encodeURIComponent($('#ViewDevicesHidden').val()), function () {
            AttachEventsForSDTables();
            ShowSpinner(false);
            $('#containerModal').modal('show');
        });
    }

    //show section for enter a custom view period
    $('#ViewPeriod').change(function () {
        let selectedValue = $(this).val() * 1;

        switch (selectedValue) {
            case 9:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').show();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 10:
                $('#CustomPeriodSection').slideUp('fast');
                $('#SelectedMonth').hide();
                $('#SelectedYearMonthSection').slideDown('fast');
                break;
            case 11:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideDown('fast');

                try {
                    $('#datetimepickerFrom').data("DateTimePicker").setDate(new Date());
                    $('#datetimepickerTo').data("DateTimePicker").setDate(new Date());
                } catch (e) { }
                break;
            default:
                $('#SelectedYearMonthSection').slideUp('fast');
                $('#CustomPeriodSection').slideUp('fast');
                break;
        }

    });

    //load abonents
    $('#btnEditAbonents').on('click', () => {
        ShowSpinner(true);
        SDmode = 1;
        LoadAbonents();
    });

    //select devices
    $('#btnEditDevices').on('click', function () {
        ShowSpinner(true);
        SDmode = 2;
        LoadDevices();
    });

    //select source or destination
    $('#btnSelectSD').on('click', function () {
        if (SDmode === 1) {
            $('#AbonentTextHidden').val(selectedSDHidden);
            $('#AbonentText').val(selectedSDDisplay);
        }
        else {
            $('#ViewDevices').val('');
            $('#ViewDevicesHidden').val('');

            let dh = [];
            let dv = []

            var devc = $("[id^='SelectedDevice_']");
            devc.map(function (e) {
                if ($(devc[e]).prop('checked') === true) {
                    dh.push($(devc[e]).data('device'));
                    dv.push($(devc[e]).data('name'));
                }
            });

            try {
                $('#ViewDevices').val(dv.join());
                $('#ViewDevicesHidden').val(dh.join());
            } catch (e) { }
        }
    });

    //Group selection
    $('#btnSelectSD2').on('click', function () {
        if (SDmode === 1) {
            $('#AbonentTextHidden').val(selectedSDHidden);
            $('#AbonentText').val(selectedSDDisplay);
        }
        else {
            $('#ViewDevicesHidden').val(selectedSDHidden);
            $('#ViewDevices').val(selectedSDDisplay);
        }
    });

    //resize window
    $(window).on('resize', InitServiceInput);

    //show prebuild sql script
    $('#btnShowSql').on('click', function () {
        $('#warningSQLAlert').hide();
        $('#btnPreSaveSQL').show()
        $('#btnSaveSQL').hide();

        $.ajax({
            type: "POST",
            url: '/TariscopeViews/GETSQL2/',
            data: $('#ViewFrom').serialize(),
            traditional: true,
            success: function (response) {
                if (response != null && response.success == true) {
                    $('#sqlContainer').load("/TariscopeViews/GetSQLEditor/?sql=" + encodeURIComponent(response.sql), function () {
                        $('#SQLEditor').modal('show');
                    });
                }
            }
        });
    });

    $('#SQLEditor, #containerModal').on('hidden.bs.modal', function () {
        setTimeout(function () { $('body').css('padding-right', 0) }, 500);
    });

    //show message wneh user try save sql
    $('#btnPreSaveSQL').on('click', function () {
        $('#warningSQLAlert').slideDown('fast');
        $('#btnPreSaveSQL').hide();
        $('#btnSaveSQL').show();
    });

    //save custom sal filter
    $('#btnSaveSQL').on('click', function () {
        window.location = '/TariscopeViews/NewServicesFilterSQL/?ViewName' + encodeURIComponent($('#ViewName').val()) +
            '&RowLimit=' + $('#RowLimit').val() +
            '&SQL=' + encodeURIComponent(window.SQLEditor.getValue());
    });

    //open fileds to edit
    $('#btnFieldsEdit').on('click', () => {
        if ($('#FieldsContainer').is(':empty')) {
            $('#FieldsContainer').load('/TariscopeViews/GetFieldsForEmpty?Type=1', () => {
                //move buttons (top down)
                $('.tcxField').mouseover(function () {
                    $(this).append($('#btnsTopDown'));
                });

                //mode top
                $('#btnMoveTcxFieldTop').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let PrevElement = $(this).parent().parent().prev();

                    if (PrevElement.length > 0) {
                        let ExpectPrevNumber = $(PrevElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let PrevInput = $(InputToMove).prev();
                        let RealPrevNumber = (PrevInput.length > 0 ? ($(PrevInput).val() * 1) : -1);

                        $(CurrentElement).insertBefore($(PrevElement));

                        if (ExpectPrevNumber === RealPrevNumber)
                            $(InputToMove).insertBefore(PrevInput);
                    }
                });

                //mode down
                $('#btnMoveTcxFieldDown').on('click', function () {
                    let CurrentNumber = $(this).parent().parent().find('input').attr('enumnumber') * 1;
                    let CurrentElement = $(this).parent().parent();
                    let NextElement = $(this).parent().parent().next();

                    if (NextElement.length > 0) {
                        let ExpectNextNumber = $(NextElement).find('input').attr('enumnumber') * 1;
                        let InputToMove = $('input[name="Fields[' + CurrentNumber + ']"]');
                        let NextInput = $(InputToMove).next();
                        let RealNextNumber = (NextInput.length > 0 ? ($(NextInput).val() * 1) : -1);

                        $(CurrentElement).insertAfter($(NextElement));

                        if (ExpectNextNumber === RealNextNumber)
                            $(InputToMove).insertAfter(NextInput);
                    }
                });

                $('#FieldsEditor').modal('show');
            });
        }
        else {
            $('#FieldsEditor').modal('show');
        }
    });

    //save fields
    $('#btnSaveFields').on('click', () => {
        var f = $("[id^='field_']");
        var v = [];

        f.map(function (e) {
            if ($(f[e]).prop('checked'))
                v.push($(f[e]).data('field'));
        });

        $('#Fields').val(v.join());
    });

    $('#btnSaveSQL').hide();
    initDateTimepickers();
    InitServiceInput();
});